/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.server;

import io.helidon.common.HelidonFeatures;
import io.helidon.common.HelidonFlavor;
import io.helidon.config.Config;
import io.helidon.microprofile.server.JaxRsApplication;
import io.helidon.webserver.jersey.JerseySupport;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.annotation.Priority;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.Initialized;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.inject.spi.WithAnnotations;
import javax.ws.rs.Path;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.eclipse.microprofile.config.ConfigProvider;
import org.glassfish.jersey.server.ResourceConfig;

public class JaxRsCdiExtension
implements Extension {
    private static final Logger LOGGER = Logger.getLogger(JaxRsCdiExtension.class.getName());
    private final List<JaxRsApplication> applicationMetas = new LinkedList<JaxRsApplication>();
    private final Set<Class<? extends Application>> applications = new LinkedHashSet<Class<? extends Application>>();
    private final Set<Class<?>> resources = new HashSet();
    private final Set<Class<?>> providers = new HashSet();
    private final AtomicBoolean setInStone = new AtomicBoolean(false);

    private void collectApplications(@Observes ProcessAnnotatedType<? extends Application> applicationType) {
        this.applications.add(applicationType.getAnnotatedType().getJavaClass());
    }

    private void collectResourceClasses(@Observes @WithAnnotations(value={Path.class}) ProcessAnnotatedType<?> resourceType) {
        Class resourceClass = resourceType.getAnnotatedType().getJavaClass();
        if (resourceClass.isInterface()) {
            return;
        }
        LOGGER.finest(() -> "Discovered resource class " + resourceClass.getName());
        this.resources.add(resourceClass);
    }

    private void collectProviderClasses(@Observes @WithAnnotations(value={Provider.class}) ProcessAnnotatedType<?> providerType) {
        Class providerClass = providerType.getAnnotatedType().getJavaClass();
        if (providerClass.isInterface()) {
            LOGGER.finest(() -> "Discovered @Provider interface " + providerClass.getName() + ", ignored as we only support classes");
            return;
        }
        LOGGER.finest(() -> "Discovered @Provider class " + providerClass.getName());
        this.providers.add(providerClass);
    }

    void fixApps(@Observes @Priority(value=0) @Initialized(value=ApplicationScoped.class) Object event) {
        this.setInStone.set(true);
    }

    public List<JaxRsApplication> applicationsToRun() throws IllegalStateException {
        if (!this.setInStone.get()) {
            throw new IllegalStateException("Applications are not yet fixed. This method is only available in @Initialized(ApplicationScoped.class) event, before server is started");
        }
        HashSet allClasses = new HashSet();
        allClasses.addAll(this.resources);
        allClasses.addAll(this.providers);
        if (this.applications.isEmpty() && this.applicationMetas.isEmpty() && !this.resources.isEmpty()) {
            this.addSyntheticApp(allClasses);
        }
        this.applicationMetas.addAll(this.applications.stream().map(appClass -> JaxRsApplication.builder().applicationClass((Class<? extends Application>)appClass).config(ResourceConfig.forApplicationClass((Class)appClass, (Set)allClasses)).build()).collect(Collectors.toList()));
        this.applications.clear();
        this.resources.clear();
        return this.applicationMetas;
    }

    public void removeApplications() throws IllegalStateException {
        this.mutateApps();
        this.applications.clear();
    }

    public void removeResourceClasses() throws IllegalStateException {
        this.mutateApps();
        this.resources.clear();
    }

    public void addResourceClasses(List<Class<?>> resourceClasses) throws IllegalStateException {
        this.mutateApps();
        this.resources.addAll(resourceClasses);
    }

    public void addApplications(List<JaxRsApplication> applications) throws IllegalStateException {
        this.mutateApps();
        this.applicationMetas.addAll(applications);
    }

    public void addApplication(Application application) throws IllegalStateException {
        this.mutateApps();
        this.applicationMetas.add(JaxRsApplication.create(application));
    }

    public void addApplication(String contextRoot, Application application) throws IllegalStateException {
        this.mutateApps();
        this.applicationMetas.add(JaxRsApplication.builder().application(application).contextRoot(contextRoot).build());
    }

    public String serviceName() {
        org.eclipse.microprofile.config.Config config = ConfigProvider.getConfig();
        return config.getOptionalValue("service.name", String.class).or(() -> config.getOptionalValue("tracing.service", String.class)).or(this::guessServiceName).orElse("helidon-mp");
    }

    private Optional<String> guessServiceName() {
        if (this.applicationMetas.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(this.applicationMetas.get(0).appName());
    }

    public void addSyntheticApplication(List<Class<?>> resourceClasses) throws IllegalStateException {
        this.mutateApps();
        this.addSyntheticApp(resourceClasses);
    }

    private void addSyntheticApp(Collection<Class<?>> resourceClasses) {
        final Set<Class<?>> classes = Set.copyOf(resourceClasses);
        this.applicationMetas.add(JaxRsApplication.builder().synthetic(true).applicationClass(Application.class).config(ResourceConfig.forApplication((Application)new Application(){

            public Set<Class<?>> getClasses() {
                return classes;
            }
        })).appName("HelidonMP").build());
    }

    JerseySupport toJerseySupport(Supplier<? extends ExecutorService> defaultExecutorService, JaxRsApplication jaxRsApplication) {
        JerseySupport.Builder builder = JerseySupport.builder((Application)jaxRsApplication.resourceConfig());
        builder.config(((Config)ConfigProvider.getConfig()).get("server.jersey"));
        builder.executorService(jaxRsApplication.executorService().orElseGet(defaultExecutorService));
        builder.register((Object)new ExceptionMapper<Exception>(){

            public Response toResponse(Exception exception) {
                if (exception instanceof WebApplicationException) {
                    return ((WebApplicationException)exception).getResponse();
                }
                LOGGER.log(Level.WARNING, exception, () -> "Internal server error");
                return Response.serverError().build();
            }
        });
        return builder.build();
    }

    Optional<String> findContextRoot(Config config, JaxRsApplication jaxRsApplication) {
        return config.get(jaxRsApplication.appClassName() + ".routing-path.path").asString().or(jaxRsApplication::contextRoot).map(path -> path.startsWith("/") ? path : "/" + path);
    }

    Optional<String> findNamedRouting(Config config, JaxRsApplication jaxRsApplication) {
        return config.get(jaxRsApplication.appClassName() + ".routing-name.name").asString().or(jaxRsApplication::routingName).flatMap(it -> "@default".equals(it) ? Optional.empty() : Optional.of(it));
    }

    boolean isNamedRoutingRequired(Config config, JaxRsApplication jaxRsApplication) {
        return (Boolean)config.get(jaxRsApplication.appClassName() + ".routing-name.required").asBoolean().orElseGet(jaxRsApplication::routingNameRequired);
    }

    private void mutateApps() {
        if (this.setInStone.get()) {
            throw new IllegalStateException("You are attempting to modify applications in JAX-RS after they were registered with the server");
        }
    }

    static {
        HelidonFeatures.register((HelidonFlavor)HelidonFlavor.MP, (String[])new String[]{"JAX-RS"});
    }
}

