/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.server;

import java.util.LinkedList;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessInjectionTarget;
import javax.ws.rs.Path;
import javax.ws.rs.core.Application;
import javax.ws.rs.ext.Provider;

public class ServerCdiExtension
implements Extension {
    private final List<Class<?>> resourceClasses = new LinkedList();
    private final List<Class<?>> providerClasses = new LinkedList();
    private final List<Class<? extends Application>> applications = new LinkedList<Class<? extends Application>>();

    public <T> void gatherApplications(@Observes ProcessInjectionTarget<T> pit) {
        AnnotatedType at = pit.getAnnotatedType();
        boolean applicationScoped = at.isAnnotationPresent(ApplicationScoped.class);
        Class theClass = at.getJavaClass();
        if (applicationScoped && Application.class.isAssignableFrom(theClass)) {
            this.applications.add(theClass);
        } else if (at.isAnnotationPresent(Path.class)) {
            if (applicationScoped || at.isAnnotationPresent(RequestScoped.class) || at.isAnnotationPresent(Dependent.class)) {
                this.resourceClasses.add(theClass);
            }
        } else if (at.isAnnotationPresent(Provider.class)) {
            this.providerClasses.add(theClass);
        }
    }

    List<Class<? extends Application>> getApplications() {
        return this.applications;
    }

    List<Class<?>> getResourceClasses() {
        return this.resourceClasses;
    }

    List<Class<?>> getProviderClasses() {
        return this.providerClasses;
    }
}

