/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.server;

import io.helidon.microprofile.server.Server;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.logging.LogManager;
import java.util.logging.Logger;

public final class Main {
    private static final String LOGGING_FILE = "logging.properties";
    private static int port = 0;

    private Main() {
    }

    public static void main(String[] args) {
        try {
            Main.configureLogging();
        }
        catch (IOException e) {
            System.err.println("Failed to configure logging");
            e.printStackTrace();
        }
        Server server = Server.create();
        server.start();
        port = server.port();
    }

    private static void configureLogging() throws IOException {
        String source;
        String configClass = System.getProperty("java.util.logging.config.class");
        String configPath = System.getProperty("java.util.logging.config.file");
        if (configClass != null) {
            source = "class: " + configClass;
        } else if (configPath != null) {
            Path path = Paths.get(configPath, new String[0]);
            source = path.toAbsolutePath().toString();
        } else {
            source = Main.findAndConfigureLogging();
        }
        Logger.getLogger(Main.class.getName()).info("Logging configured using " + source);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String findAndConfigureLogging() throws IOException {
        BufferedInputStream logConfigStream;
        String source = "defaults";
        Path path = Paths.get("", new String[0]).resolve(LOGGING_FILE);
        if (Files.exists(path, new LinkOption[0])) {
            logConfigStream = new BufferedInputStream(Files.newInputStream(path, new OpenOption[0]));
            source = "file: " + path.toAbsolutePath();
        } else {
            InputStream resourceStream = Main.class.getResourceAsStream("/logging.properties");
            if (null != resourceStream) {
                logConfigStream = new BufferedInputStream(resourceStream);
                source = "classpath: /logging.properties";
            } else {
                logConfigStream = null;
            }
        }
        if (null != logConfigStream) {
            try {
                LogManager.getLogManager().readConfiguration(logConfigStream);
            }
            finally {
                ((InputStream)logConfigStream).close();
            }
        }
        return source;
    }

    public static int serverPort() {
        return port;
    }
}

