/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.restclient;

import io.helidon.common.context.Contexts;
import io.helidon.microprofile.restclient.HelidonInboundHeaderProvider;
import java.lang.reflect.Field;
import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;
import org.eclipse.microprofile.rest.client.RestClientBuilder;
import org.eclipse.microprofile.rest.client.spi.RestClientListener;

public class MpRestClientListener
implements RestClientListener {
    private static final System.Logger LOGGER = System.getLogger(MpRestClientListener.class.getName());

    public void onNewClient(Class<?> aClass, RestClientBuilder restClientBuilder) {
        try {
            Field execServiceField = restClientBuilder.getClass().getDeclaredField("executorService");
            execServiceField.setAccessible(true);
            Supplier existingSupplier = (Supplier)execServiceField.get(restClientBuilder);
            Supplier<ExecutorService> newSupplier = () -> MpRestClientListener.lambda$onNewClient$0((Supplier)existingSupplier);
            execServiceField.set(restClientBuilder, newSupplier);
        }
        catch (Exception e) {
            LOGGER.log(System.Logger.Level.DEBUG, "Failed to replace executor service for a REST Client: " + String.valueOf(aClass), (Throwable)e);
        }
        restClientBuilder.register((Object)new HelidonInboundHeaderProvider());
    }

    private static /* synthetic */ ExecutorService lambda$onNewClient$0(Supplier existingSupplier) {
        return Contexts.wrap((ExecutorService)((ExecutorService)existingSupplier.get()));
    }
}

