/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.openapi;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.util.Map;
import java.util.Set;
import org.eclipse.microprofile.openapi.models.Extensible;
import org.eclipse.microprofile.openapi.models.Reference;
import org.yaml.snakeyaml.introspector.BeanAccess;
import org.yaml.snakeyaml.introspector.MethodProperty;
import org.yaml.snakeyaml.introspector.Property;
import org.yaml.snakeyaml.introspector.PropertyUtils;

class ExtendedPropertyUtils
extends PropertyUtils {
    private static final Map<Class<?>, InferredProperty> TYPE_INFO = Map.of(Extensible.class, InferredProperty.create("extensions"), Reference.class, InferredProperty.create("ref"));

    ExtendedPropertyUtils() {
    }

    public Set<Property> getProperties(Class<?> type, BeanAccess bAccess) {
        Set result = super.getProperties(type, bAccess);
        TYPE_INFO.forEach((t, info) -> {
            if (t.isAssignableFrom(type)) {
                result.add(info.property(type));
            }
        });
        return result;
    }

    protected Map<String, Property> getPropertiesMap(Class<?> type, BeanAccess bAccess) {
        Map result = super.getPropertiesMap(type, bAccess);
        TYPE_INFO.forEach((t, info) -> {
            if (t.isAssignableFrom(type)) {
                result.put(info.propertyName, info.property(type));
            }
        });
        return result;
    }

    private record InferredProperty(String propertyName) {
        static InferredProperty create(String propertyName) {
            return new InferredProperty(propertyName);
        }

        Property property(Class<?> type) {
            String capitalizedPropertyName = this.propertyName.substring(0, 1).toUpperCase() + this.propertyName.substring(1);
            try {
                return new MethodProperty(new PropertyDescriptor(this.propertyName, type, "get" + capitalizedPropertyName, "set" + capitalizedPropertyName));
            }
            catch (IntrospectionException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

