/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.openapi;

import io.helidon.microprofile.server.JaxRsApplication;
import io.smallrye.openapi.api.OpenApiConfig;
import io.smallrye.openapi.api.OpenApiConfigImpl;
import io.smallrye.openapi.runtime.scanner.FilteredIndexView;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.Application;
import jakarta.ws.rs.core.Feature;
import jakarta.ws.rs.ext.Provider;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UncheckedIOException;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.microprofile.config.Config;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.CompositeIndex;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Index;
import org.jboss.jandex.IndexReader;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Indexer;

class FilteredIndexViewsBuilder {
    private static final System.Logger LOGGER = System.getLogger(FilteredIndexViewsBuilder.class.getName());
    private final Config config;
    private final FilteredIndexView view;
    private final List<JaxRsApplication> apps;
    private final Set<String> requiredClasses;
    private final boolean useJaxRsSemantics;

    FilteredIndexViewsBuilder(Config config, List<JaxRsApplication> apps, Set<Class<?>> types, List<String> indexPaths, boolean useJaxRsSemantics) {
        this.config = config;
        this.view = new FilteredIndexView(FilteredIndexViewsBuilder.indexView(indexPaths, apps, types), (OpenApiConfig)new OpenApiConfigImpl(config));
        this.apps = apps;
        this.requiredClasses = FilteredIndexViewsBuilder.requiredClassNames((IndexView)this.view);
        this.useJaxRsSemantics = useJaxRsSemantics;
    }

    List<FilteredIndexView> buildViews() {
        return this.apps.stream().filter(app -> app.applicationClass().isPresent()).sorted(Comparator.comparing(app -> ((Class)app.applicationClass().get()).getName())).map(this::map).toList();
    }

    private FilteredIndexView map(JaxRsApplication app) {
        Application application = app.resourceConfig().getApplication();
        Set singletons = application.getSingletons().stream().map(Object::getClass).map(Class::getName).collect(Collectors.toSet());
        Set classes = application.getClasses().stream().map(Class::getName).collect(Collectors.toSet());
        String appClassName = FilteredIndexViewsBuilder.className(app);
        HashSet<String> explicitClassNames = new HashSet<String>(classes);
        explicitClassNames.addAll(singletons);
        if (explicitClassNames.isEmpty() && this.apps.size() == 1) {
            if (LOGGER.isLoggable(System.Logger.Level.TRACE)) {
                LOGGER.log(System.Logger.Level.TRACE, String.format("No filtering required for %s which reports no explicitly referenced classes and is the only JAX-RS application", appClassName));
            }
            return this.view;
        }
        if (classes.isEmpty() && (singletons.isEmpty() || !this.useJaxRsSemantics) && this.apps.size() == 1) {
            if (LOGGER.isLoggable(System.Logger.Level.TRACE)) {
                LOGGER.log(System.Logger.Level.TRACE, String.format("No filtering required for %s because JAX-RS semantics is disabled", appClassName));
            }
            return this.view;
        }
        Set<String> excludedClasses = this.excludedClasses(app, explicitClassNames);
        FilteringOpenApiConfigImpl filteringOpenApiConfig = new FilteringOpenApiConfigImpl(this.config, excludedClasses);
        FilteredIndexView result = new FilteredIndexView((IndexView)this.view, (OpenApiConfig)filteringOpenApiConfig);
        if (LOGGER.isLoggable(System.Logger.Level.TRACE)) {
            LOGGER.log(System.Logger.Level.TRACE, String.format("FilteredIndexView for %n  application class %s%n  with explicitly-referenced classes %s%n  yields exclude list: %s%n  and known classes: %n  %s", appClassName, explicitClassNames, excludedClasses, String.join((CharSequence)("," + System.lineSeparator() + "    "), FilteredIndexViewsBuilder.knownClassNames(result))));
        }
        return result;
    }

    private Set<String> excludedClasses(JaxRsApplication app, Set<String> explicitClasses) {
        String appClass = FilteredIndexViewsBuilder.className(app);
        Set<String> result = this.apps.stream().map(FilteredIndexViewsBuilder::className).filter(name -> !name.equals("<unknown>") && !name.equals(appClass)).collect(Collectors.toSet());
        if (!explicitClasses.isEmpty()) {
            result.addAll(this.requiredClasses);
            result.removeAll(explicitClasses);
        }
        return result;
    }

    private static String className(JaxRsApplication app) {
        return app.applicationClass().map(Class::getName).orElse("<unknown>");
    }

    private static Set<String> requiredClassNames(IndexView indexView) {
        HashSet<String> result = new HashSet<String>(FilteredIndexViewsBuilder.annotatedClassNames(indexView, Path.class));
        result.addAll(FilteredIndexViewsBuilder.annotatedClassNames(indexView, Provider.class));
        result.addAll(FilteredIndexViewsBuilder.annotatedClassNames(indexView, Feature.class));
        if (LOGGER.isLoggable(System.Logger.Level.DEBUG)) {
            LOGGER.log(System.Logger.Level.DEBUG, "Ancillary classes: {0}", result);
        }
        return result;
    }

    private static Set<String> annotatedClassNames(IndexView indexView, Class<?> annotationClass) {
        return indexView.getAnnotations(DotName.createSimple((String)annotationClass.getName())).stream().map(AnnotationInstance::target).filter(target -> target.kind() == AnnotationTarget.Kind.CLASS).map(AnnotationTarget::asClass).filter(classInfo -> FilteredIndexViewsBuilder.hasImplementationOrIsIncluded(indexView, classInfo)).map(ClassInfo::toString).collect(Collectors.toSet());
    }

    private static boolean hasImplementationOrIsIncluded(IndexView indexView, ClassInfo classInfo) {
        if (!Modifier.isInterface(classInfo.flags())) {
            return true;
        }
        return indexView.getAllKnownImplementors(classInfo.name()).stream().anyMatch(info -> !Modifier.isAbstract(info.flags()));
    }

    private static List<String> knownClassNames(FilteredIndexView filteredIndexView) {
        return filteredIndexView.getKnownClasses().stream().map(ClassInfo::toString).sorted().toList();
    }

    private static IndexView indexView(List<String> indexPaths, List<JaxRsApplication> apps, Set<Class<?>> types) {
        try {
            List<URL> urls = FilteredIndexViewsBuilder.findIndexFiles(indexPaths);
            if (urls.isEmpty()) {
                LOGGER.log(System.Logger.Level.INFO, "Could not locate the Jandex index file META-INF/jandex.idx, building an in-memory index...\nConsider using the Jandex maven plug-in during your build to add it to your app.");
                return FilteredIndexViewsBuilder.buildIndex(apps, types);
            }
            return FilteredIndexViewsBuilder.loadIndex(indexPaths);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static IndexView loadIndex(List<String> indexPaths) throws IOException {
        ArrayList<Index> indices = new ArrayList<Index>();
        for (URL url : FilteredIndexViewsBuilder.findIndexFiles(indexPaths)) {
            try {
                InputStream is = url.openStream();
                try {
                    LOGGER.log(System.Logger.Level.TRACE, "Adding Jandex index at {0}", url.toString());
                    indices.add(new IndexReader(is).read());
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
            catch (Exception ex) {
                throw new IOException(String.format("Attempted to read from previously-located index file %s but the index cannot be read", url), ex);
            }
        }
        return indices.size() == 1 ? (IndexView)indices.get(0) : CompositeIndex.create(indices);
    }

    private static IndexView buildIndex(List<JaxRsApplication> apps, Set<Class<?>> types) throws IOException {
        Indexer indexer = new Indexer();
        for (Class<?> c : types) {
            FilteredIndexViewsBuilder.indexClass(indexer, c);
        }
        apps.stream().map(JaxRsApplication::applicationClass).flatMap(Optional::stream).forEach(cls -> FilteredIndexViewsBuilder.indexClass(indexer, cls));
        LOGGER.log(System.Logger.Level.TRACE, "Using internal Jandex index created from CDI bean discovery");
        Index result = indexer.complete();
        FilteredIndexViewsBuilder.dumpIndex(result);
        return result;
    }

    private static void indexClass(Indexer indexer, Class<?> c) {
        try {
            indexer.indexClass(c);
        }
        catch (IOException ex) {
            throw new UncheckedIOException(String.format("Cannot load bytecode from class %s for annotation processing", c), ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void dumpIndex(Index index) {
        if (LOGGER.isLoggable(System.Logger.Level.DEBUG)) {
            LOGGER.log(System.Logger.Level.DEBUG, "Dump of internal Jandex index:");
            PrintStream oldStdout = System.out;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try (PrintStream newPS = new PrintStream((OutputStream)baos, true, Charset.defaultCharset());){
                System.setOut(newPS);
                index.printAnnotations();
                index.printSubclasses();
                LOGGER.log(System.Logger.Level.DEBUG, baos.toString(Charset.defaultCharset()));
            }
            finally {
                System.setOut(oldStdout);
            }
        }
    }

    private static List<URL> findIndexFiles(List<String> paths) {
        ArrayList<URL> result = new ArrayList<URL>();
        for (String path : paths) {
            try {
                Enumeration<URL> urls = Thread.currentThread().getContextClassLoader().getResources(path);
                while (urls.hasMoreElements()) {
                    result.add(urls.nextElement());
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    private static class FilteringOpenApiConfigImpl
    extends OpenApiConfigImpl {
        private final Set<String> classesToExclude;

        FilteringOpenApiConfigImpl(Config config, Set<String> classesToExclude) {
            super(config);
            this.classesToExclude = classesToExclude;
        }

        public Set<String> scanExcludeClasses() {
            return this.classesToExclude;
        }
    }
}

