/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.openapi;

import io.helidon.config.Config;
import io.helidon.microprofile.openapi.MpOpenApiFeature;
import io.helidon.microprofile.openapi.OpenApiCdiExtension;
import io.helidon.microprofile.server.JaxRsApplication;
import io.helidon.openapi.OpenApiFeature;
import io.smallrye.openapi.api.OpenApiConfig;
import io.smallrye.openapi.api.OpenApiConfigImpl;
import io.smallrye.openapi.runtime.scanner.FilteredIndexView;
import jakarta.enterprise.inject.spi.CDI;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.Application;
import jakarta.ws.rs.core.Feature;
import jakarta.ws.rs.ext.Provider;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.CompositeIndex;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Index;
import org.jboss.jandex.IndexReader;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Indexer;

class MPOpenAPIBuilder
extends OpenApiFeature.Builder<MPOpenAPIBuilder, MpOpenApiFeature> {
    private static final System.Logger LOGGER = System.getLogger(MPOpenAPIBuilder.class.getName());
    static final String MP_OPENAPI_CONFIG_PREFIX = "mp.openapi";
    private static final String USE_JAXRS_SEMANTICS_CONFIG_KEY = "use-jaxrs-semantics";
    private static final String USE_JAXRS_SEMANTICS_FULL_CONFIG_KEY = "mp.openapi.extensions.helidon.use-jaxrs-semantics";
    private static final boolean USE_JAXRS_SEMANTICS_DEFAULT = true;
    private OpenApiConfig openApiConfig;
    private org.eclipse.microprofile.config.Config mpConfig;
    private String[] indexPaths;
    private int indexURLCount;
    private boolean useJaxRsSemantics = true;

    MPOpenAPIBuilder() {
    }

    public MpOpenApiFeature build() {
        List<URL> indexURLs = this.findIndexFiles(this.indexPaths);
        this.indexURLCount = indexURLs.size();
        if (indexURLs.isEmpty()) {
            LOGGER.log(System.Logger.Level.INFO, String.format("OpenAPI feature could not locate the Jandex index file %s so will build an in-memory index.\nThis slows your app start-up and, depending on CDI configuration, might omit some type information needed for a complete OpenAPI document.\nConsider using the Jandex maven plug-in during your build to create the index and add it to your app.", "META-INF/jandex.idx"));
        }
        if (this.openApiConfig == null) {
            this.openApiConfig = new OpenApiConfigImpl(this.mpConfig);
        }
        return new MpOpenApiFeature(this);
    }

    public MPOpenAPIBuilder config(Config config) {
        super.config(config);
        return (MPOpenAPIBuilder)this.identity();
    }

    public MPOpenAPIBuilder openApiConfig(OpenApiConfig openApiConfig) {
        this.openApiConfig = openApiConfig;
        return this;
    }

    IndexView indexView() {
        try {
            return this.indexURLCount > 0 ? this.existingIndexFileReader() : this.indexFromHarvestedClasses();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    OpenApiConfig openApiConfig() {
        return this.openApiConfig;
    }

    protected System.Logger logger() {
        return LOGGER;
    }

    MPOpenAPIBuilder config(org.eclipse.microprofile.config.Config mpConfig) {
        this.mpConfig = mpConfig;
        this.useJaxRsSemantics = mpConfig.getOptionalValue(USE_JAXRS_SEMANTICS_FULL_CONFIG_KEY, Boolean.class).orElse(true);
        return this.openApiConfig((OpenApiConfig)new OpenApiConfigImpl(mpConfig));
    }

    MPOpenAPIBuilder indexPaths(String ... indexPaths) {
        this.indexPaths = indexPaths;
        return (MPOpenAPIBuilder)this.identity();
    }

    private FilteredIndexView filteredIndexView(FilteredIndexView viewFilteredByConfig, List<JaxRsApplication> jaxRsApplications, JaxRsApplication jaxRsApp, Set<String> ancillaryClassNames) {
        Application app = jaxRsApp.resourceConfig().getApplication();
        Set classesFromGetSingletons = app.getSingletons().stream().map(Object::getClass).map(Class::getName).collect(Collectors.toSet());
        Set classesFromGetClasses = app.getClasses().stream().map(Class::getName).collect(Collectors.toSet());
        String appClassName = MPOpenAPIBuilder.toClassName(jaxRsApp);
        HashSet<String> classesExplicitlyReferenced = new HashSet<String>(classesFromGetClasses);
        classesExplicitlyReferenced.addAll(classesFromGetSingletons);
        if (classesExplicitlyReferenced.isEmpty() && jaxRsApplications.size() == 1) {
            if (LOGGER.isLoggable(System.Logger.Level.TRACE)) {
                LOGGER.log(System.Logger.Level.TRACE, String.format("No filtering required for %s which reports no explicitly referenced classes and is the only JAX-RS application", appClassName));
            }
            return viewFilteredByConfig;
        }
        if (classesFromGetClasses.isEmpty() && (classesFromGetSingletons.isEmpty() || !this.useJaxRsSemantics) && jaxRsApplications.size() == 1) {
            if (LOGGER.isLoggable(System.Logger.Level.TRACE)) {
                LOGGER.log(System.Logger.Level.TRACE, String.format("No filtering required for %s; although it returns a non-empty set from getSingletons, JAX-RS semantics has been turned off for OpenAPI processing using %s", appClassName, USE_JAXRS_SEMANTICS_FULL_CONFIG_KEY));
            }
            return viewFilteredByConfig;
        }
        Set<String> excludedClasses = MPOpenAPIBuilder.classNamesToIgnore(jaxRsApplications, jaxRsApp, ancillaryClassNames, classesExplicitlyReferenced);
        FilteredIndexView result = new FilteredIndexView((IndexView)viewFilteredByConfig, (OpenApiConfig)new FilteringOpenApiConfigImpl(this.mpConfig, excludedClasses));
        if (LOGGER.isLoggable(System.Logger.Level.TRACE)) {
            String knownClassNames = result.getKnownClasses().stream().map(ClassInfo::toString).sorted().collect(Collectors.joining("," + System.lineSeparator() + "    "));
            LOGGER.log(System.Logger.Level.TRACE, String.format("FilteredIndexView for %n  application class %s%n  with explicitly-referenced classes %s%n  yields exclude list: %s%n  and known classes: %n  %s", appClassName, classesExplicitlyReferenced, excludedClasses, knownClassNames));
        }
        return result;
    }

    private static String toClassName(JaxRsApplication jaxRsApplication) {
        return jaxRsApplication.applicationClass().map(Class::getName).orElse("<unknown>");
    }

    private static Set<String> classNamesToIgnore(List<JaxRsApplication> jaxRsApplications, JaxRsApplication jaxRsApp, Set<String> ancillaryClassNames, Set<String> classesExplicitlyReferenced) {
        String appClassName = MPOpenAPIBuilder.toClassName(jaxRsApp);
        Set<String> result = jaxRsApplications.stream().map(MPOpenAPIBuilder::toClassName).filter(candidateName -> !candidateName.equals("<unknown>") && !candidateName.equals(appClassName)).collect(Collectors.toSet());
        if (!classesExplicitlyReferenced.isEmpty()) {
            result.addAll(ancillaryClassNames);
            result.removeAll(classesExplicitlyReferenced);
        }
        return result;
    }

    private static boolean isConcrete(ClassInfo classInfo) {
        return !Modifier.isAbstract(classInfo.flags());
    }

    List<FilteredIndexView> buildPerAppFilteredIndexViews() {
        List jaxRsApplications = MpOpenApiFeature.jaxRsApplicationsToRun().stream().filter(jaxRsApp -> jaxRsApp.applicationClass().isPresent()).sorted(Comparator.comparing(jaxRsApplication -> ((Class)jaxRsApplication.applicationClass().get()).getName())).collect(Collectors.toList());
        IndexView indexView = this.indexView();
        FilteredIndexView viewFilteredByConfig = new FilteredIndexView(indexView, (OpenApiConfig)new OpenApiConfigImpl(this.mpConfig));
        Set<String> ancillaryClassNames = MPOpenAPIBuilder.ancillaryClassNames((IndexView)viewFilteredByConfig);
        return jaxRsApplications.stream().map(jaxRsApp -> this.filteredIndexView(viewFilteredByConfig, jaxRsApplications, (JaxRsApplication)jaxRsApp, ancillaryClassNames)).collect(Collectors.toList());
    }

    private static Set<String> ancillaryClassNames(IndexView indexView) {
        HashSet<String> result = new HashSet<String>(MPOpenAPIBuilder.resourceClassNames(indexView));
        result.addAll(MPOpenAPIBuilder.providerClassNames(indexView));
        result.addAll(MPOpenAPIBuilder.featureClassNames(indexView));
        if (LOGGER.isLoggable(System.Logger.Level.DEBUG)) {
            LOGGER.log(System.Logger.Level.DEBUG, "Ancillary classes: {0}", result);
        }
        return result;
    }

    private static Set<String> resourceClassNames(IndexView indexView) {
        return MPOpenAPIBuilder.annotatedClassNames(indexView, Path.class);
    }

    private static Set<String> providerClassNames(IndexView indexView) {
        return MPOpenAPIBuilder.annotatedClassNames(indexView, Provider.class);
    }

    private static Set<String> featureClassNames(IndexView indexView) {
        return MPOpenAPIBuilder.annotatedClassNames(indexView, Feature.class);
    }

    private static Set<String> annotatedClassNames(IndexView indexView, Class<?> annotationClass) {
        return indexView.getAnnotations(DotName.createSimple((String)annotationClass.getName())).stream().map(AnnotationInstance::target).filter(target -> target.kind() == AnnotationTarget.Kind.CLASS).map(AnnotationTarget::asClass).filter(classInfo -> MPOpenAPIBuilder.hasImplementationOrIsIncluded(indexView, classInfo)).map(ClassInfo::toString).collect(Collectors.toSet());
    }

    private static boolean hasImplementationOrIsIncluded(IndexView indexView, ClassInfo classInfo) {
        return !Modifier.isInterface(classInfo.flags()) || indexView.getAllKnownImplementors(classInfo.name()).stream().anyMatch(MPOpenAPIBuilder::isConcrete);
    }

    private IndexView existingIndexFileReader() throws IOException {
        ArrayList<Index> indices = new ArrayList<Index>();
        for (URL indexURL : this.findIndexFiles(this.indexPaths)) {
            try {
                InputStream indexIS = indexURL.openStream();
                try {
                    LOGGER.log(System.Logger.Level.TRACE, "Adding Jandex index at {0}", indexURL.toString());
                    indices.add(new IndexReader(indexIS).read());
                }
                finally {
                    if (indexIS == null) continue;
                    indexIS.close();
                }
            }
            catch (Exception ex) {
                throw new IOException("Attempted to read from previously-located index file " + String.valueOf(indexURL) + " but the index cannot be read", ex);
            }
        }
        return indices.size() == 1 ? (IndexView)indices.get(0) : CompositeIndex.create(indices);
    }

    private IndexView indexFromHarvestedClasses() throws IOException {
        Indexer indexer = new Indexer();
        this.annotatedTypes().forEach(c -> this.addClassToIndexer(indexer, (Class<?>)c));
        MpOpenApiFeature.jaxRsApplicationsToRun().stream().map(JaxRsApplication::applicationClass).filter(Optional::isPresent).forEach(appClassOpt -> this.addClassToIndexer(indexer, (Class)appClassOpt.get()));
        LOGGER.log(System.Logger.Level.TRACE, "Using internal Jandex index created from CDI bean discovery");
        Index result = indexer.complete();
        MPOpenAPIBuilder.dumpIndex(System.Logger.Level.DEBUG, result);
        return result;
    }

    private void addClassToIndexer(Indexer indexer, Class<?> c) {
        try (InputStream is = MpOpenApiFeature.contextClassLoader().getResourceAsStream(MPOpenAPIBuilder.resourceNameForClass(c));){
            if (is != null) {
                indexer.index(is);
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(String.format("Cannot load bytecode from class %s at %s for annotation processing", c.getName(), MPOpenAPIBuilder.resourceNameForClass(c)), ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void dumpIndex(System.Logger.Level level, Index index) {
        if (LOGGER.isLoggable(level)) {
            LOGGER.log(level, "Dump of internal Jandex index:");
            PrintStream oldStdout = System.out;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try (PrintStream newPS = new PrintStream((OutputStream)baos, true, Charset.defaultCharset());){
                System.setOut(newPS);
                index.printAnnotations();
                index.printSubclasses();
                LOGGER.log(level, baos.toString(Charset.defaultCharset()));
            }
            finally {
                System.setOut(oldStdout);
            }
        }
    }

    private static String resourceNameForClass(Class<?> c) {
        return c.getName().replace('.', '/') + ".class";
    }

    private List<URL> findIndexFiles(String ... indexPaths) {
        ArrayList<URL> result = new ArrayList<URL>();
        for (String indexPath : indexPaths) {
            Enumeration<URL> urls = null;
            try {
                urls = MpOpenApiFeature.contextClassLoader().getResources(indexPath);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            while (urls.hasMoreElements()) {
                result.add(urls.nextElement());
            }
        }
        return result;
    }

    private Set<Class<?>> annotatedTypes() {
        return ((OpenApiCdiExtension)CDI.current().getBeanManager().getExtension(OpenApiCdiExtension.class)).annotatedTypes();
    }

    private static class FilteringOpenApiConfigImpl
    extends OpenApiConfigImpl {
        private final Set<String> classesToExclude;

        FilteringOpenApiConfigImpl(org.eclipse.microprofile.config.Config config, Set<String> classesToExclude) {
            super(config);
            this.classesToExclude = classesToExclude;
        }

        public Set<String> scanExcludeClasses() {
            return this.classesToExclude;
        }
    }
}

