/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.openapi;

import io.helidon.microprofile.server.JaxRsApplication;
import io.helidon.microprofile.server.JaxRsCdiExtension;
import io.helidon.openapi.OpenAPISupport;
import io.smallrye.openapi.api.OpenApiConfig;
import io.smallrye.openapi.api.OpenApiConfigImpl;
import io.smallrye.openapi.runtime.scanner.FilteredIndexView;
import java.lang.reflect.InvocationTargetException;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.enterprise.inject.spi.CDI;
import javax.ws.rs.core.Application;
import org.eclipse.microprofile.config.Config;
import org.jboss.jandex.IndexView;

public final class MPOpenAPIBuilder
extends OpenAPISupport.Builder {
    private Optional<OpenApiConfig> openAPIConfig;
    private Optional<IndexView> indexView;
    private List<FilteredIndexView> perAppFilteredIndexViews = null;
    private Config mpConfig;

    public OpenApiConfig openAPIConfig() {
        return this.openAPIConfig.get();
    }

    public synchronized List<FilteredIndexView> perAppFilteredIndexViews() {
        if (this.perAppFilteredIndexViews == null) {
            this.perAppFilteredIndexViews = this.buildPerAppFilteredIndexViews();
        }
        return this.perAppFilteredIndexViews;
    }

    static List<Application> appInstancesToRun() {
        JaxRsCdiExtension ext = (JaxRsCdiExtension)CDI.current().getBeanManager().getExtension(JaxRsCdiExtension.class);
        List appsToRun = ext.applicationsToRun();
        return appsToRun.stream().filter(MPOpenAPIBuilder::isNonSynthetic).map(MPOpenAPIBuilder::appInstance).flatMap(Optional::stream).collect(Collectors.toList());
    }

    private List<FilteredIndexView> buildPerAppFilteredIndexViews() {
        Supplier<List> defaultResultSupplier = () -> List.of(new FilteredIndexView(this.indexView.get(), this.openAPIConfig.get()));
        List appClassesToScan = MPOpenAPIBuilder.appInstancesToRun().stream().sorted(Comparator.comparing(app -> app.getClass().getName())).map(this::classesToScanForApp).collect(Collectors.toList());
        if (appClassesToScan.size() <= 1) {
            return defaultResultSupplier.get();
        }
        return appClassesToScan.stream().map(this::appRelatedClassesToFilteredIndexView).collect(Collectors.toList());
    }

    private static boolean isNonSynthetic(JaxRsApplication jaxRsApp) {
        return !jaxRsApp.synthetic();
    }

    private static Optional<? extends Application> appInstance(JaxRsApplication jaxRsApp) {
        Application preexistingApp = jaxRsApp.resourceConfig().getApplication();
        return preexistingApp != null ? Optional.of(preexistingApp) : jaxRsApp.applicationClass().flatMap(MPOpenAPIBuilder::instantiate);
    }

    private <T extends Application> Set<Class<?>> classesToScanForApp(Application app) {
        HashSet result = new HashSet();
        result.add(app.getClass());
        result.addAll(app.getClasses());
        app.getSingletons().stream().map(Object::getClass).forEach(result::add);
        return result;
    }

    private FilteredIndexView appRelatedClassesToFilteredIndexView(Set<Class<?>> appRelatedClassesToScan) {
        OpenApiConfigImpl openAPIFilteringConfig = new OpenApiConfigImpl(this.mpConfig);
        Set scanClasses = openAPIFilteringConfig.scanClasses();
        scanClasses.clear();
        openAPIFilteringConfig.scanPackages().clear();
        appRelatedClassesToScan.stream().map(Class::getName).forEach(scanClasses::add);
        FilteredIndexView result = new FilteredIndexView(this.indexView.get(), (OpenApiConfig)openAPIFilteringConfig);
        return result;
    }

    private MPOpenAPIBuilder openAPIConfig(OpenApiConfig config) {
        this.openAPIConfig = Optional.of(config);
        return this;
    }

    MPOpenAPIBuilder config(Config mpConfig) {
        this.mpConfig = mpConfig;
        this.openAPIConfig((OpenApiConfig)new OpenApiConfigImpl(mpConfig));
        return this;
    }

    private static Optional<? extends Application> instantiate(Class<? extends Application> appClass) {
        try {
            return Optional.of(appClass.getConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            return Optional.empty();
        }
    }

    public MPOpenAPIBuilder indexView(IndexView indexView) {
        this.indexView = Optional.of(indexView);
        return this;
    }

    public void validate() throws IllegalStateException {
        if (!this.openAPIConfig.isPresent()) {
            throw new IllegalStateException("OpenApiConfig has not been set in MPBuilder");
        }
    }
}

