/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.openapi;

import io.helidon.config.Config;
import io.helidon.microprofile.cdi.RuntimeStart;
import io.helidon.microprofile.openapi.MPOpenAPIBuilder;
import io.helidon.microprofile.server.RoutingBuilders;
import io.helidon.openapi.OpenAPISupport;
import io.helidon.webserver.Routing;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Priority;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.Initialized;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.DeploymentException;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import org.jboss.jandex.CompositeIndex;
import org.jboss.jandex.Index;
import org.jboss.jandex.IndexReader;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Indexer;

public class OpenApiCdiExtension
implements Extension {
    private static final String INDEX_PATH = "META-INF/jandex.idx";
    private static final Logger LOGGER = Logger.getLogger(OpenApiCdiExtension.class.getName());
    private final List<URL> indexURLs;
    private final Set<Class<?>> annotatedTypes = new HashSet();
    private org.eclipse.microprofile.config.Config mpConfig;
    private Config config;

    public OpenApiCdiExtension() throws IOException {
        this(INDEX_PATH);
    }

    OpenApiCdiExtension(String ... indexPaths) throws IOException {
        this.indexURLs = this.findIndexFiles(indexPaths);
        if (this.indexURLs.isEmpty()) {
            LOGGER.log(Level.INFO, () -> String.format("OpenAPI support could not locate the Jandex index file %s so will build an in-memory index.%nThis slows your app start-up and, depending on CDI configuration, might omit some type information needed for a complete OpenAPI document.%nConsider using the Jandex maven plug-in during your build to create the index and add it to your app.", INDEX_PATH));
        }
    }

    private void configure(@Observes @RuntimeStart Config config) {
        this.mpConfig = (org.eclipse.microprofile.config.Config)config;
        this.config = config;
    }

    void registerOpenApi(@Observes @Priority(value=4000) @Initialized(value=ApplicationScoped.class) Object event, BeanManager bm) {
        try {
            Config openapiNode = this.config.get("openapi");
            OpenAPISupport openApiSupport = new MPOpenAPIBuilder().config(this.mpConfig).indexView(this.indexView()).config(openapiNode).build();
            openApiSupport.configureEndpoint((Routing.Rules)RoutingBuilders.create((Config)openapiNode).routingBuilder());
        }
        catch (IOException e) {
            throw new DeploymentException("Failed to obtain index view", (Throwable)e);
        }
    }

    private <X> void processAnnotatedType(@Observes ProcessAnnotatedType<X> event) {
        if (this.indexURLs.isEmpty()) {
            Class c = event.getAnnotatedType().getJavaClass();
            this.annotatedTypes.add(c);
        }
    }

    public IndexView indexView() throws IOException {
        return !this.indexURLs.isEmpty() ? this.existingIndexFileReader() : this.indexFromHarvestedClasses();
    }

    private IndexView existingIndexFileReader() throws IOException {
        ArrayList<Index> indices = new ArrayList<Index>();
        for (URL indexURL : this.indexURLs) {
            try {
                InputStream indexIS = indexURL.openStream();
                try {
                    LOGGER.log(Level.CONFIG, "Adding Jandex index at {0}", indexURL.toString());
                    indices.add(new IndexReader(indexIS).read());
                }
                finally {
                    if (indexIS == null) continue;
                    indexIS.close();
                }
            }
            catch (IOException ex) {
                throw new IOException("Attempted to read from previously-located index file " + indexURL + " but the file cannot be found", ex);
            }
        }
        return indices.size() == 1 ? (IndexView)indices.get(0) : CompositeIndex.create(indices);
    }

    private IndexView indexFromHarvestedClasses() throws IOException {
        Indexer indexer = new Indexer();
        for (Class<?> c : this.annotatedTypes) {
            try {
                InputStream is = OpenApiCdiExtension.contextClassLoader().getResourceAsStream(OpenApiCdiExtension.resourceNameForClass(c));
                try {
                    indexer.index(is);
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
            catch (IOException ex) {
                throw new IOException("Cannot load bytecode from class " + c.getName() + " at " + OpenApiCdiExtension.resourceNameForClass(c) + " for annotation processing", ex);
            }
        }
        LOGGER.log(Level.CONFIG, "Using internal Jandex index created from CDI bean discovery");
        Index result = indexer.complete();
        OpenApiCdiExtension.dumpIndex(Level.FINER, result);
        return result;
    }

    private List<URL> findIndexFiles(String ... indexPaths) throws IOException {
        ArrayList<URL> result = new ArrayList<URL>();
        for (String indexPath : indexPaths) {
            Enumeration<URL> urls = OpenApiCdiExtension.contextClassLoader().getResources(indexPath);
            while (urls.hasMoreElements()) {
                result.add(urls.nextElement());
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void dumpIndex(Level level, Index index) throws UnsupportedEncodingException {
        if (LOGGER.isLoggable(level)) {
            LOGGER.log(level, "Dump of internal Jandex index:");
            PrintStream oldStdout = System.out;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try (PrintStream newPS = new PrintStream((OutputStream)baos, true, Charset.defaultCharset().name());){
                System.setOut(newPS);
                index.printAnnotations();
                index.printSubclasses();
                LOGGER.log(level, baos.toString(Charset.defaultCharset().name()));
            }
            finally {
                System.setOut(oldStdout);
            }
        }
    }

    private static ClassLoader contextClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    private static String resourceNameForClass(Class<?> c) {
        return c.getName().replace('.', '/') + ".class";
    }
}

