/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.security;

import io.helidon.common.HelidonServiceLoader;
import io.helidon.common.LazyValue;
import io.helidon.common.context.Contexts;
import io.helidon.common.uri.UriPath;
import io.helidon.common.uri.UriQuery;
import io.helidon.config.mp.MpConfig;
import io.helidon.http.PathMatcher;
import io.helidon.http.PathMatchers;
import io.helidon.microprofile.security.FeatureConfig;
import io.helidon.microprofile.security.JerseySecurityContext;
import io.helidon.microprofile.security.SecurityDefinition;
import io.helidon.microprofile.security.SecurityFilterContext;
import io.helidon.microprofile.security.spi.SecurityResponseMapper;
import io.helidon.security.AuthenticationResponse;
import io.helidon.security.AuthorizationResponse;
import io.helidon.security.EndpointConfig;
import io.helidon.security.Security;
import io.helidon.security.SecurityClientBuilder;
import io.helidon.security.SecurityEnvironment;
import io.helidon.security.SecurityResponse;
import io.helidon.security.SecurityTime;
import io.helidon.security.integration.common.AtnTracing;
import io.helidon.security.integration.common.AtzTracing;
import io.helidon.security.integration.common.SecurityTracing;
import io.helidon.tracing.SpanContext;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.SecurityContext;
import jakarta.ws.rs.core.UriInfo;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.glassfish.jersey.server.ContainerRequest;

abstract class SecurityFilterCommon {
    static final String PROP_FILTER_CONTEXT = "io.helidon.security.jersey.FilterContext";
    private static final List<SecurityResponseMapper> RESPONSE_MAPPERS = HelidonServiceLoader.builder(ServiceLoader.load(SecurityResponseMapper.class)).build().asList();
    private static final LazyValue<List<PathConfig>> PATH_CONFIGS = LazyValue.create(SecurityFilterCommon::createPathConfigs);
    private final Security security;
    private final FeatureConfig featureConfig;

    SecurityFilterCommon(@Context Security security, @Context FeatureConfig featureConfig) {
        this.security = security;
        this.featureConfig = featureConfig;
    }

    private static List<PathConfig> createPathConfigs() {
        return ((List)MpConfig.toHelidonConfig((Config)ConfigProvider.getConfig()).get("server.features.security.endpoints").asNodeList().orElse(List.of())).stream().map(PathConfig::create).toList();
    }

    static Class<?> getRealClass(Class<?> object) {
        Class<?> result = object;
        while (result.isSynthetic()) {
            result = result.getSuperclass();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilter(ContainerRequestContext request, io.helidon.security.SecurityContext securityContext) {
        SecurityTracing tracing = SecurityTracing.get();
        tracing.securityContext(securityContext);
        SecurityFilterContext filterContext = this.initRequestFiltering(request);
        if (this.logger().isLoggable(System.Logger.Level.TRACE)) {
            this.logger().log(System.Logger.Level.TRACE, "Endpoint {0} security context: {1}", request.getUriInfo().getRequestUri(), filterContext);
        }
        if (filterContext.shouldFinish()) {
            if (this.logger().isLoggable(System.Logger.Level.TRACE)) {
                this.logger().log(System.Logger.Level.TRACE, "Endpoint %s not found, no security", request.getUriInfo().getRequestUri());
            }
            tracing.finish();
            return;
        }
        URI requestUri = request.getUriInfo().getRequestUri();
        String query = requestUri.getQuery();
        Object origRequest = null == query || query.isEmpty() ? requestUri.getPath() : requestUri.getPath() + "?" + query;
        HashMap<String, List<String>> allHeaders = new HashMap<String, List<String>>(filterContext.headers());
        allHeaders.put("X_ORIG_URI_HEADER", List.of(origRequest));
        SecurityEnvironment.Builder envBuilder = SecurityEnvironment.builder((SecurityTime)this.security.serverTime()).transport(requestUri.getScheme()).path(filterContext.resourcePath()).targetUri(filterContext.targetUri()).method(filterContext.method()).queryParams(filterContext.queryParams()).headers(allHeaders).addAttribute("resourceType", (Object)filterContext.resourceName());
        String remoteHost = (String)request.getProperty("io.helidon.jaxrs.remote-host");
        Integer remotePort = (Integer)request.getProperty("io.helidon.jaxrs.remote-port");
        if (remoteHost != null) {
            envBuilder.addAttribute("userIp", (Object)remoteHost);
        }
        if (remotePort != null) {
            envBuilder.addAttribute("userPort", (Object)remotePort);
        }
        SecurityEnvironment env = envBuilder.build();
        HashMap configMap = new HashMap();
        this.findMethodConfig(UriPath.create((String)requestUri.getPath())).asNode().ifPresent(conf -> ((List)conf.asNodeList().get()).forEach(node -> configMap.put(node.name(), node)));
        EndpointConfig ec = EndpointConfig.builder().securityLevels(filterContext.methodSecurity().securityLevels()).configMap(configMap).build();
        try {
            securityContext.env(env);
            securityContext.endpointConfig(ec);
            request.setProperty(PROP_FILTER_CONTEXT, (Object)filterContext);
            request.setSecurityContext((SecurityContext)new JerseySecurityContext(securityContext, filterContext.methodSecurity(), "https".equals(filterContext.targetUri().getScheme())));
            this.processSecurity(request, filterContext, tracing, securityContext);
        }
        finally {
            if (filterContext.traceSuccess()) {
                tracing.logProceed();
                tracing.finish();
            } else {
                tracing.logDeny();
                tracing.error("aborted");
            }
        }
    }

    io.helidon.common.config.Config findMethodConfig(UriPath path) {
        return ((List)PATH_CONFIGS.get()).stream().filter(pathConfig -> pathConfig.pathMatcher.prefixMatch(path).accepted()).findFirst().map(PathConfig::config).orElseGet(io.helidon.common.config.Config::empty);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void authenticate(SecurityFilterContext context, io.helidon.security.SecurityContext securityContext, AtnTracing atnTracing) {
        try {
            SecurityDefinition methodSecurity = context.methodSecurity();
            if (methodSecurity.requiresAuthentication()) {
                if (this.logger().isLoggable(System.Logger.Level.TRACE)) {
                    this.logger().log(System.Logger.Level.TRACE, "Endpoint {0} requires authentication", context.targetUri());
                }
                SecurityClientBuilder clientBuilder = (SecurityClientBuilder)((SecurityClientBuilder)securityContext.atnClientBuilder().optional(methodSecurity.authenticationOptional())).tracingSpan((SpanContext)atnTracing.findParent().orElse(null));
                clientBuilder.explicitProvider(methodSecurity.authenticator());
                this.processAuthentication(context, (SecurityClientBuilder<AuthenticationResponse>)clientBuilder, methodSecurity, atnTracing);
            } else if (this.logger().isLoggable(System.Logger.Level.TRACE)) {
                this.logger().log(System.Logger.Level.TRACE, "Endpoint {0} does not require authentication", context.targetUri());
            }
        }
        finally {
            if (context.traceSuccess()) {
                securityContext.user().ifPresent(arg_0 -> ((AtnTracing)atnTracing).logUser(arg_0));
                securityContext.service().ifPresent(arg_0 -> ((AtnTracing)atnTracing).logService(arg_0));
                atnTracing.finish();
            } else {
                Throwable ctxThrowable = context.traceThrowable();
                if (null == ctxThrowable) {
                    atnTracing.error(context.traceDescription());
                } else {
                    atnTracing.error(ctxThrowable);
                }
            }
        }
    }

    protected void processAuthentication(SecurityFilterContext context, SecurityClientBuilder<AuthenticationResponse> clientBuilder, SecurityDefinition methodSecurity, AtnTracing atnTracing) {
        AuthenticationResponse response = (AuthenticationResponse)clientBuilder.submit();
        SecurityResponse.SecurityStatus responseStatus = response.status();
        atnTracing.logStatus(responseStatus);
        switch (responseStatus) {
            case SUCCESS: {
                io.helidon.common.context.Context helidonContext = (io.helidon.common.context.Context)Contexts.context().orElseThrow(() -> new IllegalStateException("Context must be available in Jersey"));
                helidonContext.register((Object)"security.responseHeaders", (Object)response.responseHeaders());
                break;
            }
            case FAILURE_FINISH: {
                if (methodSecurity.authenticationOptional()) {
                    this.logger().log(System.Logger.Level.TRACE, "Authentication failed, but was optional, so assuming anonymous");
                    break;
                }
                context.traceSuccess(false);
                context.traceDescription(response.description().orElse(responseStatus.toString()));
                context.traceThrowable(response.throwable().orElse(null));
                context.shouldFinish(true);
                int status = response.statusCode().orElse(Response.Status.UNAUTHORIZED.getStatusCode());
                this.abortRequest(context, (SecurityResponse)response, status, Map.of());
                break;
            }
            case SUCCESS_FINISH: {
                context.shouldFinish(true);
                int status = response.statusCode().orElse(Response.Status.OK.getStatusCode());
                this.abortRequest(context, (SecurityResponse)response, status, Map.of());
                break;
            }
            case ABSTAIN: {
                if (methodSecurity.authenticationOptional()) {
                    this.logger().log(System.Logger.Level.TRACE, "Authentication failed, but was optional, so assuming anonymous");
                    break;
                }
                context.traceSuccess(false);
                context.traceDescription(response.description().orElse(responseStatus.toString()));
                context.shouldFinish(true);
                this.abortRequest(context, (SecurityResponse)response, Response.Status.UNAUTHORIZED.getStatusCode(), Map.of());
                break;
            }
            case FAILURE: {
                if (methodSecurity.authenticationOptional() && !methodSecurity.failOnFailureIfOptional()) {
                    this.logger().log(System.Logger.Level.TRACE, "Authentication failed, but was optional, so assuming anonymous");
                    break;
                }
                context.traceDescription(response.description().orElse(responseStatus.toString()));
                context.traceThrowable(response.throwable().orElse(null));
                context.traceSuccess(false);
                this.abortRequest(context, (SecurityResponse)response, Response.Status.UNAUTHORIZED.getStatusCode(), Map.of());
                context.shouldFinish(true);
                break;
            }
            default: {
                context.traceSuccess(false);
                context.traceDescription((String)((Object)response.description().orElse("UNKNOWN_RESPONSE: " + String.valueOf(responseStatus))));
                context.shouldFinish(true);
                SecurityException throwable = new SecurityException("Invalid SecurityStatus returned: " + String.valueOf(responseStatus));
                context.traceThrowable(throwable);
                throw throwable;
            }
        }
    }

    protected abstract System.Logger logger();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void authorize(SecurityFilterContext context, io.helidon.security.SecurityContext securityContext, AtzTracing atzTracing) {
        if (context.methodSecurity().atzExplicit()) {
            if (this.logger().isLoggable(System.Logger.Level.TRACE)) {
                this.logger().log(System.Logger.Level.TRACE, "Endpoint {0} uses explicit authorization, skipping", context.targetUri());
            }
            context.explicitAtz(true);
            return;
        }
        try {
            if (context.methodSecurity().requiresAuthorization()) {
                if (this.logger().isLoggable(System.Logger.Level.TRACE)) {
                    this.logger().log(System.Logger.Level.TRACE, "Endpoint {0} requires authorization", context.targetUri());
                }
                SecurityClientBuilder clientBuilder = (SecurityClientBuilder)((SecurityClientBuilder)securityContext.atzClientBuilder().tracingSpan((SpanContext)atzTracing.findParent().orElse(null))).explicitProvider(context.methodSecurity().authorizer());
                this.processAuthorization(context, (SecurityClientBuilder<AuthorizationResponse>)clientBuilder);
            } else if (this.logger().isLoggable(System.Logger.Level.TRACE)) {
                this.logger().log(System.Logger.Level.TRACE, "Endpoint {0} does not require authorization. Method security: {1}", context.targetUri(), context.methodSecurity());
            }
        }
        finally {
            if (context.traceSuccess()) {
                atzTracing.finish();
            } else {
                Throwable throwable = context.traceThrowable();
                if (null == throwable) {
                    atzTracing.error(context.traceDescription());
                } else {
                    atzTracing.error(throwable);
                }
            }
        }
    }

    protected void processAuthorization(SecurityFilterContext context, SecurityClientBuilder<AuthorizationResponse> clientBuilder) {
        AuthorizationResponse response = (AuthorizationResponse)clientBuilder.submit();
        SecurityResponse.SecurityStatus responseStatus = response.status();
        switch (responseStatus) {
            case SUCCESS: {
                break;
            }
            case FAILURE_FINISH: {
                context.traceSuccess(false);
                context.traceDescription(response.description().orElse(responseStatus.toString()));
                context.traceThrowable(response.throwable().orElse(null));
                context.shouldFinish(true);
                int status = response.statusCode().orElse(Response.Status.FORBIDDEN.getStatusCode());
                this.abortRequest(context, (SecurityResponse)response, status, Map.of());
                break;
            }
            case SUCCESS_FINISH: {
                context.shouldFinish(true);
                int status = response.statusCode().orElse(Response.Status.OK.getStatusCode());
                this.abortRequest(context, (SecurityResponse)response, status, Map.of());
                break;
            }
            case FAILURE: {
                context.traceSuccess(false);
                context.traceDescription(response.description().orElse(responseStatus.toString()));
                context.traceThrowable(response.throwable().orElse(null));
                context.shouldFinish(true);
                this.abortRequest(context, (SecurityResponse)response, response.statusCode().orElse(Response.Status.FORBIDDEN.getStatusCode()), Map.of());
                break;
            }
            case ABSTAIN: {
                context.traceSuccess(false);
                context.traceDescription(response.description().orElse(responseStatus.toString()));
                context.shouldFinish(true);
                this.abortRequest(context, (SecurityResponse)response, response.statusCode().orElse(Response.Status.FORBIDDEN.getStatusCode()), Map.of());
                break;
            }
            default: {
                context.traceSuccess(false);
                context.traceDescription((String)((Object)response.description().orElse("UNKNOWN_RESPONSE: " + String.valueOf(responseStatus))));
                context.shouldFinish(true);
                SecurityException throwable = new SecurityException("Invalid SecurityStatus returned: " + String.valueOf(responseStatus));
                context.traceThrowable(throwable);
                throw throwable;
            }
        }
    }

    protected void abortRequest(SecurityFilterContext context, SecurityResponse response, int defaultStatusCode, Map<String, List<String>> defaultHeaders) {
        int statusCode = response.statusCode().orElse(defaultStatusCode);
        Map responseHeaders = response.responseHeaders();
        Response.ResponseBuilder responseBuilder = Response.status((int)statusCode);
        if (responseHeaders.isEmpty()) {
            for (Map.Entry<String, List<String>> entry : defaultHeaders.entrySet()) {
                responseBuilder.header(entry.getKey(), entry.getValue());
            }
        } else {
            this.updateHeaders(responseHeaders, responseBuilder);
        }
        if (!RESPONSE_MAPPERS.isEmpty()) {
            RESPONSE_MAPPERS.forEach(m -> m.aborted(response, responseBuilder));
        } else if (this.featureConfig.isDebug()) {
            response.description().ifPresent(arg_0 -> ((Response.ResponseBuilder)responseBuilder).entity(arg_0));
        }
        if (!this.featureConfig.useAbortWith()) {
            String description = response.description().orElse("Security did not allow this request to proceed.");
            throw new WebApplicationException(description, responseBuilder.build());
        }
        context.jerseyRequest().abortWith(responseBuilder.build());
    }

    protected void updateHeaders(Map<String, List<String>> responseHeaders, Response.ResponseBuilder responseBuilder) {
        for (Map.Entry<String, List<String>> entry : responseHeaders.entrySet()) {
            for (String value : entry.getValue()) {
                responseBuilder.header(entry.getKey(), (Object)value);
            }
        }
    }

    protected SecurityFilterContext configureContext(SecurityFilterContext context, ContainerRequestContext requestContext, UriInfo uriInfo) {
        context.method(requestContext.getMethod());
        context.headers((Map<String, List<String>>)requestContext.getHeaders());
        context.targetUri(requestContext.getUriInfo().getRequestUri());
        context.resourcePath(context.targetUri().getPath());
        context.queryParams(UriQuery.create((URI)uriInfo.getRequestUri()));
        context.jerseyRequest((ContainerRequest)requestContext);
        this.featureConfig().getQueryParamHandlers().forEach(handler -> handler.extract(uriInfo, context.headers()));
        return context;
    }

    protected Security security() {
        return this.security;
    }

    protected FeatureConfig featureConfig() {
        return this.featureConfig;
    }

    protected abstract void processSecurity(ContainerRequestContext var1, SecurityFilterContext var2, SecurityTracing var3, io.helidon.security.SecurityContext var4);

    protected abstract SecurityFilterContext initRequestFiltering(ContainerRequestContext var1);

    io.helidon.common.config.Config config(String child) {
        return this.security.configFor(child);
    }

    private record PathConfig(PathMatcher pathMatcher, io.helidon.common.config.Config config) {
        static PathConfig create(io.helidon.common.config.Config config) {
            String path = (String)config.get("path").asString().orElseThrow();
            PathMatcher matcher = PathMatchers.create((String)path);
            return new PathConfig(matcher, config.get("config"));
        }
    }
}

