/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.security;

import io.helidon.common.HelidonServiceLoader;
import io.helidon.common.config.Config;
import io.helidon.common.context.Contexts;
import io.helidon.common.uri.UriQuery;
import io.helidon.microprofile.security.FeatureConfig;
import io.helidon.microprofile.security.JerseySecurityContext;
import io.helidon.microprofile.security.SecurityDefinition;
import io.helidon.microprofile.security.SecurityFilterContext;
import io.helidon.microprofile.security.spi.SecurityResponseMapper;
import io.helidon.security.AuthenticationResponse;
import io.helidon.security.AuthorizationResponse;
import io.helidon.security.EndpointConfig;
import io.helidon.security.Security;
import io.helidon.security.SecurityClientBuilder;
import io.helidon.security.SecurityEnvironment;
import io.helidon.security.SecurityResponse;
import io.helidon.security.SecurityTime;
import io.helidon.security.integration.common.AtnTracing;
import io.helidon.security.integration.common.AtzTracing;
import io.helidon.security.integration.common.SecurityTracing;
import io.helidon.tracing.SpanContext;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.SecurityContext;
import jakarta.ws.rs.core.UriInfo;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import org.glassfish.jersey.server.ContainerRequest;

abstract class SecurityFilterCommon {
    static final String PROP_FILTER_CONTEXT = "io.helidon.security.jersey.FilterContext";
    private static final List<SecurityResponseMapper> RESPONSE_MAPPERS = HelidonServiceLoader.builder(ServiceLoader.load(SecurityResponseMapper.class)).build().asList();
    private final Security security;
    private final FeatureConfig featureConfig;

    SecurityFilterCommon(@Context Security security, @Context FeatureConfig featureConfig) {
        this.security = security;
        this.featureConfig = featureConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilter(ContainerRequestContext request, io.helidon.security.SecurityContext securityContext) {
        SecurityTracing tracing = SecurityTracing.get();
        tracing.securityContext(securityContext);
        SecurityFilterContext filterContext = this.initRequestFiltering(request);
        if (this.logger().isLoggable(System.Logger.Level.TRACE)) {
            this.logger().log(System.Logger.Level.TRACE, "Endpoint {0} security context: {1}", request.getUriInfo().getRequestUri(), filterContext);
        }
        if (filterContext.isShouldFinish()) {
            if (this.logger().isLoggable(System.Logger.Level.TRACE)) {
                this.logger().log(System.Logger.Level.TRACE, "Endpoint %s not found, no security", request.getUriInfo().getRequestUri());
            }
            tracing.finish();
            return;
        }
        URI requestUri = request.getUriInfo().getRequestUri();
        String query = requestUri.getQuery();
        Object origRequest = null == query || query.isEmpty() ? requestUri.getPath() : requestUri.getPath() + "?" + query;
        HashMap<String, List<String>> allHeaders = new HashMap<String, List<String>>(filterContext.getHeaders());
        allHeaders.put("X_ORIG_URI_HEADER", List.of(origRequest));
        SecurityEnvironment.Builder envBuilder = SecurityEnvironment.builder((SecurityTime)this.security.serverTime()).transport(requestUri.getScheme()).path(filterContext.getResourcePath()).targetUri(filterContext.getTargetUri()).method(filterContext.getMethod()).queryParams(filterContext.getQueryParams()).headers(allHeaders).addAttribute("resourceType", (Object)filterContext.getResourceName());
        String remoteHost = (String)request.getProperty("io.helidon.jaxrs.remote-host");
        Integer remotePort = (Integer)request.getProperty("io.helidon.jaxrs.remote-port");
        if (remoteHost != null) {
            envBuilder.addAttribute("userIp", (Object)remoteHost);
        }
        if (remotePort != null) {
            envBuilder.addAttribute("userPort", (Object)remotePort);
        }
        SecurityEnvironment env = envBuilder.build();
        EndpointConfig ec = EndpointConfig.builder().securityLevels(filterContext.getMethodSecurity().getSecurityLevels()).build();
        try {
            securityContext.env(env);
            securityContext.endpointConfig(ec);
            request.setProperty(PROP_FILTER_CONTEXT, (Object)filterContext);
            request.setSecurityContext((SecurityContext)new JerseySecurityContext(securityContext, filterContext.getMethodSecurity(), "https".equals(filterContext.getTargetUri().getScheme())));
            this.processSecurity(request, filterContext, tracing, securityContext);
        }
        finally {
            if (filterContext.isTraceSuccess()) {
                tracing.logProceed();
                tracing.finish();
            } else {
                tracing.logDeny();
                tracing.error("aborted");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void authenticate(SecurityFilterContext context, io.helidon.security.SecurityContext securityContext, AtnTracing atnTracing) {
        try {
            SecurityDefinition methodSecurity = context.getMethodSecurity();
            if (methodSecurity.requiresAuthentication()) {
                if (this.logger().isLoggable(System.Logger.Level.TRACE)) {
                    this.logger().log(System.Logger.Level.TRACE, "Endpoint {0} requires authentication", context.getTargetUri());
                }
                SecurityClientBuilder clientBuilder = (SecurityClientBuilder)((SecurityClientBuilder)securityContext.atnClientBuilder().optional(methodSecurity.authenticationOptional())).tracingSpan((SpanContext)atnTracing.findParent().orElse(null));
                clientBuilder.explicitProvider(methodSecurity.getAuthenticator());
                this.processAuthentication(context, (SecurityClientBuilder<AuthenticationResponse>)clientBuilder, methodSecurity, atnTracing);
            } else if (this.logger().isLoggable(System.Logger.Level.TRACE)) {
                this.logger().log(System.Logger.Level.TRACE, "Endpoint {0} does not require authentication", context.getTargetUri());
            }
        }
        finally {
            if (context.isTraceSuccess()) {
                securityContext.user().ifPresent(arg_0 -> ((AtnTracing)atnTracing).logUser(arg_0));
                securityContext.service().ifPresent(arg_0 -> ((AtnTracing)atnTracing).logService(arg_0));
                atnTracing.finish();
            } else {
                Throwable ctxThrowable = context.getTraceThrowable();
                if (null == ctxThrowable) {
                    atnTracing.error(context.getTraceDescription());
                } else {
                    atnTracing.error(ctxThrowable);
                }
            }
        }
    }

    protected void processAuthentication(SecurityFilterContext context, SecurityClientBuilder<AuthenticationResponse> clientBuilder, SecurityDefinition methodSecurity, AtnTracing atnTracing) {
        AuthenticationResponse response = (AuthenticationResponse)clientBuilder.submit();
        SecurityResponse.SecurityStatus responseStatus = response.status();
        atnTracing.logStatus(responseStatus);
        switch (responseStatus) {
            case SUCCESS: {
                io.helidon.common.context.Context helidonContext = (io.helidon.common.context.Context)Contexts.context().orElseThrow(() -> new IllegalStateException("Context must be available in Jersey"));
                helidonContext.register((Object)"security.responseHeaders", (Object)response.responseHeaders());
                break;
            }
            case FAILURE_FINISH: {
                if (methodSecurity.authenticationOptional()) {
                    this.logger().log(System.Logger.Level.TRACE, "Authentication failed, but was optional, so assuming anonymous");
                    break;
                }
                context.setTraceSuccess(false);
                context.setTraceDescription(response.description().orElse(responseStatus.toString()));
                context.setTraceThrowable(response.throwable().orElse(null));
                context.setShouldFinish(true);
                int status = response.statusCode().orElse(Response.Status.UNAUTHORIZED.getStatusCode());
                this.abortRequest(context, (SecurityResponse)response, status, Map.of());
                break;
            }
            case SUCCESS_FINISH: {
                context.setShouldFinish(true);
                int status = response.statusCode().orElse(Response.Status.OK.getStatusCode());
                this.abortRequest(context, (SecurityResponse)response, status, Map.of());
                break;
            }
            case ABSTAIN: {
                if (methodSecurity.authenticationOptional()) {
                    this.logger().log(System.Logger.Level.TRACE, "Authentication failed, but was optional, so assuming anonymous");
                    break;
                }
                context.setTraceSuccess(false);
                context.setTraceDescription(response.description().orElse(responseStatus.toString()));
                context.setShouldFinish(true);
                this.abortRequest(context, (SecurityResponse)response, Response.Status.UNAUTHORIZED.getStatusCode(), Map.of());
                break;
            }
            case FAILURE: {
                if (methodSecurity.authenticationOptional() && !methodSecurity.failOnFailureIfOptional()) {
                    this.logger().log(System.Logger.Level.TRACE, "Authentication failed, but was optional, so assuming anonymous");
                    break;
                }
                context.setTraceDescription(response.description().orElse(responseStatus.toString()));
                context.setTraceThrowable(response.throwable().orElse(null));
                context.setTraceSuccess(false);
                this.abortRequest(context, (SecurityResponse)response, Response.Status.UNAUTHORIZED.getStatusCode(), Map.of());
                context.setShouldFinish(true);
                break;
            }
            default: {
                context.setTraceSuccess(false);
                context.setTraceDescription((String)((Object)response.description().orElse("UNKNOWN_RESPONSE: " + String.valueOf(responseStatus))));
                context.setShouldFinish(true);
                SecurityException throwable = new SecurityException("Invalid SecurityStatus returned: " + String.valueOf(responseStatus));
                context.setTraceThrowable(throwable);
                throw throwable;
            }
        }
    }

    protected abstract System.Logger logger();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void authorize(SecurityFilterContext context, io.helidon.security.SecurityContext securityContext, AtzTracing atzTracing) {
        if (context.getMethodSecurity().isAtzExplicit()) {
            if (this.logger().isLoggable(System.Logger.Level.TRACE)) {
                this.logger().log(System.Logger.Level.TRACE, "Endpoint {0} uses explicit authorization, skipping", context.getTargetUri());
            }
            context.setExplicitAtz(true);
            return;
        }
        try {
            if (context.getMethodSecurity().requiresAuthorization()) {
                if (this.logger().isLoggable(System.Logger.Level.TRACE)) {
                    this.logger().log(System.Logger.Level.TRACE, "Endpoint {0} requires authorization", context.getTargetUri());
                }
                SecurityClientBuilder clientBuilder = (SecurityClientBuilder)((SecurityClientBuilder)securityContext.atzClientBuilder().tracingSpan((SpanContext)atzTracing.findParent().orElse(null))).explicitProvider(context.getMethodSecurity().getAuthorizer());
                this.processAuthorization(context, (SecurityClientBuilder<AuthorizationResponse>)clientBuilder);
            } else if (this.logger().isLoggable(System.Logger.Level.TRACE)) {
                this.logger().log(System.Logger.Level.TRACE, "Endpoint {0} does not require authorization. Method security: {1}", context.getTargetUri(), context.getMethodSecurity());
            }
        }
        finally {
            if (context.isTraceSuccess()) {
                atzTracing.finish();
            } else {
                Throwable throwable = context.getTraceThrowable();
                if (null == throwable) {
                    atzTracing.error(context.getTraceDescription());
                } else {
                    atzTracing.error(throwable);
                }
            }
        }
    }

    protected void processAuthorization(SecurityFilterContext context, SecurityClientBuilder<AuthorizationResponse> clientBuilder) {
        AuthorizationResponse response = (AuthorizationResponse)clientBuilder.submit();
        SecurityResponse.SecurityStatus responseStatus = response.status();
        switch (responseStatus) {
            case SUCCESS: {
                break;
            }
            case FAILURE_FINISH: {
                context.setTraceSuccess(false);
                context.setTraceDescription(response.description().orElse(responseStatus.toString()));
                context.setTraceThrowable(response.throwable().orElse(null));
                context.setShouldFinish(true);
                int status = response.statusCode().orElse(Response.Status.FORBIDDEN.getStatusCode());
                this.abortRequest(context, (SecurityResponse)response, status, Map.of());
                break;
            }
            case SUCCESS_FINISH: {
                context.setShouldFinish(true);
                int status = response.statusCode().orElse(Response.Status.OK.getStatusCode());
                this.abortRequest(context, (SecurityResponse)response, status, Map.of());
                break;
            }
            case FAILURE: {
                context.setTraceSuccess(false);
                context.setTraceDescription(response.description().orElse(responseStatus.toString()));
                context.setTraceThrowable(response.throwable().orElse(null));
                context.setShouldFinish(true);
                this.abortRequest(context, (SecurityResponse)response, response.statusCode().orElse(Response.Status.FORBIDDEN.getStatusCode()), Map.of());
                break;
            }
            case ABSTAIN: {
                context.setTraceSuccess(false);
                context.setTraceDescription(response.description().orElse(responseStatus.toString()));
                context.setShouldFinish(true);
                this.abortRequest(context, (SecurityResponse)response, response.statusCode().orElse(Response.Status.FORBIDDEN.getStatusCode()), Map.of());
                break;
            }
            default: {
                context.setTraceSuccess(false);
                context.setTraceDescription((String)((Object)response.description().orElse("UNKNOWN_RESPONSE: " + String.valueOf(responseStatus))));
                context.setShouldFinish(true);
                SecurityException throwable = new SecurityException("Invalid SecurityStatus returned: " + String.valueOf(responseStatus));
                context.setTraceThrowable(throwable);
                throw throwable;
            }
        }
    }

    protected void abortRequest(SecurityFilterContext context, SecurityResponse response, int defaultStatusCode, Map<String, List<String>> defaultHeaders) {
        int statusCode = response.statusCode().orElse(defaultStatusCode);
        Map responseHeaders = response.responseHeaders();
        Response.ResponseBuilder responseBuilder = Response.status((int)statusCode);
        if (responseHeaders.isEmpty()) {
            for (Map.Entry<String, List<String>> entry : defaultHeaders.entrySet()) {
                responseBuilder.header(entry.getKey(), entry.getValue());
            }
        } else {
            this.updateHeaders(responseHeaders, responseBuilder);
        }
        if (!RESPONSE_MAPPERS.isEmpty()) {
            RESPONSE_MAPPERS.forEach(m -> m.aborted(response, responseBuilder));
        } else if (this.featureConfig.isDebug()) {
            response.description().ifPresent(arg_0 -> ((Response.ResponseBuilder)responseBuilder).entity(arg_0));
        }
        if (!this.featureConfig.useAbortWith()) {
            String description = response.description().orElse("Security did not allow this request to proceed.");
            throw new WebApplicationException(description, responseBuilder.build());
        }
        context.getJerseyRequest().abortWith(responseBuilder.build());
    }

    protected void updateHeaders(Map<String, List<String>> responseHeaders, Response.ResponseBuilder responseBuilder) {
        for (Map.Entry<String, List<String>> entry : responseHeaders.entrySet()) {
            for (String value : entry.getValue()) {
                responseBuilder.header(entry.getKey(), (Object)value);
            }
        }
    }

    protected SecurityFilterContext configureContext(SecurityFilterContext context, ContainerRequestContext requestContext, UriInfo uriInfo) {
        context.setMethod(requestContext.getMethod());
        context.setHeaders((Map<String, List<String>>)requestContext.getHeaders());
        context.setTargetUri(requestContext.getUriInfo().getRequestUri());
        context.setResourcePath(context.getTargetUri().getPath());
        context.setQueryParams(UriQuery.create((URI)uriInfo.getRequestUri()));
        context.setJerseyRequest((ContainerRequest)requestContext);
        this.featureConfig().getQueryParamHandlers().forEach(handler -> handler.extract(uriInfo, context.getHeaders()));
        return context;
    }

    protected Security security() {
        return this.security;
    }

    protected FeatureConfig featureConfig() {
        return this.featureConfig;
    }

    protected abstract void processSecurity(ContainerRequestContext var1, SecurityFilterContext var2, SecurityTracing var3, io.helidon.security.SecurityContext var4);

    protected abstract SecurityFilterContext initRequestFiltering(ContainerRequestContext var1);

    Config config(String child) {
        return this.security.configFor(child);
    }
}

