/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.security;

import io.helidon.common.context.Contexts;
import io.helidon.microprofile.security.FeatureConfig;
import io.helidon.microprofile.security.SecurityDefinition;
import io.helidon.microprofile.security.SecurityFilterCommon;
import io.helidon.microprofile.security.SecurityFilterContext;
import io.helidon.security.Security;
import io.helidon.security.SecurityContext;
import io.helidon.security.integration.common.SecurityTracing;
import io.helidon.tracing.SpanContext;
import jakarta.annotation.Priority;
import jakarta.ws.rs.ConstrainedTo;
import jakarta.ws.rs.RuntimeType;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.container.PreMatching;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.GenericType;
import jakarta.ws.rs.core.UriInfo;
import java.util.concurrent.atomic.AtomicInteger;
import org.glassfish.jersey.internal.inject.InjectionManager;
import org.glassfish.jersey.internal.util.collection.Ref;

@PreMatching
@Priority(value=1000)
@ConstrainedTo(value=RuntimeType.SERVER)
class SecurityPreMatchingFilter
extends SecurityFilterCommon
implements ContainerRequestFilter {
    private static final System.Logger LOGGER = System.getLogger(SecurityPreMatchingFilter.class.getName());
    private static final AtomicInteger CONTEXT_COUNTER = new AtomicInteger();
    private final InjectionManager injectionManager;
    private final UriInfo uriInfo;

    SecurityPreMatchingFilter(@Context Security security, @Context FeatureConfig featureConfig, @Context InjectionManager injectionManager, @Context UriInfo uriInfo) {
        super(security, featureConfig);
        this.injectionManager = injectionManager;
        this.uriInfo = uriInfo;
    }

    public void filter(ContainerRequestContext request) {
        SecurityTracing tracing = SecurityTracing.get();
        SecurityContext securityContext = Contexts.context().flatMap(context -> context.get(SecurityContext.class)).orElse(null);
        if (securityContext == null) {
            SecurityContext finalSecurityContext = securityContext = this.security().contextBuilder(Integer.toString(CONTEXT_COUNTER.incrementAndGet(), 36)).tracingSpan((SpanContext)tracing.findParent().orElse(null)).build();
            Contexts.context().ifPresent(ctx -> ctx.register((Object)finalSecurityContext));
        }
        ((Ref)this.injectionManager.getInstance(new GenericType<Ref<SecurityContext>>(this){}.getType())).set((Object)securityContext);
        if (this.featureConfig().shouldUsePrematchingAuthentication()) {
            this.doFilter(request, securityContext);
        }
    }

    @Override
    protected void processSecurity(ContainerRequestContext request, SecurityFilterContext filterContext, SecurityTracing tracing, SecurityContext securityContext) {
        this.authenticate(filterContext, securityContext, tracing.atnTracing());
        LOGGER.log(System.Logger.Level.TRACE, () -> "Filter after authentication. Should finish: " + filterContext.isShouldFinish());
        if (filterContext.isShouldFinish()) {
            return;
        }
        filterContext.clearTrace();
        if (this.featureConfig().shouldUsePrematchingAuthorization()) {
            LOGGER.log(System.Logger.Level.TRACE, () -> "Using pre-matching authorization");
            this.authorize(filterContext, securityContext, tracing.atzTracing());
        }
        LOGGER.log(System.Logger.Level.TRACE, () -> "Filter completed (after authorization)");
    }

    @Override
    protected SecurityFilterContext initRequestFiltering(ContainerRequestContext requestContext) {
        SecurityFilterContext context = new SecurityFilterContext();
        SecurityDefinition methodDef = new SecurityDefinition(false, false);
        methodDef.requiresAuthentication(true);
        methodDef.setRequiresAuthorization(this.featureConfig().shouldUsePrematchingAuthorization());
        context.setMethodSecurity(methodDef);
        context.setResourceName("jax-rs");
        return this.configureContext(context, requestContext, this.uriInfo);
    }

    @Override
    protected System.Logger logger() {
        return LOGGER;
    }
}

