/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.security;

import io.helidon.common.context.Context;
import io.helidon.common.context.Contexts;
import io.helidon.common.uri.UriQuery;
import io.helidon.security.EndpointConfig;
import io.helidon.security.OutboundSecurityClientBuilder;
import io.helidon.security.OutboundSecurityResponse;
import io.helidon.security.Security;
import io.helidon.security.SecurityContext;
import io.helidon.security.SecurityEnvironment;
import io.helidon.security.SecurityResponse;
import io.helidon.security.integration.common.OutboundTracing;
import io.helidon.security.integration.common.SecurityTracing;
import jakarta.annotation.Priority;
import jakarta.ws.rs.ConstrainedTo;
import jakarta.ws.rs.RuntimeType;
import jakarta.ws.rs.client.ClientRequestContext;
import jakarta.ws.rs.client.ClientRequestFilter;
import jakarta.ws.rs.core.MultivaluedMap;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;

@ConstrainedTo(value=RuntimeType.CLIENT)
@Priority(value=1000)
public class ClientSecurityFilter
implements ClientRequestFilter {
    private static final System.Logger LOGGER = System.getLogger(ClientSecurityFilter.class.getName());
    private static final AtomicLong CONTEXT_COUNTER = new AtomicLong();

    public void filter(ClientRequestContext requestContext) {
        try {
            this.doFilter(requestContext);
        }
        catch (Throwable e) {
            LOGGER.log(System.Logger.Level.WARNING, "Failed to process client filter.", e);
            throw e;
        }
    }

    private void doFilter(ClientRequestContext requestContext) {
        Optional<SecurityContext> securityContext = this.findContext(requestContext);
        if (securityContext.isPresent()) {
            this.outboundSecurity(requestContext, securityContext.get());
        } else {
            LOGGER.log(System.Logger.Level.TRACE, "Security context not available, using empty one. You can define it using property \"{0} on request", "io.helidon.security.jersey.SecureClient.context");
            Context context = Contexts.context().orElseGet(() -> Context.builder().id("security-" + CONTEXT_COUNTER.incrementAndGet()).build());
            Optional<SecurityContext> newSecurityContext = context.get(Security.class).map(it -> it.createContext(context.id()));
            if (newSecurityContext.isPresent()) {
                Contexts.runInContext((Context)context, () -> this.outboundSecurity(requestContext, (SecurityContext)newSecurityContext.get()));
            } else {
                LOGGER.log(System.Logger.Level.TRACE, "Security is not available in global or current context, cannot propagate identity.");
            }
        }
    }

    private void outboundSecurity(ClientRequestContext requestContext, SecurityContext securityContext) {
        OutboundTracing tracing = SecurityTracing.get().outboundTracing();
        Optional<String> explicitProvider = ClientSecurityFilter.property(requestContext, String.class, "io.helidon.security.jersey.SecureClient.explicitProvider");
        try {
            SecurityEnvironment.Builder outboundEnv = securityContext.env().derive().clearHeaders().clearQueryParams();
            outboundEnv.method(requestContext.getMethod()).path(requestContext.getUri().getPath()).targetUri(requestContext.getUri()).headers((Map)requestContext.getStringHeaders()).queryParams(UriQuery.create((URI)requestContext.getUri()));
            EndpointConfig.Builder outboundEp = securityContext.endpointConfig().derive();
            for (String name : requestContext.getConfiguration().getPropertyNames()) {
                outboundEp.addAtribute(name, requestContext.getConfiguration().getProperty(name));
            }
            for (String name : requestContext.getPropertyNames()) {
                outboundEp.addAtribute(name, requestContext.getProperty(name));
            }
            OutboundSecurityClientBuilder clientBuilder = ((OutboundSecurityClientBuilder)securityContext.outboundClientBuilder().outboundEnvironment((Supplier)outboundEnv).update(it -> tracing.findParent().ifPresent(arg_0 -> ((OutboundSecurityClientBuilder)it).tracingSpan(arg_0)))).outboundEndpointConfig((Supplier)outboundEp);
            explicitProvider.ifPresent(arg_0 -> ((OutboundSecurityClientBuilder)clientBuilder).explicitProvider(arg_0));
            OutboundSecurityResponse providerResponse = clientBuilder.submit();
            SecurityResponse.SecurityStatus status = providerResponse.status();
            tracing.logStatus(status);
            switch (status) {
                case FAILURE: 
                case FAILURE_FINISH: {
                    providerResponse.throwable().ifPresentOrElse(x$0 -> tracing.error(x$0), () -> tracing.error(providerResponse.description().orElse("Failed")));
                    break;
                }
            }
            Map newHeaders = providerResponse.requestHeaders();
            LOGGER.log(System.Logger.Level.TRACE, () -> "Client filter header(s). SIZE: " + newHeaders.size());
            MultivaluedMap headers = requestContext.getHeaders();
            for (Map.Entry entry : newHeaders.entrySet()) {
                LOGGER.log(System.Logger.Level.TRACE, () -> "    + Header: " + (String)entry.getKey() + ": " + String.valueOf(entry.getValue()));
                headers.remove(entry.getKey());
                for (String value : (List)entry.getValue()) {
                    headers.add((Object)((String)entry.getKey()), (Object)value);
                }
            }
            tracing.finish();
        }
        catch (Exception e) {
            tracing.error((Throwable)e);
            throw e;
        }
    }

    private Optional<SecurityContext> findContext(ClientRequestContext requestContext) {
        return ClientSecurityFilter.property(requestContext, SecurityContext.class, "io.helidon.security.jersey.SecureClient.context").or(() -> Contexts.context().flatMap(ctx -> ctx.get(SecurityContext.class)));
    }

    private static <T> Optional<T> property(ClientRequestContext requestContext, Class<T> clazz, String propertyName) {
        return Optional.ofNullable(requestContext.getProperty(propertyName)).filter(clazz::isInstance).or(() -> Optional.ofNullable(requestContext.getConfiguration().getProperty(propertyName)).filter(clazz::isInstance)).map(clazz::cast);
    }
}

