/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.security;

import io.helidon.common.HelidonFeatures;
import io.helidon.common.HelidonFlavor;
import io.helidon.common.context.Contexts;
import io.helidon.config.Config;
import io.helidon.microprofile.cdi.RuntimeStart;
import io.helidon.microprofile.security.SecurityProducer;
import io.helidon.microprofile.server.JaxRsCdiExtension;
import io.helidon.microprofile.server.ServerCdiExtension;
import io.helidon.security.AuthenticationResponse;
import io.helidon.security.ProviderRequest;
import io.helidon.security.Security;
import io.helidon.security.integration.jersey.SecurityFeature;
import io.helidon.security.integration.webserver.WebSecurity;
import io.helidon.security.providers.abac.AbacProvider;
import io.helidon.security.spi.AuthenticationProvider;
import io.helidon.security.spi.AuthorizationProvider;
import io.helidon.webserver.Service;
import java.lang.annotation.Annotation;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.logging.Logger;
import javax.annotation.Priority;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.Initialized;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.inject.spi.Extension;

public class SecurityCdiExtension
implements Extension {
    private static final Logger LOGGER = Logger.getLogger(SecurityCdiExtension.class.getName());
    private Security.Builder securityBuilder = Security.builder();
    private Config config;

    private void registerBean(@Observes BeforeBeanDiscovery abd) {
        abd.addAnnotatedType(SecurityProducer.class, "helidon-security-producer").add((Annotation)ApplicationScoped.Literal.INSTANCE);
    }

    private void configure(@Observes @RuntimeStart @Priority(value=0) Config config) {
        this.config = config;
        this.securityBuilder.config(config.get("security"));
    }

    private void registerSecurity(@Observes @Initialized(value=ApplicationScoped.class) @Priority(value=4000) Object adv, BeanManager bm) {
        Config webServerConfig;
        if (this.securityBuilder.noProvider(AuthenticationProvider.class)) {
            LOGGER.info("Security extension for microprofile is enabled, yet security configuration for authentication provider is missing from config (requires providers configuration at key security.providers). Security will not have any valid authentication provider");
            this.securityBuilder.addAuthenticationProvider(this::failingAtnProvider);
        }
        if (this.securityBuilder.noProvider(AuthorizationProvider.class)) {
            LOGGER.info("Security extension for microprofile is enabled, yet security configuration for authorization provider is missing from config (requires providers configuration at key security.providers). ABAC provider is configured for authorization.");
            this.securityBuilder.addAuthorizationProvider((AuthorizationProvider)AbacProvider.create());
        }
        Security security = this.securityBuilder.build();
        this.securityBuilder = null;
        JaxRsCdiExtension jaxrs = (JaxRsCdiExtension)bm.getExtension(JaxRsCdiExtension.class);
        ServerCdiExtension server = (ServerCdiExtension)bm.getExtension(ServerCdiExtension.class);
        Contexts.context().ifPresent(ctx -> ctx.register((Object)security));
        Config jerseyConfig = this.config.get("security.jersey");
        if (((Boolean)jerseyConfig.get("enabled").asBoolean().orElse((Object)true)).booleanValue()) {
            SecurityFeature feature = SecurityFeature.builder((Security)security).config(jerseyConfig).build();
            jaxrs.applicationsToRun().forEach(app -> app.resourceConfig().register((Object)feature));
        }
        if ((webServerConfig = this.config.get("security.web-server")).exists() && ((Boolean)webServerConfig.get("enabled").asBoolean().orElse((Object)true)).booleanValue()) {
            server.serverRoutingBuilder().register(new Service[]{WebSecurity.create((Security)security, (Config)this.config.get("security"))});
        }
    }

    private CompletionStage<AuthenticationResponse> failingAtnProvider(ProviderRequest request) {
        return CompletableFuture.completedFuture(AuthenticationResponse.failed((String)"No provider configured"));
    }

    public Security.Builder securityBuilder() {
        if (null == this.securityBuilder) {
            throw new IllegalStateException("Security is already built, you cannot update the builder");
        }
        return this.securityBuilder;
    }

    static {
        HelidonFeatures.register((HelidonFlavor)HelidonFlavor.MP, (String[])new String[]{"Security"});
    }
}

