/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.security;

import io.helidon.common.context.Contexts;
import io.helidon.security.Security;
import io.helidon.security.SecurityContext;
import java.util.concurrent.atomic.AtomicLong;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.inject.Produces;

class SecurityProducer {
    private final AtomicLong contextCounter = new AtomicLong();

    SecurityProducer() {
    }

    @ApplicationScoped
    @Produces
    Security security() {
        return (Security)Contexts.context().flatMap(context -> context.get(Security.class)).orElseThrow(() -> new IllegalStateException("Security cannot be injected when not configured"));
    }

    @RequestScoped
    @Produces
    SecurityContext securityContext(Security security) {
        return Contexts.context().flatMap(context -> context.get(SecurityContext.class)).orElseGet(() -> this.emptyContext(security));
    }

    private SecurityContext emptyContext(Security security) {
        return security.createContext("security-producer-context-" + this.contextCounter.incrementAndGet());
    }
}

