/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.security;

import io.helidon.config.Config;
import io.helidon.microprofile.server.spi.MpService;
import io.helidon.microprofile.server.spi.MpServiceContext;
import io.helidon.security.Security;
import io.helidon.security.jersey.SecurityFeature;
import io.helidon.security.webserver.WebSecurity;
import io.helidon.webserver.Service;

public class SecurityMpService
implements MpService {
    public void configure(MpServiceContext context) {
        Config webServerConfig;
        Config config = context.getHelidonConfig();
        Security security = Security.fromConfig((Config)config);
        Config jerseyConfig = config.get("security.jersey");
        if (jerseyConfig.get("enabled").asBoolean(true)) {
            SecurityFeature feature = SecurityFeature.builder((Security)security).fromConfig(config).build();
            context.getApplications().forEach(app -> app.register((Object)feature));
        }
        if ((webServerConfig = config.get("security.web-server")).exists() && webServerConfig.get("enabled").asBoolean(true)) {
            context.getServerRoutingBuilder().register(new Service[]{WebSecurity.from((Security)security, (Config)config)});
        }
        context.register(Security.class, (Object)security);
    }
}

