/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.grpc.server;

import com.google.protobuf.Descriptors;
import io.grpc.ServerInterceptor;
import io.grpc.stub.ServerCalls;
import io.helidon.common.Builder;
import io.helidon.common.HelidonServiceLoader;
import io.helidon.grpc.api.Grpc;
import io.helidon.grpc.core.ContextKeys;
import io.helidon.grpc.core.MethodHandler;
import io.helidon.microprofile.grpc.core.AbstractServiceBuilder;
import io.helidon.microprofile.grpc.core.AnnotatedMethod;
import io.helidon.microprofile.grpc.core.AnnotatedMethodList;
import io.helidon.microprofile.grpc.core.InstanceSupplier;
import io.helidon.microprofile.grpc.core.MethodHandlerSupplier;
import io.helidon.microprofile.grpc.core.ModelHelper;
import io.helidon.microprofile.grpc.server.AnnotatedServiceConfigurer;
import io.helidon.webserver.grpc.GrpcMethodDescriptor;
import io.helidon.webserver.grpc.GrpcServiceDescriptor;
import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.spi.BeanManager;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.function.Supplier;

public class GrpcServiceBuilder
extends AbstractServiceBuilder
implements Builder<GrpcServiceBuilder, GrpcServiceDescriptor> {
    private static final System.Logger LOGGER = System.getLogger(GrpcServiceBuilder.class.getName());
    private final BeanManager beanManager;

    private GrpcServiceBuilder(Class<?> serviceClass, Supplier<?> instanceSupplier, BeanManager beanManager) {
        super(serviceClass, instanceSupplier);
        this.beanManager = beanManager;
    }

    public static GrpcServiceBuilder create(Object service, BeanManager beanManager) {
        return new GrpcServiceBuilder(service.getClass(), InstanceSupplier.singleton((Object)service), beanManager);
    }

    public static GrpcServiceBuilder create(Class<?> serviceClass, BeanManager beanManager) {
        return new GrpcServiceBuilder(Objects.requireNonNull(serviceClass), GrpcServiceBuilder.createInstanceSupplier(serviceClass), beanManager);
    }

    public static GrpcServiceBuilder create(Class<?> serviceClass, Supplier<?> instanceSupplier, BeanManager beanManager) {
        return new GrpcServiceBuilder(serviceClass, instanceSupplier, beanManager);
    }

    public GrpcServiceDescriptor build() {
        this.checkForNonPublicMethodIssues();
        Class annotatedServiceClass = this.annotatedServiceClass();
        AnnotatedMethodList methodList = AnnotatedMethodList.create((Class)annotatedServiceClass);
        String name = this.determineServiceName(annotatedServiceClass);
        GrpcServiceDescriptor.Builder builder = GrpcServiceDescriptor.builder((Class)this.serviceClass(), (String)name).marshallerSupplier(this.getMarshallerSupplier());
        Optional<AnnotatedMethod> protoMethod = methodList.filter(am -> am.isAnnotationPresent(Grpc.Proto.class)).stream().findFirst();
        protoMethod.ifPresent(am -> {
            Method method = am.method();
            int mods = method.getModifiers();
            if (Modifier.isStatic(mods) || !Modifier.isPublic(mods) || am.returnType() != Descriptors.FileDescriptor.class || method.getParameterCount() > 0) {
                throw new IllegalArgumentException("Method annotated with @Grpc.Proto must be public, non-static, return MethodDescriptor and have no args");
            }
            try {
                Descriptors.FileDescriptor proto = (Descriptors.FileDescriptor)method.invoke(this.instanceSupplier().get(), new Object[0]);
                builder.proto(proto);
            }
            catch (Exception e) {
                throw new IllegalStateException("Unable to access protobuf file descriptor", e);
            }
        });
        this.addServiceMethods(builder, methodList, this.beanManager);
        this.configureServiceInterceptors(builder, this.beanManager);
        Class serviceClass = this.serviceClass();
        Class annotatedClass = this.annotatedServiceClass();
        HelidonServiceLoader.create(ServiceLoader.load(AnnotatedServiceConfigurer.class)).forEach(configurer -> configurer.accept(serviceClass, annotatedClass, builder));
        return builder.build();
    }

    private void addServiceMethods(GrpcServiceDescriptor.Builder builder, AnnotatedMethodList methodList, BeanManager beanManager) {
        for (AnnotatedMethod am : methodList.withAnnotation(Grpc.GrpcMethod.class)) {
            this.addServiceMethod(builder, am, beanManager);
        }
        for (AnnotatedMethod am : methodList.withMetaAnnotation(Grpc.GrpcMethod.class)) {
            this.addServiceMethod(builder, am, beanManager);
        }
    }

    private void addServiceMethod(GrpcServiceDescriptor.Builder builder, AnnotatedMethod method, BeanManager beanManager) {
        Grpc.GrpcMethod annotation = (Grpc.GrpcMethod)method.firstAnnotationOrMetaAnnotation(Grpc.GrpcMethod.class);
        String name = GrpcServiceBuilder.determineMethodName((AnnotatedMethod)method, (Grpc.GrpcMethod)annotation);
        Supplier instanceSupplier = this.instanceSupplier();
        MethodHandler handler = this.handlerSuppliers().stream().filter(supplier -> supplier.supplies(method)).findFirst().map(arg_0 -> GrpcServiceBuilder.lambda$addServiceMethod$4(name, method, (Supplier)instanceSupplier, arg_0)).orElseThrow(() -> new IllegalArgumentException("Cannot locate a method handler supplier for method " + String.valueOf(method)));
        Class requestType = handler.getRequestType();
        Class responseType = handler.getResponseType();
        List<ServerInterceptor> interceptors = this.lookupMethodInterceptors(beanManager, method);
        Grpc.GrpcInterceptors grpcInterceptors = (Grpc.GrpcInterceptors)method.getAnnotation(Grpc.GrpcInterceptors.class);
        if (grpcInterceptors != null) {
            for (Class interceptorClass : grpcInterceptors.value()) {
                ServerInterceptor interceptor = this.resolveInterceptor(beanManager, interceptorClass);
                if (interceptor == null) continue;
                interceptors.add(interceptor);
            }
        }
        AnnotatedMethodConfigurer configurer = new AnnotatedMethodConfigurer(method, requestType, responseType, interceptors);
        switch (annotation.value()) {
            case UNARY: {
                builder.unary(name, (ServerCalls.UnaryMethod)handler, (GrpcMethodDescriptor.Configurer)configurer);
                break;
            }
            case CLIENT_STREAMING: {
                builder.clientStreaming(name, (ServerCalls.ClientStreamingMethod)handler, (GrpcMethodDescriptor.Configurer)configurer);
                break;
            }
            case SERVER_STREAMING: {
                builder.serverStreaming(name, (ServerCalls.ServerStreamingMethod)handler, (GrpcMethodDescriptor.Configurer)configurer);
                break;
            }
            case BIDI_STREAMING: {
                builder.bidirectional(name, (ServerCalls.BidiStreamingMethod)handler, (GrpcMethodDescriptor.Configurer)configurer);
                break;
            }
            default: {
                LOGGER.log(System.Logger.Level.ERROR, () -> "Unrecognized method type " + String.valueOf(annotation.value()));
            }
        }
    }

    private void configureServiceInterceptors(GrpcServiceDescriptor.Builder builder, BeanManager beanManager) {
        if (beanManager != null) {
            Class serviceClass = this.serviceClass();
            Class annotatedClass = this.annotatedServiceClass();
            this.configureServiceInterceptors(builder, beanManager, this.serviceClass());
            if (!serviceClass.equals(annotatedClass)) {
                this.configureServiceInterceptors(builder, beanManager, this.annotatedServiceClass());
            }
        }
    }

    private void configureServiceInterceptors(GrpcServiceDescriptor.Builder builder, BeanManager beanManager, Class<?> cls) {
        if (beanManager != null) {
            for (Annotation annotation : cls.getAnnotations()) {
                if (!annotation.annotationType().isAnnotationPresent(Grpc.GrpcInterceptorBinding.class)) continue;
                builder.intercept(new ServerInterceptor[]{this.lookupInterceptor(annotation, beanManager)});
            }
            Grpc.GrpcInterceptors grpcInterceptors = cls.getAnnotation(Grpc.GrpcInterceptors.class);
            if (grpcInterceptors != null) {
                for (Class interceptorClass : grpcInterceptors.value()) {
                    ServerInterceptor interceptor;
                    if (!ServerInterceptor.class.isAssignableFrom(interceptorClass) || (interceptor = this.resolveInterceptor(beanManager, interceptorClass)) == null) continue;
                    builder.intercept(new ServerInterceptor[]{interceptor});
                }
            }
        }
    }

    private List<ServerInterceptor> lookupMethodInterceptors(BeanManager beanManager, AnnotatedMethod method) {
        if (beanManager == null) {
            return Collections.emptyList();
        }
        ArrayList<ServerInterceptor> interceptors = new ArrayList<ServerInterceptor>();
        for (Annotation annotation : method.getAnnotations()) {
            if (!annotation.annotationType().isAnnotationPresent(Grpc.GrpcInterceptorBinding.class)) continue;
            interceptors.add(this.lookupInterceptor(annotation, beanManager));
        }
        return interceptors;
    }

    private ServerInterceptor lookupInterceptor(Annotation annotation, BeanManager beanManager) {
        Instance instance = beanManager.createInstance().select(ServerInterceptor.class, new Annotation[0]);
        List<ServerInterceptor> interceptors = instance.stream().filter(interceptor -> this.hasAnnotation((ServerInterceptor)interceptor, annotation)).toList();
        if (interceptors.size() == 1) {
            return interceptors.get(0);
        }
        if (interceptors.size() > 1) {
            throw new IllegalStateException("gRPC interceptor annotationresolves to ambiguous interceptor implementations " + String.valueOf(annotation));
        }
        throw new IllegalStateException("Cannot resolve a gRPC interceptor bean for annotation" + String.valueOf(annotation));
    }

    private ServerInterceptor resolveInterceptor(BeanManager beanManager, Class<?> cls) {
        if (beanManager == null) {
            return null;
        }
        if (ServerInterceptor.class.isAssignableFrom(cls)) {
            Instance instance = beanManager.createInstance().select(cls, new Annotation[]{Any.Literal.INSTANCE});
            if (instance.isResolvable()) {
                return (ServerInterceptor)instance.get();
            }
            try {
                return (ServerInterceptor)cls.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new IllegalArgumentException("Cannot create gRPC interceptor", e);
            }
        }
        throw new IllegalArgumentException("Specified interceptor class " + String.valueOf(cls) + " is not a " + String.valueOf(ServerInterceptor.class));
    }

    private boolean hasAnnotation(ServerInterceptor interceptor, Annotation annotation) {
        Annotation[] annotations = this.getClass(interceptor).getAnnotations();
        return Arrays.asList(annotations).contains(annotation);
    }

    private Class<?> getClass(Object o) {
        Class<?> cls = o.getClass();
        while (cls.isSynthetic()) {
            cls = cls.getSuperclass();
        }
        return cls;
    }

    private static /* synthetic */ MethodHandler lambda$addServiceMethod$4(String name, AnnotatedMethod method, Supplier instanceSupplier, MethodHandlerSupplier supplier) {
        return supplier.get(name, method, instanceSupplier);
    }

    private static class AnnotatedMethodConfigurer
    implements GrpcMethodDescriptor.Configurer {
        private final AnnotatedMethod method;
        private final Class<?> requestType;
        private final Class<?> responseType;
        private final List<ServerInterceptor> interceptors;

        private AnnotatedMethodConfigurer(AnnotatedMethod method, Class<?> requestType, Class<?> responseType, List<ServerInterceptor> interceptors) {
            this.method = method;
            this.requestType = requestType;
            this.responseType = responseType;
            this.interceptors = interceptors;
        }

        public void configure(GrpcMethodDescriptor.Rules rules) {
            rules.addContextValue(ContextKeys.SERVICE_METHOD, (Object)this.method.declaredMethod()).requestType(this.requestType).responseType(this.responseType);
            if (this.method.isAnnotationPresent(Grpc.GrpcMarshaller.class)) {
                rules.marshallerSupplier(ModelHelper.getMarshallerSupplier((Grpc.GrpcMarshaller)((Grpc.GrpcMarshaller)this.method.getAnnotation(Grpc.GrpcMarshaller.class))));
            }
            this.interceptors.forEach(xva$0 -> rules.intercept(new ServerInterceptor[]{xva$0}));
        }
    }
}

