/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.grpc.server;

import io.grpc.BindableService;
import io.helidon.common.Builder;
import io.helidon.common.HelidonServiceLoader;
import io.helidon.config.Config;
import io.helidon.config.mp.MpConfig;
import io.helidon.grpc.api.Grpc;
import io.helidon.microprofile.grpc.server.GrpcServiceBuilder;
import io.helidon.microprofile.grpc.server.spi.GrpcMpContext;
import io.helidon.microprofile.grpc.server.spi.GrpcMpExtension;
import io.helidon.microprofile.server.ServerCdiExtension;
import io.helidon.webserver.grpc.GrpcRouting;
import io.helidon.webserver.grpc.GrpcService;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.Initialized;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.Extension;
import java.lang.annotation.Annotation;
import java.util.ServiceLoader;
import org.eclipse.microprofile.config.ConfigProvider;

public class GrpcMpCdiExtension
implements Extension {
    private static final System.Logger LOGGER = System.getLogger(GrpcMpCdiExtension.class.getName());
    private Config config;

    private void discoverRoutes(@Observes @Initialized(value=ApplicationScoped.class) Object event, BeanManager beanManager) {
        this.config = MpConfig.toHelidonConfig((org.eclipse.microprofile.config.Config)ConfigProvider.getConfig());
        GrpcRouting.Builder routingBuilder = GrpcRouting.builder();
        this.loadExtensions(beanManager, this.config, routingBuilder);
        this.discoverGrpcRouting(beanManager, routingBuilder);
        ServerCdiExtension extension = (ServerCdiExtension)beanManager.getExtension(ServerCdiExtension.class);
        extension.addRouting((Builder)routingBuilder);
    }

    private void discoverGrpcRouting(BeanManager beanManager, GrpcRouting.Builder builder) {
        Instance instance = beanManager.createInstance();
        beanManager.getBeans(Object.class, new Annotation[]{Any.Literal.INSTANCE}).stream().filter(this::hasGrpcAnnotation).forEach(bean -> {
            Class beanClass = bean.getBeanClass();
            Annotation[] qualifiers = bean.getQualifiers().toArray(new Annotation[0]);
            Object service = instance.select(beanClass, qualifiers).get();
            this.register(service, builder, beanClass, beanManager);
        });
        beanManager.getBeans(GrpcService.class, new Annotation[0]).forEach(bean -> {
            Class beanClass = bean.getBeanClass();
            Annotation[] qualifiers = bean.getQualifiers().toArray(new Annotation[0]);
            Object service = instance.select(beanClass, qualifiers).get();
            builder.service((GrpcService)service);
        });
        beanManager.getBeans(BindableService.class, new Annotation[0]).forEach(bean -> {
            Class beanClass = bean.getBeanClass();
            Annotation[] qualifiers = bean.getQualifiers().toArray(new Annotation[0]);
            Object service = instance.select(beanClass, qualifiers).get();
            builder.service((BindableService)service);
        });
    }

    private boolean hasGrpcAnnotation(Bean<?> bean) {
        return bean.getTypes().stream().filter(t -> t instanceof Class && !((Class)t).isInterface()).anyMatch(c -> ((Class)c).isAnnotationPresent(Grpc.GrpcService.class));
    }

    private void register(Object service, GrpcRouting.Builder builder, Class<?> cls, BeanManager beanManager) {
        GrpcServiceBuilder serviceBuilder = GrpcServiceBuilder.create(cls, () -> service, beanManager);
        if (serviceBuilder.isAnnotatedService()) {
            builder.service(serviceBuilder.build());
        } else {
            LOGGER.log(System.Logger.Level.WARNING, () -> "Discovered type is not a properly annotated gRPC service " + String.valueOf(service.getClass()));
        }
    }

    private void loadExtensions(final BeanManager beanManager, final Config config, final GrpcRouting.Builder routingBuilder) {
        GrpcMpContext context = new GrpcMpContext(){

            @Override
            public Config config() {
                return config;
            }

            @Override
            public GrpcRouting.Builder routing() {
                return routingBuilder;
            }

            @Override
            public BeanManager beanManager() {
                return beanManager;
            }
        };
        HelidonServiceLoader.create(ServiceLoader.load(GrpcMpExtension.class)).forEach(ext -> ext.configure(context));
        beanManager.createInstance().select(GrpcMpExtension.class, new Annotation[0]).stream().forEach(ext -> ext.configure(context));
    }
}

