/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.graphql.server;

import io.helidon.microprofile.graphql.server.AbstractDescriptiveElement;
import io.helidon.microprofile.graphql.server.ElementGenerator;
import java.util.Arrays;
import java.util.Objects;

class SchemaArgument
extends AbstractDescriptiveElement
implements ElementGenerator {
    private final String argumentName;
    private String argumentType;
    private final boolean isMandatory;
    private Object defaultValue;
    private final Class<?> originalType;
    private boolean sourceArgument;
    private String[] format;
    private boolean isArrayReturnType;
    private int arrayLevels;
    private boolean isArrayReturnTypeMandatory;
    private Class<?> originalArrayType;
    private boolean isDataFetchingEnvironment;

    private SchemaArgument(Builder builder) {
        this.argumentName = builder.argumentName;
        this.argumentType = builder.argumentType;
        this.isMandatory = builder.isMandatory;
        this.defaultValue = builder.defaultValue;
        this.originalType = builder.originalType;
        this.sourceArgument = builder.sourceArgument;
        this.format = builder.format;
        this.isArrayReturnType = builder.isArrayReturnType;
        this.arrayLevels = builder.arrayLevels;
        this.isArrayReturnTypeMandatory = builder.isArrayReturnTypeMandatory;
        this.originalArrayType = builder.originalArrayType;
        this.isDataFetchingEnvironment = builder.isDataFetchingEnvironment;
        this.description(builder.description);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public String getSchemaAsString() {
        StringBuilder sb = new StringBuilder(this.getSchemaElementDescription(this.format())).append(this.argumentName()).append(':');
        if (this.isArrayReturnType()) {
            int count = this.arrayLevels();
            sb.append(" ").append(this.repeat(count, "[")).append(this.argumentType()).append(this.isArrayReturnTypeMandatory() ? Character.valueOf('!') : "").append(this.repeat(count, "]"));
        } else {
            sb.append(" ").append(this.argumentType());
        }
        if (this.isMandatory) {
            sb.append('!');
        }
        if (this.defaultValue != null) {
            sb.append(this.generateDefaultValue(this.defaultValue, this.argumentType()));
        }
        return sb.toString();
    }

    public String argumentName() {
        return this.argumentName;
    }

    public String argumentType() {
        return this.argumentType;
    }

    public boolean mandatory() {
        return this.isMandatory;
    }

    public void argumentType(String argumentType) {
        this.argumentType = argumentType;
    }

    public Object defaultValue() {
        return this.defaultValue;
    }

    public void defaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
    }

    public Class<?> originalType() {
        return this.originalType;
    }

    public boolean isSourceArgument() {
        return this.sourceArgument;
    }

    public void sourceArgument(boolean sourceArgument) {
        this.sourceArgument = sourceArgument;
    }

    public String[] format() {
        if (this.format == null) {
            return null;
        }
        String[] copy = new String[this.format.length];
        System.arraycopy(this.format, 0, copy, 0, copy.length);
        return copy;
    }

    public void format(String[] format) {
        if (format == null) {
            this.format = null;
        } else {
            this.format = new String[format.length];
            System.arraycopy(format, 0, this.format, 0, this.format.length);
        }
    }

    public void arrayLevels(int arrayLevels) {
        this.arrayLevels = arrayLevels;
    }

    public int arrayLevels() {
        return this.arrayLevels;
    }

    public void arrayReturnType(boolean isArrayReturnType) {
        this.isArrayReturnType = isArrayReturnType;
    }

    public boolean isArrayReturnType() {
        return this.isArrayReturnType;
    }

    public boolean isArrayReturnTypeMandatory() {
        return this.isArrayReturnTypeMandatory;
    }

    public void arrayReturnTypeMandatory(boolean arrayReturnTypeMandatory) {
        this.isArrayReturnTypeMandatory = arrayReturnTypeMandatory;
    }

    public boolean isDataFetchingEnvironment() {
        return this.isDataFetchingEnvironment;
    }

    public void originalArrayType(Class<?> originalArrayType) {
        this.originalArrayType = originalArrayType;
    }

    public Class<?> originalArrayType() {
        return this.originalArrayType;
    }

    public String toString() {
        return "Argument{argumentName='" + this.argumentName + "', argumentType='" + this.argumentType + "', isMandatory=" + this.isMandatory + ", defaultValue=" + String.valueOf(this.defaultValue) + ", originalType=" + String.valueOf(this.originalType) + ", sourceArgument=" + this.sourceArgument + ", isReturnTypeMandatory=" + this.isArrayReturnTypeMandatory + ", isArrayReturnType=" + this.isArrayReturnType + ", originalArrayType=" + String.valueOf(this.originalArrayType) + ", isDataFetchingEnvironment=" + this.isDataFetchingEnvironment + ", arrayLevels=" + this.arrayLevels + ", format=" + Arrays.toString(this.format) + ", description='" + this.description() + "'}";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SchemaArgument schemaArgument = (SchemaArgument)o;
        return this.isMandatory == schemaArgument.isMandatory && Objects.equals(this.argumentName, schemaArgument.argumentName) && Objects.equals(this.argumentType, schemaArgument.argumentType) && Objects.equals(this.originalType, schemaArgument.originalType) && Arrays.equals(this.format, schemaArgument.format) && Objects.equals(this.sourceArgument, schemaArgument.sourceArgument) && Objects.equals(this.originalArrayType, schemaArgument.originalArrayType) && Objects.equals(this.isDataFetchingEnvironment, schemaArgument.isDataFetchingEnvironment) && Objects.equals(this.description(), schemaArgument.description()) && Objects.equals(this.defaultValue, schemaArgument.defaultValue);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.argumentName, this.argumentType, this.sourceArgument, this.isDataFetchingEnvironment, this.isMandatory, this.defaultValue, this.description(), this.originalType, this.format, this.originalArrayType);
    }

    public static class Builder
    implements io.helidon.common.Builder<Builder, SchemaArgument> {
        private String argumentName;
        private String argumentType;
        private String description;
        private boolean isMandatory;
        private Object defaultValue;
        private Class<?> originalType;
        private boolean sourceArgument;
        private String[] format;
        private boolean isArrayReturnType;
        private int arrayLevels;
        private boolean isArrayReturnTypeMandatory;
        private Class<?> originalArrayType;
        private boolean isDataFetchingEnvironment;

        public Builder argumentName(String argumentName) {
            this.argumentName = argumentName;
            return this;
        }

        public Builder argumentType(String argumentType) {
            this.argumentType = argumentType;
            return this;
        }

        public Builder mandatory(boolean isMandatory) {
            this.isMandatory = isMandatory;
            return this;
        }

        public Builder defaultValue(Object defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder originalType(Class<?> originalType) {
            this.originalType = originalType;
            return this;
        }

        public Builder sourceArgument(boolean sourceArgument) {
            this.sourceArgument = sourceArgument;
            return this;
        }

        public Builder format(String[] format) {
            if (format == null) {
                this.format = null;
            } else {
                this.format = new String[format.length];
                System.arraycopy(format, 0, this.format, 0, this.format.length);
            }
            return this;
        }

        public Builder arrayReturnType(boolean isArrayReturnType) {
            this.isArrayReturnType = isArrayReturnType;
            return this;
        }

        public Builder arrayLevels(int arrayLevels) {
            this.arrayLevels = arrayLevels;
            return this;
        }

        public Builder arrayReturnTypeMandatory(boolean isArrayReturnTypeMandatory) {
            this.isArrayReturnTypeMandatory = isArrayReturnTypeMandatory;
            return this;
        }

        public Builder originalArrayType(Class<?> originalArrayType) {
            this.originalArrayType = originalArrayType;
            return this;
        }

        public Builder dataFetchingEnvironment(boolean isDataFetchingEnvironment) {
            this.isDataFetchingEnvironment = isDataFetchingEnvironment;
            return this;
        }

        public SchemaArgument build() {
            Objects.requireNonNull(this.argumentName, "Argument name must be specified");
            Objects.requireNonNull(this.argumentType, "Argument type must be specified");
            return new SchemaArgument(this);
        }
    }
}

