/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.graphql.server;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Index;
import org.jboss.jandex.IndexReader;

class JandexUtils {
    private static final System.Logger LOGGER = System.getLogger(JandexUtils.class.getName());
    protected static final String DEFAULT_INDEX_FILE = "META-INF/jandex.idx";
    public static final String PROP_INDEX_FILE = "io.helidon.microprofile.graphql.indexfile";
    private Set<Index> setIndexes = new HashSet<Index>();
    private String indexFile = System.getProperty("io.helidon.microprofile.graphql.indexfile", "META-INF/jandex.idx");

    private JandexUtils() {
    }

    public static JandexUtils create() {
        return new JandexUtils();
    }

    public void loadIndexes() {
        try {
            List<URL> listUrls = this.findIndexFiles(this.indexFile);
            for (URL url : listUrls) {
                try {
                    InputStream input = url.openStream();
                    try {
                        this.setIndexes.add(new IndexReader(input).read());
                    }
                    finally {
                        if (input == null) continue;
                        input.close();
                    }
                }
                catch (Exception e) {
                    LOGGER.log(System.Logger.Level.WARNING, "Unable to load default Jandex index file: " + String.valueOf(url) + " : " + e.getMessage());
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private List<URL> findIndexFiles(String indexFileName) throws IOException {
        ArrayList<URL> result = new ArrayList<URL>();
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        File file = new File(this.indexFile);
        if (file.isAbsolute()) {
            result.add(file.toPath().toUri().toURL());
            return result;
        }
        Enumeration<URL> urls = contextClassLoader.getResources(indexFileName);
        while (urls.hasMoreElements()) {
            result.add(urls.nextElement());
        }
        return result;
    }

    public Collection<Class<?>> getKnownImplementors(String clazz, boolean includeAbstract) {
        HashSet setResults = new HashSet();
        if (!this.hasIndex()) {
            return null;
        }
        for (Index index : this.setIndexes) {
            Set allKnownImplementors = index.getAllKnownImplementors(DotName.createSimple((String)clazz));
            for (ClassInfo classInfo : allKnownImplementors) {
                Class<?> clazzName = null;
                try {
                    clazzName = Class.forName(classInfo.toString());
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                if (!includeAbstract && Modifier.isAbstract(clazzName.getModifiers())) continue;
                setResults.add(clazzName);
            }
        }
        return setResults;
    }

    public Collection<Class<?>> getKnownImplementors(String clazz) {
        return this.getKnownImplementors(clazz, false);
    }

    public boolean hasIndex() {
        return this.setIndexes != null && this.setIndexes.size() > 0;
    }

    public Set<Index> getIndexes() {
        return this.setIndexes;
    }

    public String getIndexFile() {
        return this.indexFile;
    }
}

