/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.graphql.server;

import graphql.schema.GraphQLSchema;
import io.helidon.config.Config;
import io.helidon.graphql.server.InvocationHandler;
import io.helidon.microprofile.graphql.server.GraphQlBean;
import io.helidon.microprofile.graphql.server.SchemaGenerator;
import io.helidon.microprofile.server.ServerCdiExtension;
import io.helidon.nima.graphql.server.GraphQlService;
import io.helidon.nima.webserver.http.HttpRouting;
import jakarta.annotation.Priority;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.Initialized;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.spi.AfterBeanDiscovery;
import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.BeforeBeanDiscovery;
import jakarta.enterprise.inject.spi.DeploymentException;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.enterprise.inject.spi.ProcessAnnotatedType;
import jakarta.enterprise.inject.spi.ProcessManagedBean;
import jakarta.enterprise.inject.spi.WithAnnotations;
import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.graphql.GraphQLApi;
import org.eclipse.microprofile.graphql.Input;
import org.eclipse.microprofile.graphql.Interface;
import org.eclipse.microprofile.graphql.Type;

public class GraphQlCdiExtension
implements Extension {
    private static final System.Logger LOGGER = System.getLogger(GraphQlCdiExtension.class.getName());
    private final Set<Class<?>> candidateApis = new HashSet();
    private final Set<Class<?>> collectedApis = new HashSet();

    void collectCandidateApis(@Observes @WithAnnotations(value={GraphQLApi.class}) ProcessAnnotatedType<?> processAnnotatedType) {
        Class javaClass = processAnnotatedType.getAnnotatedType().getJavaClass();
        this.candidateApis.add(javaClass);
        if (javaClass.isInterface()) {
            this.collectedApis.add(javaClass);
        }
    }

    void collectApis(@Observes @WithAnnotations(value={Type.class, Input.class, Interface.class}) ProcessAnnotatedType<?> processAnnotatedType) {
        this.collectedApis.add(processAnnotatedType.getAnnotatedType().getJavaClass());
    }

    void collectNonVetoed(@Observes ProcessManagedBean<?> event) {
        AnnotatedType type = event.getAnnotatedBeanClass();
        Class clazz = type.getJavaClass();
        if (this.candidateApis.remove(clazz)) {
            this.collectedApis.add(clazz);
        }
    }

    void addGraphQlBeans(@Observes BeforeBeanDiscovery event) {
        event.addAnnotatedType(GraphQlBean.class, GraphQlBean.class.getName()).add((Annotation)ApplicationScoped.Literal.INSTANCE);
    }

    void clearCandidates(@Observes AfterBeanDiscovery event) {
        this.candidateApis.clear();
    }

    void registerWithWebServer(@Observes @Priority(value=1009) @Initialized(value=ApplicationScoped.class) Object event, BeanManager bm) {
        org.eclipse.microprofile.config.Config config = ConfigProvider.getConfig();
        Config graphQlConfig = ((Config)config).get("graphql");
        InvocationHandler.Builder handlerBuilder = InvocationHandler.builder().config((io.helidon.common.config.Config)graphQlConfig).schema(this.createSchema());
        config.getOptionalValue("mp.graphql.defaultErrorMessage", String.class).ifPresent(arg_0 -> ((InvocationHandler.Builder)handlerBuilder).defaultErrorMessage(arg_0));
        config.getOptionalValue("mp.graphql.exceptionsWhiteList", String[].class).ifPresent(arg_0 -> ((InvocationHandler.Builder)handlerBuilder).exceptionWhitelist(arg_0));
        config.getOptionalValue("mp.graphql.exceptionsBlackList", String[].class).ifPresent(arg_0 -> ((InvocationHandler.Builder)handlerBuilder).exceptionBlacklist(arg_0));
        GraphQlService service = GraphQlService.builder().config(graphQlConfig).invocationHandler((Supplier)handlerBuilder).build();
        try {
            ServerCdiExtension server = (ServerCdiExtension)bm.getExtension(ServerCdiExtension.class);
            Optional routingNameConfig = config.getOptionalValue("graphql.routing", String.class);
            HttpRouting.Builder routing = routingNameConfig.stream().filter(Predicate.not("@default"::equals)).map(arg_0 -> ((ServerCdiExtension)server).serverNamedRoutingBuilder(arg_0)).findFirst().orElseGet(() -> ((ServerCdiExtension)server).serverRoutingBuilder());
            routing.register(new Supplier[]{service});
        }
        catch (Throwable e) {
            LOGGER.log(System.Logger.Level.WARNING, "Failed to set up routing with web server, maybe server extension missing?", e);
        }
    }

    Set<Class<?>> collectedApis() {
        return this.collectedApis;
    }

    private GraphQLSchema createSchema() {
        try {
            return SchemaGenerator.builder().classes(this.collectedApis).build().generateSchema().generateGraphQLSchema();
        }
        catch (Exception e) {
            throw new DeploymentException("Failed to set up graphQL", (Throwable)e);
        }
    }
}

