/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.graphql.server;

import graphql.Scalars;
import graphql.language.StringValue;
import graphql.scalars.ExtendedScalars;
import graphql.schema.Coercing;
import graphql.schema.CoercingParseLiteralException;
import graphql.schema.CoercingParseValueException;
import graphql.schema.CoercingSerializeException;
import graphql.schema.GraphQLScalarType;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Date;

class CustomScalars {
    static final GraphQLScalarType CUSTOM_BIGDECIMAL_SCALAR = CustomScalars.newCustomBigDecimalScalar();
    static final GraphQLScalarType CUSTOM_INT_SCALAR = CustomScalars.newCustomGraphQLInt();
    static final GraphQLScalarType CUSTOM_FLOAT_SCALAR = CustomScalars.newCustomGraphQLFloat();
    static final GraphQLScalarType CUSTOM_BIGINTEGER_SCALAR = CustomScalars.newCustomGraphQLBigInteger();
    static final GraphQLScalarType FORMATTED_CUSTOM_DATE_TIME_SCALAR = CustomScalars.newDateTimeScalar("FormattedDateTime");
    static final GraphQLScalarType FORMATTED_CUSTOM_TIME_SCALAR = CustomScalars.newTimeScalar("FormattedTime");
    static final GraphQLScalarType FORMATTED_CUSTOM_DATE_SCALAR = CustomScalars.newDateScalar("FormattedDate");
    static final GraphQLScalarType CUSTOM_DATE_TIME_SCALAR = CustomScalars.newDateTimeScalar("DateTime");
    static final GraphQLScalarType CUSTOM_OFFSET_DATE_TIME_SCALAR = CustomScalars.newOffsetDateTimeScalar("FormattedOffsetDateTime");
    static final GraphQLScalarType CUSTOM_ZONED_DATE_TIME_SCALAR = CustomScalars.newZonedDateTimeScalar("FormattedZonedDateTime");
    static final GraphQLScalarType CUSTOM_TIME_SCALAR = CustomScalars.newTimeScalar("Time");
    static final GraphQLScalarType CUSTOM_DATE_SCALAR = CustomScalars.newDateScalar("Date");

    private CustomScalars() {
    }

    static GraphQLScalarType newDateTimeScalar(String name) {
        GraphQLScalarType originalScalar = ExtendedScalars.DateTime;
        return GraphQLScalarType.newScalar().coercing((Coercing)new DateTimeCoercing()).name(name).description("Custom: " + originalScalar.getDescription()).build();
    }

    static GraphQLScalarType newOffsetDateTimeScalar(String name) {
        GraphQLScalarType originalScalar = ExtendedScalars.DateTime;
        return GraphQLScalarType.newScalar().coercing((Coercing)new DateTimeCoercing()).name(name).description("Custom: " + originalScalar.getDescription()).build();
    }

    static GraphQLScalarType newZonedDateTimeScalar(String name) {
        GraphQLScalarType originalScalar = ExtendedScalars.DateTime;
        return GraphQLScalarType.newScalar().coercing((Coercing)new DateTimeCoercing()).name(name).description("Custom: " + originalScalar.getDescription()).build();
    }

    static GraphQLScalarType newTimeScalar(String name) {
        GraphQLScalarType originalScalar = ExtendedScalars.Time;
        return GraphQLScalarType.newScalar().coercing((Coercing)new TimeCoercing()).name(name).description("Custom: " + originalScalar.getDescription()).build();
    }

    static GraphQLScalarType newDateScalar(String name) {
        GraphQLScalarType originalScalar = ExtendedScalars.Date;
        return GraphQLScalarType.newScalar().coercing((Coercing)new DateCoercing()).name(name).description("Custom: " + originalScalar.getDescription()).build();
    }

    private static GraphQLScalarType newCustomBigDecimalScalar() {
        GraphQLScalarType originalScalar = ExtendedScalars.GraphQLBigDecimal;
        return GraphQLScalarType.newScalar().coercing(new NumberCoercing(originalScalar.getCoercing())).name(originalScalar.getName()).description("Custom: " + originalScalar.getDescription()).build();
    }

    private static GraphQLScalarType newCustomGraphQLInt() {
        GraphQLScalarType originalScalar = Scalars.GraphQLInt;
        return GraphQLScalarType.newScalar().coercing(new NumberCoercing(originalScalar.getCoercing())).name(originalScalar.getName()).description("Custom: " + originalScalar.getDescription()).build();
    }

    private static GraphQLScalarType newCustomGraphQLFloat() {
        GraphQLScalarType originalScalar = Scalars.GraphQLFloat;
        return GraphQLScalarType.newScalar().coercing(new NumberCoercing(originalScalar.getCoercing())).name(originalScalar.getName()).description("Custom: " + originalScalar.getDescription()).build();
    }

    private static GraphQLScalarType newCustomGraphQLBigInteger() {
        GraphQLScalarType originalScalar = ExtendedScalars.GraphQLBigInteger;
        return GraphQLScalarType.newScalar().coercing(new NumberCoercing(originalScalar.getCoercing())).name(originalScalar.getName()).description("Custom: " + originalScalar.getDescription()).build();
    }

    static class DateTimeCoercing
    extends AbstractDateTimeCoercing {
        DateTimeCoercing() {
            super(LocalDateTime.class, OffsetDateTime.class, ZonedDateTime.class);
        }
    }

    static class TimeCoercing
    extends AbstractDateTimeCoercing {
        TimeCoercing() {
            super(LocalTime.class, OffsetTime.class);
        }
    }

    static class DateCoercing
    extends AbstractDateTimeCoercing {
        DateCoercing() {
            super(LocalDate.class, Date.class);
        }
    }

    static class NumberCoercing<I>
    implements Coercing<I, Object> {
        private final Coercing originalCoercing;

        NumberCoercing(Coercing originalCoercing) {
            this.originalCoercing = originalCoercing;
        }

        public Object serialize(Object dataFetcherResult) throws CoercingSerializeException {
            return dataFetcherResult instanceof String ? (String)dataFetcherResult : this.originalCoercing.serialize(dataFetcherResult);
        }

        public I parseValue(Object input) throws CoercingParseValueException {
            return (I)this.originalCoercing.parseValue(input);
        }

        public I parseLiteral(Object input) throws CoercingParseLiteralException {
            return (I)this.originalCoercing.parseLiteral(input);
        }
    }

    static class BigDecimalCoercing
    extends AbstractDateTimeCoercing {
        BigDecimalCoercing() {
            super(BigDecimal.class);
        }
    }

    static abstract class AbstractDateTimeCoercing
    implements Coercing {
        private final Class<?>[] clazzes;

        AbstractDateTimeCoercing(Class<?> ... clazzes) {
            this.clazzes = clazzes;
        }

        public Object serialize(Object dataFetcherResult) throws CoercingSerializeException {
            return this.convert(dataFetcherResult);
        }

        public Object parseValue(Object input) throws CoercingParseValueException {
            return this.convert(input);
        }

        public Object parseLiteral(Object input) throws CoercingParseLiteralException {
            return this.parseStringLiteral(input);
        }

        private Object convert(Object input) throws CoercingParseLiteralException {
            if (input instanceof String) {
                return input;
            }
            for (Class<?> clazz : this.clazzes) {
                if (!clazz.isInstance(input)) continue;
                return input;
            }
            throw new CoercingParseLiteralException("Unable to convert type of " + input.getClass().toString() + " with classes " + Arrays.toString(this.clazzes));
        }

        private String parseStringLiteral(Object input) throws CoercingParseLiteralException {
            if (!(input instanceof StringValue)) {
                throw new CoercingParseLiteralException("Expected AST type 'StringValue' but was '" + (input == null ? "null" : input.getClass().getSimpleName()) + "'.");
            }
            return ((StringValue)input).getValue();
        }
    }
}

