/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.graphql.server;

import graphql.schema.DataFetcher;
import io.helidon.microprofile.graphql.server.AbstractDescriptiveElement;
import io.helidon.microprofile.graphql.server.ElementGenerator;
import io.helidon.microprofile.graphql.server.SchemaArgument;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

class SchemaFieldDefinition
extends AbstractDescriptiveElement
implements ElementGenerator {
    private final String name;
    private String returnType;
    private final boolean isArrayReturnType;
    private final int arrayLevels;
    private final boolean isReturnTypeMandatory;
    private final List<SchemaArgument> listSchemaArguments;
    private boolean isArrayReturnTypeMandatory;
    private DataFetcher dataFetcher;
    private Class<?> originalType;
    private Class<?> originalArrayType;
    private String[] format;
    private Object defaultValue;
    private boolean defaultFormatApplied;
    private boolean isJsonbFormat;
    private boolean isJsonbProperty;

    private SchemaFieldDefinition(Builder builder) {
        this.name = builder.name;
        this.returnType = builder.returnType;
        this.isArrayReturnType = builder.isArrayReturnType;
        this.arrayLevels = builder.arrayLevels;
        this.isReturnTypeMandatory = builder.isReturnTypeMandatory;
        this.listSchemaArguments = builder.listSchemaArguments;
        this.isArrayReturnTypeMandatory = builder.isArrayReturnTypeMandatory;
        this.dataFetcher = builder.dataFetcher;
        this.originalType = builder.originalType;
        this.originalArrayType = builder.originalArrayType;
        this.format = builder.format;
        this.defaultValue = builder.defaultValue;
        this.defaultFormatApplied = builder.defaultFormatApplied;
        this.isJsonbFormat = builder.isJsonbFormat;
        this.isJsonbProperty = builder.isJsonbProperty;
        this.description(builder.description);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public String getSchemaAsString() {
        StringBuilder sb = new StringBuilder(this.getSchemaElementDescription(this.format())).append(this.name());
        boolean hasSchemaArguments = this.listSchemaArguments.stream().anyMatch(a -> !a.isDataFetchingEnvironment());
        if (hasSchemaArguments) {
            sb.append('(').append('\n').append(this.listSchemaArguments.stream().filter(a -> !a.isDataFetchingEnvironment()).map(SchemaArgument::getSchemaAsString).collect(Collectors.joining(", \n")));
            sb.append('\n').append(')');
        }
        sb.append(':');
        if (this.isArrayReturnType()) {
            int count = this.arrayLevels();
            sb.append(" ").append(this.repeat(count, "[")).append(this.returnType()).append(this.isArrayReturnTypeMandatory() ? Character.valueOf('!') : "").append(this.repeat(count, "]"));
        } else {
            sb.append(" ").append(this.returnType());
        }
        if (this.isReturnTypeMandatory()) {
            sb.append('!');
        }
        if (this.defaultValue != null) {
            sb.append(this.generateDefaultValue(this.defaultValue, this.returnType()));
        }
        return sb.toString();
    }

    public String name() {
        return this.name;
    }

    public List<SchemaArgument> arguments() {
        return this.listSchemaArguments;
    }

    public String returnType() {
        return this.returnType;
    }

    public boolean isArrayReturnType() {
        return this.isArrayReturnType;
    }

    public boolean isReturnTypeMandatory() {
        return this.isReturnTypeMandatory;
    }

    public DataFetcher dataFetcher() {
        return this.dataFetcher;
    }

    public void returnType(String sReturnType) {
        this.returnType = sReturnType;
    }

    public void dataFetcher(DataFetcher dataFetcher) {
        this.dataFetcher = dataFetcher;
    }

    public void addArgument(SchemaArgument schemaArgument) {
        this.listSchemaArguments.add(schemaArgument);
    }

    public int arrayLevels() {
        return this.arrayLevels;
    }

    public String[] format() {
        if (this.format == null) {
            return null;
        }
        String[] copy = new String[this.format.length];
        System.arraycopy(this.format, 0, copy, 0, copy.length);
        return copy;
    }

    public void format(String[] format) {
        if (format == null) {
            this.format = null;
        } else {
            this.format = new String[format.length];
            System.arraycopy(format, 0, this.format, 0, this.format.length);
        }
    }

    public Object defaultValue() {
        return this.defaultValue;
    }

    public void defaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
    }

    public void originalType(Class<?> originalType) {
        this.originalType = originalType;
    }

    public Class<?> originalType() {
        return this.originalType;
    }

    public void originalArrayType(Class<?> originalArrayType) {
        this.originalArrayType = originalArrayType;
    }

    public Class<?> originalArrayType() {
        return this.originalArrayType;
    }

    public boolean isArrayReturnTypeMandatory() {
        return this.isArrayReturnTypeMandatory;
    }

    public void arrayReturnTypeMandatory(boolean arrayReturnTypeMandatory) {
        this.isArrayReturnTypeMandatory = arrayReturnTypeMandatory;
    }

    public void defaultFormatApplied(boolean defaultFormatApplied) {
        this.defaultFormatApplied = defaultFormatApplied;
    }

    public boolean isDefaultFormatApplied() {
        return this.defaultFormatApplied;
    }

    public void jsonbFormat(boolean isJsonbFormat) {
        this.isJsonbFormat = isJsonbFormat;
    }

    public boolean isJsonbFormat() {
        return this.isJsonbFormat;
    }

    public void jsonbProperty(boolean isJsonbProperty) {
        this.isJsonbProperty = isJsonbProperty;
    }

    public boolean isJsonbProperty() {
        return this.isJsonbProperty;
    }

    public String toString() {
        return "FieldDefinition{name='" + this.name + "', returnType='" + this.returnType + "', isArrayReturnType=" + this.isArrayReturnType + ", isReturnTypeMandatory=" + this.isReturnTypeMandatory + ", isArrayReturnTypeMandatory=" + this.isArrayReturnTypeMandatory + ", listArguments=" + this.listSchemaArguments + ", arrayLevels=" + this.arrayLevels + ", originalType=" + this.originalType + ", defaultFormatApplied=" + this.defaultFormatApplied + ", originalArrayType=" + this.originalArrayType + ", format=" + Arrays.toString(this.format) + ", isJsonbFormat=" + this.isJsonbFormat + ", isJsonbProperty=" + this.isJsonbProperty + ", description='" + this.description() + "'}";
    }

    public static class Builder
    implements io.helidon.common.Builder<Builder, SchemaFieldDefinition> {
        private String name;
        private String returnType;
        private boolean isArrayReturnType;
        private int arrayLevels;
        private boolean isReturnTypeMandatory;
        private List<SchemaArgument> listSchemaArguments = new ArrayList<SchemaArgument>();
        private boolean isArrayReturnTypeMandatory;
        private DataFetcher dataFetcher;
        private Class<?> originalType;
        private Class<?> originalArrayType;
        private String[] format;
        private Object defaultValue;
        private boolean defaultFormatApplied;
        private boolean isJsonbFormat;
        private boolean isJsonbProperty;
        private String description;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder returnType(String returnType) {
            this.returnType = returnType;
            return this;
        }

        public Builder arrayReturnType(boolean isArrayReturnType) {
            this.isArrayReturnType = isArrayReturnType;
            return this;
        }

        public Builder returnTypeMandatory(boolean isReturnTypeMandatory) {
            this.isReturnTypeMandatory = isReturnTypeMandatory;
            return this;
        }

        public Builder arrayLevels(int arrayLevels) {
            this.arrayLevels = arrayLevels;
            return this;
        }

        public Builder addArgument(SchemaArgument argument) {
            this.listSchemaArguments.add(argument);
            return this;
        }

        public Builder arrayReturnTypeMandatory(boolean isArrayReturnTypeMandatory) {
            this.isArrayReturnTypeMandatory = isArrayReturnTypeMandatory;
            return this;
        }

        public Builder dataFetcher(DataFetcher dataFetcher) {
            this.dataFetcher = dataFetcher;
            return this;
        }

        public Builder originalType(Class<?> originalType) {
            this.originalType = originalType;
            return this;
        }

        public Builder originalArrayType(Class<?> originalArrayType) {
            this.originalArrayType = originalArrayType;
            return this;
        }

        public Builder format(String[] format) {
            if (format == null) {
                this.format = null;
            } else {
                this.format = new String[format.length];
                System.arraycopy(format, 0, this.format, 0, this.format.length);
            }
            return this;
        }

        public Builder defaultValue(Object defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public Builder defaultFormatApplied(boolean defaultFormatApplied) {
            this.defaultFormatApplied = defaultFormatApplied;
            return this;
        }

        public Builder jsonbFormat(boolean isJsonbFormat) {
            this.isJsonbFormat = isJsonbFormat;
            return this;
        }

        public Builder jsonbProperty(boolean isJsonbProperty) {
            this.isJsonbProperty = isJsonbProperty;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public SchemaFieldDefinition build() {
            Objects.requireNonNull(this.name, "Name must be specified");
            return new SchemaFieldDefinition(this);
        }
    }
}

