/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.graphql.server;

import graphql.schema.GraphQLScalarType;
import io.helidon.microprofile.graphql.server.ElementGenerator;
import java.util.Objects;

class SchemaScalar
implements ElementGenerator {
    private String name;
    private String actualClass;
    private GraphQLScalarType graphQLScalarType;
    private String defaultFormat;

    SchemaScalar(String name, String actualClass, GraphQLScalarType graphQLScalarType, String defaultFormat) {
        this.name = name;
        this.actualClass = actualClass;
        this.graphQLScalarType = graphQLScalarType;
        this.defaultFormat = defaultFormat;
    }

    String name() {
        return this.name;
    }

    String actualClass() {
        return this.actualClass;
    }

    GraphQLScalarType graphQLScalarType() {
        return this.graphQLScalarType;
    }

    String defaultFormat() {
        return this.defaultFormat;
    }

    void defaultFormat(String defaultFormat) {
        this.defaultFormat = defaultFormat;
    }

    @Override
    public String getSchemaAsString() {
        return "scalar " + this.name();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SchemaScalar schemaScalar = (SchemaScalar)o;
        return Objects.equals(this.name, schemaScalar.name) && Objects.equals(this.actualClass, schemaScalar.actualClass) && Objects.equals(this.defaultFormat, schemaScalar.defaultFormat) && Objects.equals(this.graphQLScalarType, schemaScalar.graphQLScalarType);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.actualClass, this.graphQLScalarType, this.defaultFormat);
    }

    public String toString() {
        return "Scalar{name='" + this.name + "', actualClass='" + this.actualClass + "', defaultFormat='" + this.defaultFormat + "', graphQLScalarType=" + this.graphQLScalarType + "}";
    }
}

