/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.graphql.server;

import io.helidon.microprofile.graphql.server.SchemaGeneratorHelper;
import io.helidon.microprofile.graphql.server.SchemaScalar;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Locale;
import java.util.logging.Logger;
import javax.json.bind.annotation.JsonbDateFormat;
import javax.json.bind.annotation.JsonbNumberFormat;
import org.eclipse.microprofile.graphql.DateFormat;

class FormattingHelper {
    private static final Logger LOGGER = Logger.getLogger(FormattingHelper.class.getName());
    private static final String[] NO_DEFAULT_FORMAT = new String[0];
    protected static final String DATE = "Date";
    protected static final String NUMBER = "Number";
    static final String[] NO_FORMATTING = new String[]{null, null, null};

    private FormattingHelper() {
    }

    protected static String[] getDefaultDateTimeFormat(String scalarName, String clazzName) {
        for (SchemaScalar scalar : SchemaGeneratorHelper.SUPPORTED_SCALARS.values()) {
            if (!scalarName.equals(scalar.name()) || !scalar.actualClass().equals(clazzName)) continue;
            return new String[]{scalar.defaultFormat(), "##default"};
        }
        return NO_DEFAULT_FORMAT;
    }

    protected static NumberFormat getCorrectNumberFormat(String type, String locale, String format) {
        NumberFormat numberFormat;
        Locale actualLocale;
        Locale locale2 = actualLocale = "##default".equals(locale) ? Locale.getDefault() : Locale.forLanguageTag(locale);
        if ("Float".equals(type) || "BigDecimal".equals(type) || SchemaGeneratorHelper.BIG_DECIMAL_CLASS.equals(type) || SchemaGeneratorHelper.FLOAT_CLASS.equals(type) || SchemaGeneratorHelper.FLOAT_PRIMITIVE_CLASS.equals(type) || SchemaGeneratorHelper.DOUBLE_CLASS.equals(type) || SchemaGeneratorHelper.DOUBLE_PRIMITIVE_CLASS.equals(type)) {
            numberFormat = NumberFormat.getNumberInstance(actualLocale);
        } else if ("Int".equals(type) || SchemaGeneratorHelper.INTEGER_CLASS.equals(type) || SchemaGeneratorHelper.INTEGER_PRIMITIVE_CLASS.equals(type) || SchemaGeneratorHelper.BIG_INTEGER_CLASS.equals(type) || SchemaGeneratorHelper.BYTE_CLASS.equals(type) || SchemaGeneratorHelper.SHORT_CLASS.equals(type) || SchemaGeneratorHelper.LONG_CLASS.equals(type) || SchemaGeneratorHelper.LONG_PRIMITIVE_CLASS.equals(type) || "BigInteger".equals(type)) {
            numberFormat = NumberFormat.getIntegerInstance(actualLocale);
        } else {
            return null;
        }
        if (format != null && !format.trim().equals("")) {
            ((DecimalFormat)numberFormat).applyPattern(format);
        }
        return numberFormat;
    }

    protected static DateTimeFormatter getCorrectDateFormatter(String type, String locale, String format) {
        DateTimeFormatter formatter;
        Locale actualLocale;
        Locale locale2 = actualLocale = "##default".equals(locale) ? Locale.getDefault() : Locale.forLanguageTag(locale);
        if (format != null && !SchemaGeneratorHelper.LEGACY_DATE_CLASS.equals(type)) {
            formatter = DateTimeFormatter.ofPattern(format, actualLocale);
        } else if (SchemaGeneratorHelper.OFFSET_TIME_CLASS.equals(type)) {
            formatter = DateTimeFormatter.ISO_OFFSET_TIME.withLocale(actualLocale);
        } else if (SchemaGeneratorHelper.LOCAL_TIME_CLASS.equals(type)) {
            formatter = DateTimeFormatter.ISO_LOCAL_TIME.withLocale(actualLocale);
        } else if (SchemaGeneratorHelper.OFFSET_DATE_TIME_CLASS.equals(type)) {
            formatter = DateTimeFormatter.ISO_OFFSET_DATE_TIME.withLocale(actualLocale);
        } else if (SchemaGeneratorHelper.ZONED_DATE_TIME_CLASS.equals(type)) {
            formatter = DateTimeFormatter.ISO_ZONED_DATE_TIME.withLocale(actualLocale);
        } else if (SchemaGeneratorHelper.LOCAL_DATE_TIME_CLASS.equals(type)) {
            formatter = DateTimeFormatter.ISO_LOCAL_DATE_TIME.withLocale(actualLocale);
        } else if (SchemaGeneratorHelper.LOCAL_DATE_CLASS.equals(type)) {
            formatter = DateTimeFormatter.ISO_LOCAL_DATE.withLocale(actualLocale);
        } else {
            return null;
        }
        return formatter;
    }

    protected static NumberFormat getCorrectNumberFormat(String type, String locale) {
        return FormattingHelper.getCorrectNumberFormat(type, locale, null);
    }

    protected static String[] getFormattingAnnotation(AnnotatedElement annotatedElement) {
        String[] stringArray;
        String[] dateFormat = FormattingHelper.getDateFormatAnnotation(annotatedElement);
        String[] numberFormat = FormattingHelper.getNumberFormatAnnotation(annotatedElement);
        if (dateFormat.length == 0 && numberFormat.length == 0) {
            return NO_FORMATTING;
        }
        if (dateFormat.length == 2 && numberFormat.length == 2) {
            SchemaGeneratorHelper.ensureRuntimeException(LOGGER, "A date format and number format cannot be applied to the same element: " + String.valueOf(annotatedElement));
        }
        if (dateFormat.length == 2) {
            String[] stringArray2 = new String[3];
            stringArray2[0] = DATE;
            stringArray2[1] = dateFormat[0];
            stringArray = stringArray2;
            stringArray2[2] = dateFormat[1];
        } else {
            String[] stringArray3 = new String[3];
            stringArray3[0] = NUMBER;
            stringArray3[1] = numberFormat[0];
            stringArray = stringArray3;
            stringArray3[2] = numberFormat[1];
        }
        return stringArray;
    }

    protected static String[] getFieldFormat(Field field, int index) {
        Annotation[] annotations = SchemaGeneratorHelper.getFieldAnnotations(field, index);
        if (annotations == null || annotations.length == 0) {
            annotations = field.getAnnotatedType().getAnnotations();
        }
        return FormattingHelper.getFormatFromAnnotations(annotations);
    }

    protected static String[] getMethodFormat(Method method, int index) {
        Annotation[] annotations = SchemaGeneratorHelper.getMethodAnnotations(method, index);
        if (annotations == null || annotations.length == 0) {
            annotations = method.getAnnotatedReturnType().getAnnotations();
        }
        return FormattingHelper.getFormatFromAnnotations(annotations);
    }

    protected static String[] getMethodParameterFormat(Parameter parameter, int index) {
        Annotation[] annotations = SchemaGeneratorHelper.getParameterAnnotations(parameter, index);
        if (annotations == null || annotations.length == 0) {
            annotations = parameter.getAnnotatedType().getAnnotations();
        }
        return FormattingHelper.getFormatFromAnnotations(annotations);
    }

    protected static String[] getFormatFromAnnotations(Annotation[] annotations) {
        if (annotations != null && annotations.length > 0) {
            JsonbDateFormat dateFormat1 = (JsonbDateFormat)SchemaGeneratorHelper.getAnnotationValue(annotations, JsonbDateFormat.class);
            DateFormat dateFormat2 = (DateFormat)SchemaGeneratorHelper.getAnnotationValue(annotations, DateFormat.class);
            JsonbNumberFormat numberFormat1 = (JsonbNumberFormat)SchemaGeneratorHelper.getAnnotationValue(annotations, JsonbNumberFormat.class);
            org.eclipse.microprofile.graphql.NumberFormat numberFormat2 = (org.eclipse.microprofile.graphql.NumberFormat)SchemaGeneratorHelper.getAnnotationValue(annotations, org.eclipse.microprofile.graphql.NumberFormat.class);
            if (!(dateFormat1 == null && dateFormat2 == null || numberFormat1 == null && numberFormat2 == null)) {
                SchemaGeneratorHelper.ensureRuntimeException(LOGGER, "Cannot have date and number formatting on the same method");
            }
            String format = null;
            String locale = null;
            if (dateFormat1 != null) {
                format = dateFormat1.value();
                locale = dateFormat1.locale();
            } else if (dateFormat2 != null) {
                format = dateFormat2.value();
                locale = dateFormat2.locale();
            } else if (numberFormat1 != null) {
                format = numberFormat1.value();
                locale = numberFormat1.locale();
            } else if (numberFormat2 != null) {
                format = numberFormat2.value();
                locale = numberFormat2.locale();
            }
            if (format == null) {
                return NO_FORMATTING;
            }
            String type = dateFormat1 != null || dateFormat2 != null ? DATE : NUMBER;
            return new String[]{type, format, locale.equals("") ? "##default" : locale};
        }
        return NO_FORMATTING;
    }

    protected static boolean isJsonbAnnotationPresent(AnnotatedElement annotatedElement) {
        return annotatedElement.getAnnotation(JsonbDateFormat.class) != null || annotatedElement.getAnnotation(JsonbNumberFormat.class) != null;
    }

    protected static String[] getNumberFormatAnnotation(AnnotatedElement annotatedElement) {
        return FormattingHelper.getNumberFormatAnnotationInternal(annotatedElement.getAnnotation(JsonbNumberFormat.class), annotatedElement.getAnnotation(org.eclipse.microprofile.graphql.NumberFormat.class));
    }

    private static String[] getNumberFormatAnnotationInternal(JsonbNumberFormat jsonbNumberFormat, org.eclipse.microprofile.graphql.NumberFormat numberFormat) {
        if (numberFormat != null) {
            return new String[]{numberFormat.value(), numberFormat.locale()};
        }
        if (jsonbNumberFormat != null) {
            return new String[]{jsonbNumberFormat.value(), jsonbNumberFormat.locale()};
        }
        return new String[0];
    }

    protected static String[] getDateFormatAnnotation(AnnotatedElement annotatedElement) {
        return FormattingHelper.getDateFormatAnnotationInternal(annotatedElement.getAnnotation(JsonbDateFormat.class), annotatedElement.getAnnotation(DateFormat.class));
    }

    private static String[] getDateFormatAnnotationInternal(JsonbDateFormat jsonbDateFormat, DateFormat dateFormat) {
        if (dateFormat != null) {
            return new String[]{dateFormat.value(), dateFormat.locale()};
        }
        if (jsonbDateFormat != null) {
            return new String[]{jsonbDateFormat.value(), jsonbDateFormat.locale()};
        }
        return new String[0];
    }

    public static Object formatDate(Object originalResult, DateTimeFormatter dateTimeFormatter) {
        if (originalResult == null) {
            return null;
        }
        if (originalResult instanceof Collection) {
            ArrayList formattedResult = new ArrayList();
            Collection originalCollection = (Collection)originalResult;
            originalCollection.forEach(e -> formattedResult.add(e instanceof TemporalAccessor ? dateTimeFormatter.format((TemporalAccessor)e) : e));
            return formattedResult;
        }
        return originalResult instanceof TemporalAccessor ? dateTimeFormatter.format((TemporalAccessor)originalResult) : originalResult;
    }

    public static Object formatDate(Object originalResult, SimpleDateFormat simpleDateFormat) {
        if (originalResult == null) {
            return null;
        }
        if (originalResult instanceof Collection) {
            ArrayList formattedResult = new ArrayList();
            Collection originalCollection = (Collection)originalResult;
            originalCollection.forEach(e -> formattedResult.add(e instanceof DateTimeFormatter ? simpleDateFormat.format(e) : e));
            return formattedResult;
        }
        return originalResult instanceof Date ? simpleDateFormat.format(originalResult) : originalResult;
    }

    public static Object formatNumber(Object originalResult, boolean isScalar, NumberFormat numberFormat) {
        if (originalResult == null) {
            return null;
        }
        if (originalResult instanceof Collection) {
            ArrayList formattedResult = new ArrayList();
            Collection originalCollection = (Collection)originalResult;
            originalCollection.forEach(e -> formattedResult.add(numberFormat.format(e)));
            return formattedResult;
        }
        return numberFormat.format(originalResult);
    }
}

