/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.messaging;

import io.helidon.common.context.Context;
import io.helidon.common.context.Contexts;
import java.util.UUID;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

class ContextSubscriber<T>
implements Subscriber<T> {
    private final String prefix;
    private final Subscriber<T> subscriber;

    ContextSubscriber(String prefix, Subscriber<T> subscriber) {
        this.prefix = prefix;
        this.subscriber = subscriber;
    }

    static <T> ContextSubscriber<T> create(String prefix, Subscriber<T> subscriber) {
        return new ContextSubscriber<T>(prefix, subscriber);
    }

    public void onSubscribe(Subscription s) {
        this.subscriber.onSubscribe(s);
    }

    public void onNext(T item) {
        this.runInNewContext(() -> this.subscriber.onNext(item));
    }

    public void onError(Throwable t) {
        this.runInNewContext(() -> this.subscriber.onError(t));
    }

    public void onComplete() {
        this.runInNewContext(() -> this.subscriber.onComplete());
    }

    void runInNewContext(Runnable runnable) {
        Context.Builder contextBuilder = Context.builder().id(String.format("%s-%s:", this.prefix, UUID.randomUUID().toString()));
        Contexts.context().ifPresent(arg_0 -> ((Context.Builder)contextBuilder).parent(arg_0));
        Contexts.runInContext((Context)contextBuilder.build(), (Runnable)runnable);
    }
}

