/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.messaging;

import io.helidon.common.Builder;
import io.helidon.config.Config;
import io.helidon.config.ConfigSources;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;

public abstract class ConnectorConfigBuilder
implements Builder<Config> {
    private final Map<String, String> configuration = new HashMap<String, String>();

    protected ConnectorConfigBuilder() {
    }

    static ConnectorConfigBuilder create(Config config) {
        ConnectorConfigBuilder result = new ConnectorConfigBuilder(){};
        result.config(config);
        return result;
    }

    protected ConnectorConfigBuilder property(String key, String value) {
        this.configuration.put(key, value);
        return this;
    }

    ConnectorConfigBuilder config(Config configToPut) {
        this.configuration.putAll((Map)configToPut.detach().asMap().orElse(Map.of()));
        return this;
    }

    public Config build() {
        return Config.builder((Supplier[])new Supplier[]{ConfigSources.create(this.configuration)}).disableEnvironmentVariablesSource().disableSystemPropertiesSource().disableFilterServices().disableParserServices().build();
    }
}

