/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.messaging;

import io.helidon.config.Config;
import io.helidon.config.ConfigSources;
import io.helidon.config.ConfigValue;
import io.helidon.config.mp.MpConfigSources;
import io.helidon.messaging.ConnectorConfigBuilder;
import io.helidon.messaging.MessagingException;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.microprofile.config.spi.ConfigProviderResolver;
import org.eclipse.microprofile.config.spi.ConfigSource;

final class ConnectorConfigHelper {
    private ConnectorConfigHelper() {
    }

    static ConfigValue<String> getIncomingConnectorName(Config config, String channelName) {
        return config.get("mp.messaging.incoming.").get(channelName).get("connector").asString();
    }

    static ConfigValue<String> getOutgoingConnectorName(Config config, String channelName) {
        return config.get("mp.messaging.outgoing.").get(channelName).get("connector").asString();
    }

    static io.helidon.config.spi.ConfigSource prefixedConfigSource(String prefix, Config config) {
        return ConfigSources.create(((Map)config.detach().asMap().orElse(Map.of())).entrySet().stream().collect(Collectors.toMap(e -> prefix + "." + (String)e.getKey(), Map.Entry::getValue))).build();
    }

    static org.eclipse.microprofile.config.Config getConnectorConfig(String channelName, String connectorName, Config rootConfig) {
        Config incomingChannelConfig = rootConfig.get("mp.messaging.incoming");
        Config outgoingChannelConfig = rootConfig.get("mp.messaging.outgoing");
        Config channelsConfig = ConnectorConfigBuilder.create(incomingChannelConfig).config(outgoingChannelConfig).build();
        Config channelConfig = channelsConfig.get(channelName);
        ConfigValue configConnectorName = channelConfig.get("connector").asString();
        if (!configConnectorName.isPresent()) {
            throw new MessagingException(String.format("No connector configured for channel %s", channelName));
        }
        if (!((String)configConnectorName.get()).equals(connectorName)) {
            throw new MessagingException(String.format("Connector name miss match for channel%s", channelName));
        }
        Config connectorConfig = rootConfig.get("mp.messaging.connector").get((String)configConnectorName.get());
        return ConfigProviderResolver.instance().getBuilder().withSources(new ConfigSource[]{MpConfigSources.create((Config)ConnectorConfigBuilder.create(connectorConfig).property("channel-name", channelName).config(channelConfig).build())}).build();
    }
}

