/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.json.schema.codegen;

import io.helidon.codegen.CodegenContext;
import io.helidon.codegen.CodegenException;
import io.helidon.codegen.ElementInfoPredicates;
import io.helidon.common.types.AccessModifier;
import io.helidon.common.types.Annotated;
import io.helidon.common.types.ElementKind;
import io.helidon.common.types.TypeInfo;
import io.helidon.common.types.TypeName;
import io.helidon.common.types.TypeNames;
import io.helidon.common.types.TypedElementInfo;
import io.helidon.json.schema.codegen.SchemaObjectProperty;
import io.helidon.json.schema.codegen.Types;
import io.helidon.metadata.hson.Hson;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;

record SchemaInfo(TypeName generatedSchema, Hson.Struct schema) {
    private static final Map<TypeName, TypeName> BOXED_TO_PRIMITIVE = Map.of(TypeNames.BOXED_BOOLEAN, TypeNames.PRIMITIVE_BOOLEAN, TypeNames.BOXED_BYTE, TypeNames.PRIMITIVE_BYTE, TypeNames.BOXED_SHORT, TypeNames.PRIMITIVE_SHORT, TypeNames.BOXED_INT, TypeNames.PRIMITIVE_INT, TypeNames.BOXED_LONG, TypeNames.PRIMITIVE_LONG, TypeNames.BOXED_CHAR, TypeNames.PRIMITIVE_CHAR, TypeNames.BOXED_FLOAT, TypeNames.PRIMITIVE_FLOAT, TypeNames.BOXED_DOUBLE, TypeNames.PRIMITIVE_DOUBLE, TypeNames.BOXED_VOID, TypeNames.PRIMITIVE_VOID);
    private static final Set<TypeName> INTEGERS = Set.of(TypeNames.PRIMITIVE_BYTE, TypeNames.PRIMITIVE_SHORT, TypeNames.PRIMITIVE_INT, TypeNames.PRIMITIVE_LONG, Types.BIG_INTEGER);
    private static final Set<TypeName> NUMBERS = Set.of(TypeNames.PRIMITIVE_FLOAT, TypeNames.PRIMITIVE_DOUBLE, Types.BIG_DECIMAL, Types.NUMBER);

    static SchemaInfo create(TypeInfo annotatedType, CodegenContext ctx) {
        TypeName annotatedTypeName = annotatedType.typeName();
        TypeName generatedTypeName = ((TypeName.Builder)((TypeName.Builder)TypeName.builder().from(annotatedTypeName)).className(annotatedTypeName.className() + "__JsonSchema")).build();
        Hson.Struct.Builder schemaBuilder = Hson.structBuilder().set("$schema", "https://json-schema.org/draft/2020-12/schema");
        annotatedType.findAnnotation(Types.JSON_SCHEMA_ID).flatMap(it -> it.stringValue()).ifPresent(it -> schemaBuilder.set("$id", it));
        SchemaInfo.processObject(schemaBuilder, annotatedType, ctx, new AtomicBoolean());
        return new SchemaInfo(generatedTypeName, (Hson.Struct)schemaBuilder.build());
    }

    private static void processCommonAnnotations(Hson.Struct.Builder builder, Annotated annotatedType, AtomicBoolean required) {
        annotatedType.findAnnotation(Types.JSON_SCHEMA_TITLE).flatMap(it -> it.stringValue()).ifPresent(it -> builder.set("title", it));
        annotatedType.findAnnotation(Types.JSON_SCHEMA_DESCRIPTION).flatMap(it -> it.stringValue()).ifPresent(it -> builder.set("description", it));
        annotatedType.findAnnotation(Types.JSON_SCHEMA_REQUIRED).ifPresent(it -> required.set(true));
    }

    private static void processIntegerAnnotations(Hson.Struct.Builder builder, Annotated annotatedType, AtomicBoolean required) {
        SchemaInfo.processCommonAnnotations(builder, annotatedType, required);
        builder.set("type", "integer");
        annotatedType.findAnnotation(Types.JSON_SCHEMA_INTEGER_MINIMUM).flatMap(it -> it.longValue()).ifPresent(it -> builder.set("minimum", it.longValue()));
        annotatedType.findAnnotation(Types.JSON_SCHEMA_INTEGER_MAXIMUM).flatMap(it -> it.longValue()).ifPresent(it -> builder.set("maximum", it.longValue()));
        annotatedType.findAnnotation(Types.JSON_SCHEMA_INTEGER_MULTIPLE_OF).flatMap(it -> it.longValue()).ifPresent(it -> builder.set("multipleOf", it.longValue()));
        annotatedType.findAnnotation(Types.JSON_SCHEMA_INTEGER_EXCLUSIVE_MINIMUM).flatMap(it -> it.longValue()).ifPresent(it -> builder.set("exclusiveMinimum", it.longValue()));
        annotatedType.findAnnotation(Types.JSON_SCHEMA_INTEGER_EXCLUSIVE_MAXIMUM).flatMap(it -> it.longValue()).ifPresent(it -> builder.set("exclusiveMaximum", it.longValue()));
    }

    private static void processStringAnnotations(Hson.Struct.Builder builder, Annotated annotated, AtomicBoolean required) {
        builder.set("type", "string");
        SchemaInfo.processCommonAnnotations(builder, annotated, required);
        annotated.findAnnotation(Types.JSON_SCHEMA_STRING_MIN_LENGTH).flatMap(it -> it.longValue()).ifPresent(it -> builder.set("minLength", it.longValue()));
        annotated.findAnnotation(Types.JSON_SCHEMA_STRING_MAX_LENGTH).flatMap(it -> it.longValue()).ifPresent(it -> builder.set("maxLength", it.longValue()));
        annotated.findAnnotation(Types.JSON_SCHEMA_STRING_PATTERN).flatMap(it -> it.stringValue()).ifPresent(it -> builder.set("pattern", it));
    }

    private static void processObject(Hson.Struct.Builder builder, TypeInfo annotatedType, CodegenContext ctx, AtomicBoolean required) {
        builder.set("type", "object");
        SchemaInfo.processObjectAnnotations(builder, (Annotated)annotatedType, required);
        Map<String, List<SchemaObjectProperty>> objectProperties = SchemaInfo.obtainObjectProperties(annotatedType);
        ArrayList requiredProperties = new ArrayList();
        Hson.Struct.Builder newBuilder = Hson.structBuilder();
        objectProperties.forEach((name, properties) -> {
            AtomicBoolean requiredProperty = new AtomicBoolean();
            SchemaInfo.processObjectElement(newBuilder, ctx, properties, name, requiredProperty);
            if (requiredProperty.get()) {
                requiredProperties.add(name);
            }
        });
        if (!objectProperties.isEmpty()) {
            builder.set("properties", (Hson.Value)newBuilder.build());
        }
        if (!requiredProperties.isEmpty()) {
            builder.setStrings("required", List.copyOf(requiredProperties));
        }
    }

    private static Map<String, List<SchemaObjectProperty>> obtainObjectProperties(TypeInfo annotatedType) {
        HashMap<String, List<SchemaObjectProperty>> properties = new HashMap<String, List<SchemaObjectProperty>>();
        List<TypedElementInfo> methods = annotatedType.elementInfo().stream().filter(ElementInfoPredicates::isMethod).filter(Predicate.not(ElementInfoPredicates::isPrivate)).filter(Predicate.not(ElementInfoPredicates::isStatic)).filter(it -> it.parameterArguments().size() == 1).filter(it -> it.elementName().length() > 3).toList();
        for (TypedElementInfo method : methods) {
            String methodName;
            if (method.hasAnnotation(Types.JSON_SCHEMA_IGNORE) || method.hasAnnotation(Types.JSONB_TRANSIENT) || !(methodName = method.elementName()).startsWith("set") || !Character.isUpperCase(methodName.charAt(3))) continue;
            String name = method.findAnnotation(Types.JSON_SCHEMA_PROPERTY_NAME).or(() -> method.findAnnotation(Types.JSONB_PROPERTY)).flatMap(it -> it.stringValue()).orElseGet(() -> {
                if (methodName.length() > 4) {
                    return Character.toLowerCase(methodName.charAt(3)) + methodName.substring(4);
                }
                return String.valueOf(Character.toLowerCase(methodName.charAt(3)));
            });
            TypedElementInfo parameter = (TypedElementInfo)method.parameterArguments().getFirst();
            properties.computeIfAbsent(name, key -> new ArrayList()).add(new SchemaObjectProperty((Annotated)method, parameter.typeName()));
        }
        Optional<TypedElementInfo> maybeCreator = annotatedType.elementInfo().stream().filter(ElementInfoPredicates::isMethod).filter(Predicate.not(ElementInfoPredicates::isPrivate)).filter(ElementInfoPredicates::isStatic).filter(it -> it.hasAnnotation(Types.JSONB_CREATOR)).findFirst();
        Set creatorParamNames = maybeCreator.map(creator -> {
            LinkedHashSet<String> creatorParams = new LinkedHashSet<String>();
            List parameterArguments = creator.parameterArguments();
            for (TypedElementInfo parameter : parameterArguments) {
                String name = parameter.findAnnotation(Types.JSON_SCHEMA_PROPERTY_NAME).or(() -> parameter.findAnnotation(Types.JSONB_PROPERTY)).flatMap(it -> it.stringValue()).orElse(parameter.elementName());
                creatorParams.add(name);
                if (properties.containsKey(name)) continue;
                properties.computeIfAbsent(name, key -> new ArrayList()).add(new SchemaObjectProperty((Annotated)parameter, parameter.typeName()));
            }
            return creatorParams;
        }).orElse(Set.of());
        List<TypedElementInfo> fields = annotatedType.elementInfo().stream().filter(ElementInfoPredicates::isField).filter(Predicate.not(ElementInfoPredicates::isStatic)).toList();
        for (TypedElementInfo field : fields) {
            String name = field.findAnnotation(Types.JSON_SCHEMA_PROPERTY_NAME).or(() -> field.findAnnotation(Types.JSONB_PROPERTY)).flatMap(it -> it.stringValue()).orElse(field.elementName());
            if (field.hasAnnotation(Types.JSON_SCHEMA_IGNORE) || field.hasAnnotation(Types.JSONB_TRANSIENT)) {
                if (creatorParamNames.contains(name)) {
                    throw new CodegenException("Ignored set on the field '" + name + "', but it is required as a creator parameter.", (Object)field);
                }
                properties.remove(name);
                continue;
            }
            if (properties.containsKey(name)) {
                ((List)properties.get(name)).addFirst(new SchemaObjectProperty((Annotated)field, field.typeName()));
                continue;
            }
            if (annotatedType.kind() == ElementKind.RECORD && maybeCreator.isEmpty()) {
                properties.computeIfAbsent(name, key -> new ArrayList()).addFirst(new SchemaObjectProperty((Annotated)field, field.typeName()));
                continue;
            }
            if (field.accessModifier() == AccessModifier.PRIVATE) continue;
            properties.computeIfAbsent(name, key -> new ArrayList()).addFirst(new SchemaObjectProperty((Annotated)field, field.typeName()));
        }
        return properties;
    }

    private static void processObjectElement(Hson.Struct.Builder builder, CodegenContext ctx, List<SchemaObjectProperty> properties, String name, AtomicBoolean required) {
        SchemaObjectProperty last = properties.getLast();
        TypeName lastElementTypeName = last.typeName();
        TypeName parameterTypeName = BOXED_TO_PRIMITIVE.getOrDefault(lastElementTypeName, lastElementTypeName);
        Hson.Struct.Builder newStructBuilder = Hson.structBuilder();
        if (INTEGERS.contains(parameterTypeName)) {
            properties.forEach(it -> SchemaInfo.processIntegerAnnotations(newStructBuilder, it.annotated(), required));
        } else if (NUMBERS.contains(parameterTypeName)) {
            properties.forEach(it -> SchemaInfo.processNumberAnnotations(newStructBuilder, it.annotated(), required));
        } else if (parameterTypeName.primitive()) {
            if (parameterTypeName.equals((Object)TypeNames.PRIMITIVE_BOOLEAN)) {
                properties.forEach(it -> SchemaInfo.processCommonAnnotations(newStructBuilder, it.annotated(), required));
            } else {
                properties.forEach(it -> SchemaInfo.processStringAnnotations(newStructBuilder, it.annotated(), required));
            }
        } else if (parameterTypeName.equals((Object)TypeNames.STRING)) {
            properties.forEach(it -> SchemaInfo.processStringAnnotations(newStructBuilder, it.annotated(), required));
        } else if (parameterTypeName.array() || parameterTypeName.isList() || parameterTypeName.isSet()) {
            properties.forEach(it -> SchemaInfo.processArray(newStructBuilder, ctx, it.annotated(), parameterTypeName, required));
        } else {
            boolean doNotInspect = properties.stream().anyMatch(it -> it.annotated().hasAnnotation(Types.JSON_SCHEMA_DO_NOT_INSPECT));
            if (parameterTypeName.packageName().startsWith("java.") || parameterTypeName.packageName().startsWith("javax.") || doNotInspect) {
                properties.forEach(it -> SchemaInfo.processObjectAnnotations(newStructBuilder, it.annotated(), required));
            } else {
                TypeInfo typeInfo = (TypeInfo)ctx.typeInfo(parameterTypeName).orElseThrow(() -> new CodegenException("Could not process required type: " + String.valueOf(parameterTypeName), (Object)last.annotated()));
                SchemaInfo.processObject(newStructBuilder, typeInfo, ctx, required);
                properties.forEach(it -> SchemaInfo.processObjectAnnotations(newStructBuilder, it.annotated(), required));
            }
        }
        builder.set(name, (Hson.Value)newStructBuilder.build());
    }

    private static void processNumberAnnotations(Hson.Struct.Builder numberBuilder, Annotated annotatedType, AtomicBoolean required) {
        numberBuilder.set("type", "number");
        SchemaInfo.processCommonAnnotations(numberBuilder, annotatedType, required);
        annotatedType.findAnnotation(Types.JSON_SCHEMA_NUMBER_MINIMUM).flatMap(it -> it.doubleValue()).ifPresent(it -> numberBuilder.set("minimum", it.doubleValue()));
        annotatedType.findAnnotation(Types.JSON_SCHEMA_NUMBER_MAXIMUM).flatMap(it -> it.doubleValue()).ifPresent(it -> numberBuilder.set("maximum", it.doubleValue()));
        annotatedType.findAnnotation(Types.JSON_SCHEMA_NUMBER_MULTIPLE_OF).flatMap(it -> it.doubleValue()).ifPresent(it -> numberBuilder.set("multipleOf", it.doubleValue()));
        annotatedType.findAnnotation(Types.JSON_SCHEMA_NUMBER_EXCLUSIVE_MINIMUM).flatMap(it -> it.doubleValue()).ifPresent(it -> numberBuilder.set("exclusiveMinimum", it.doubleValue()));
        annotatedType.findAnnotation(Types.JSON_SCHEMA_NUMBER_EXCLUSIVE_MAXIMUM).flatMap(it -> it.doubleValue()).ifPresent(it -> numberBuilder.set("exclusiveMaximum", it.doubleValue()));
    }

    private static void processObjectAnnotations(Hson.Struct.Builder builder, Annotated annotated, AtomicBoolean required) {
        SchemaInfo.processCommonAnnotations(builder, annotated, required);
        annotated.findAnnotation(Types.JSON_SCHEMA_OBJECT_MIN_PROPERTIES).flatMap(it -> it.intValue()).ifPresent(it -> builder.set("minProperties", it.intValue()));
        annotated.findAnnotation(Types.JSON_SCHEMA_OBJECT_MAX_PROPERTIES).flatMap(it -> it.intValue()).ifPresent(it -> builder.set("maxProperties", it.intValue()));
        annotated.findAnnotation(Types.JSON_SCHEMA_OBJECT_ADDITIONAL_PROPERTIES).flatMap(it -> it.booleanValue()).ifPresent(it -> builder.set("additionalProperties", it.booleanValue()));
    }

    private static void processArray(Hson.Struct.Builder builder, CodegenContext ctx, Annotated element, TypeName elementTypeName, AtomicBoolean required) {
        builder.set("type", "array");
        SchemaInfo.processArrayAnnotations(builder, element, required);
        TypeName typeName = elementTypeName;
        if (typeName.array()) {
            typeName = typeName.componentType().orElse(TypeNames.OBJECT);
        } else if (typeName.isList() || typeName.isSet()) {
            typeName = (TypeName)typeName.typeArguments().getFirst();
        }
        Hson.Struct.Builder itemsBuilder = Hson.structBuilder();
        TypeName finalTypeName = BOXED_TO_PRIMITIVE.getOrDefault(typeName, typeName);
        if (INTEGERS.contains(finalTypeName)) {
            SchemaInfo.processIntegerAnnotations(itemsBuilder, element, required);
        } else if (NUMBERS.contains(finalTypeName)) {
            SchemaInfo.processNumberAnnotations(itemsBuilder, element, required);
        } else if (finalTypeName.primitive()) {
            if (finalTypeName.equals((Object)TypeNames.PRIMITIVE_BOOLEAN)) {
                SchemaInfo.processCommonAnnotations(itemsBuilder, element, required);
            } else {
                SchemaInfo.processStringAnnotations(itemsBuilder, element, required);
            }
        } else if (finalTypeName.equals((Object)TypeNames.STRING)) {
            SchemaInfo.processStringAnnotations(itemsBuilder, element, required);
        } else if (finalTypeName.array() || finalTypeName.isList() || finalTypeName.isSet()) {
            SchemaInfo.processArray(itemsBuilder, ctx, element, finalTypeName, required);
        } else {
            if (finalTypeName.packageName().startsWith("java") || element.hasAnnotation(Types.JSON_SCHEMA_DO_NOT_INSPECT)) {
                SchemaInfo.processObjectAnnotations(itemsBuilder, element, required);
                return;
            }
            TypeInfo typeInfo = (TypeInfo)ctx.typeInfo(finalTypeName).orElseThrow(() -> new CodegenException("Could not process required type: " + String.valueOf(finalTypeName), (Object)element));
            SchemaInfo.processObject(itemsBuilder, typeInfo, ctx, required);
            SchemaInfo.processObjectAnnotations(itemsBuilder, element, required);
        }
    }

    private static void processArrayAnnotations(Hson.Struct.Builder arrayBuilder, Annotated annotated, AtomicBoolean required) {
        SchemaInfo.processCommonAnnotations(arrayBuilder, annotated, required);
        annotated.findAnnotation(Types.JSON_SCHEMA_ARRAY_MIN_ITEMS).flatMap(it -> it.intValue()).ifPresent(it -> arrayBuilder.set("minItems", it.intValue()));
        annotated.findAnnotation(Types.JSON_SCHEMA_ARRAY_MAX_ITEMS).flatMap(it -> it.intValue()).ifPresent(it -> arrayBuilder.set("maxItems", it.intValue()));
        annotated.findAnnotation(Types.JSON_SCHEMA_ARRAY_UNIQUE_ITEMS).flatMap(it -> it.booleanValue()).ifPresent(it -> arrayBuilder.set("uniqueItems", it.booleanValue()));
    }
}

