/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.integrations.vault.sys;

import io.helidon.integrations.common.rest.ApiRequest;
import io.helidon.integrations.common.rest.ApiResponse;
import io.helidon.integrations.common.rest.RestApi;
import io.helidon.integrations.vault.sys.CreatePolicy;
import io.helidon.integrations.vault.sys.DeletePolicy;
import io.helidon.integrations.vault.sys.DisableAuth;
import io.helidon.integrations.vault.sys.DisableEngine;
import io.helidon.integrations.vault.sys.EnableAuth;
import io.helidon.integrations.vault.sys.EnableEngine;
import io.helidon.integrations.vault.sys.Sys;

class SysImpl
implements Sys {
    private final RestApi restApi;

    SysImpl(RestApi restApi) {
        this.restApi = restApi;
    }

    @Override
    public EnableEngine.Response enableEngine(EnableEngine.Request request) {
        String apiPath = "/sys/mounts/" + request.path();
        return (EnableEngine.Response)this.restApi.post(apiPath, (ApiRequest)request, (ApiResponse.Builder)EnableEngine.Response.builder());
    }

    @Override
    public DisableEngine.Response disableEngine(DisableEngine.Request request) {
        String apiPath = "/sys/mounts/" + request.path();
        return (DisableEngine.Response)this.restApi.delete(apiPath, (ApiRequest)request, (ApiResponse.Builder)DisableEngine.Response.builder());
    }

    @Override
    public EnableAuth.Response enableAuth(EnableAuth.Request request) {
        String apiPath = "/sys/auth/" + request.path();
        return (EnableAuth.Response)this.restApi.post(apiPath, (ApiRequest)request, (ApiResponse.Builder)EnableAuth.Response.builder());
    }

    @Override
    public DisableAuth.Response disableAuth(DisableAuth.Request request) {
        String apiPath = "/sys/auth/" + request.path();
        return (DisableAuth.Response)this.restApi.delete(apiPath, (ApiRequest)request, (ApiResponse.Builder)DisableAuth.Response.builder());
    }

    @Override
    public CreatePolicy.Response createPolicy(CreatePolicy.Request request) {
        String apiPath = "/sys/policy/" + request.name();
        return (CreatePolicy.Response)this.restApi.put(apiPath, (ApiRequest)request, (ApiResponse.Builder)CreatePolicy.Response.builder());
    }

    @Override
    public DeletePolicy.Response deletePolicy(DeletePolicy.Request request) {
        String apiPath = "/sys/policy/" + request.name();
        return (DeletePolicy.Response)this.restApi.delete(apiPath, (ApiRequest)request, (ApiResponse.Builder)DeletePolicy.Response.builder());
    }
}

