/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.integrations.vault.secrets.database;

import io.helidon.integrations.common.rest.ApiRequest;
import io.helidon.integrations.common.rest.ApiResponse;
import io.helidon.integrations.common.rest.RestApi;
import io.helidon.integrations.vault.ListSecrets;
import io.helidon.integrations.vault.Vault;
import io.helidon.integrations.vault.VaultOptionalResponse;
import io.helidon.integrations.vault.secrets.database.DbConfigure;
import io.helidon.integrations.vault.secrets.database.DbCreateRole;
import io.helidon.integrations.vault.secrets.database.DbDelete;
import io.helidon.integrations.vault.secrets.database.DbDeleteRole;
import io.helidon.integrations.vault.secrets.database.DbGet;
import io.helidon.integrations.vault.secrets.database.DbSecrets;

class DbSecretsImpl
implements DbSecrets {
    private final RestApi restApi;
    private final String mount;

    DbSecretsImpl(RestApi restApi, String mount) {
        this.restApi = restApi;
        this.mount = mount;
    }

    @Override
    public VaultOptionalResponse<ListSecrets.Response> list(ListSecrets.Request request) {
        String apiPath = this.mount + "/config";
        return (VaultOptionalResponse)this.restApi.invokeOptional(Vault.LIST, apiPath, (ApiRequest)request, VaultOptionalResponse.vaultResponseBuilder().entityProcessor(ListSecrets.Response::create));
    }

    @Override
    public VaultOptionalResponse<DbGet.Response> get(DbGet.Request request) {
        String name = request.name();
        String apiPath = this.mount + "/creds/" + name;
        return (VaultOptionalResponse)this.restApi.get(apiPath, (ApiRequest)request, VaultOptionalResponse.vaultResponseBuilder().entityProcessor(json -> DbGet.Response.create(name, json)));
    }

    @Override
    public DbCreateRole.Response createRole(DbCreateRole.Request request) {
        String apiPath = this.mount + "/roles/" + request.name();
        return (DbCreateRole.Response)this.restApi.post(apiPath, (ApiRequest)request, (ApiResponse.Builder)DbCreateRole.Response.builder());
    }

    @Override
    public DbConfigure.Response configure(DbConfigure.Request<?> dbRequest) {
        String apiPath = this.mount + "/config/" + dbRequest.name();
        return (DbConfigure.Response)this.restApi.post(apiPath, dbRequest, (ApiResponse.Builder)DbConfigure.Response.builder());
    }

    @Override
    public DbDelete.Response delete(DbDelete.Request request) {
        String apiPath = this.mount + "/config/" + request.name();
        return (DbDelete.Response)this.restApi.delete(apiPath, (ApiRequest)request, (ApiResponse.Builder)DbDelete.Response.builder());
    }

    @Override
    public DbDeleteRole.Response deleteRole(DbDeleteRole.Request request) {
        String apiPath = this.mount + "/roles/" + request.name();
        return (DbDeleteRole.Response)this.restApi.delete(apiPath, (ApiRequest)request, (ApiResponse.Builder)DbDeleteRole.Response.builder());
    }
}

