/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.integrations.vault.secrets.database;

import io.helidon.common.reactive.Single;
import io.helidon.integrations.common.rest.ApiRequest;
import io.helidon.integrations.common.rest.ApiResponse;
import io.helidon.integrations.common.rest.RestApi;
import io.helidon.integrations.vault.ListSecrets;
import io.helidon.integrations.vault.Vault;
import io.helidon.integrations.vault.VaultOptionalResponse;
import io.helidon.integrations.vault.secrets.database.DbConfigure;
import io.helidon.integrations.vault.secrets.database.DbCreateRole;
import io.helidon.integrations.vault.secrets.database.DbDelete;
import io.helidon.integrations.vault.secrets.database.DbDeleteRole;
import io.helidon.integrations.vault.secrets.database.DbGet;
import io.helidon.integrations.vault.secrets.database.DbSecretsRx;

class DbSecretsRxImpl
implements DbSecretsRx {
    private final RestApi restApi;
    private final String mount;

    DbSecretsRxImpl(RestApi restApi, String mount) {
        this.restApi = restApi;
        this.mount = mount;
    }

    @Override
    public Single<VaultOptionalResponse<ListSecrets.Response>> list(ListSecrets.Request request) {
        String apiPath = this.mount + "/config";
        return this.restApi.invokeOptional(Vault.LIST, apiPath, (ApiRequest)request, VaultOptionalResponse.vaultResponseBuilder().entityProcessor(ListSecrets.Response::create));
    }

    @Override
    public Single<VaultOptionalResponse<DbGet.Response>> get(DbGet.Request request) {
        String name = request.name();
        String apiPath = this.mount + "/creds/" + name;
        return this.restApi.get(apiPath, (ApiRequest)request, VaultOptionalResponse.vaultResponseBuilder().entityProcessor(json -> DbGet.Response.create(name, json)));
    }

    @Override
    public Single<DbCreateRole.Response> createRole(DbCreateRole.Request request) {
        String apiPath = this.mount + "/roles/" + request.name();
        return this.restApi.post(apiPath, (ApiRequest)request, (ApiResponse.Builder)DbCreateRole.Response.builder());
    }

    @Override
    public Single<DbConfigure.Response> configure(DbConfigure.Request<?> dbRequest) {
        String apiPath = this.mount + "/config/" + dbRequest.name();
        return this.restApi.post(apiPath, dbRequest, (ApiResponse.Builder)DbConfigure.Response.builder());
    }

    @Override
    public Single<DbDelete.Response> delete(DbDelete.Request request) {
        String apiPath = this.mount + "/config/" + request.name();
        return this.restApi.delete(apiPath, (ApiRequest)request, (ApiResponse.Builder)DbDelete.Response.builder());
    }

    @Override
    public Single<DbDeleteRole.Response> deleteRole(DbDeleteRole.Request request) {
        String apiPath = this.mount + "/roles/" + request.name();
        return this.restApi.delete(apiPath, (ApiRequest)request, (ApiResponse.Builder)DbDeleteRole.Response.builder());
    }
}

