/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.integrations.vault.secrets.cubbyhole;

import io.helidon.integrations.common.rest.ApiJsonParser;
import io.helidon.integrations.vault.Secret;
import io.helidon.integrations.vault.VaultApiException;
import io.helidon.integrations.vault.VaultRequest;
import jakarta.json.JsonObject;
import java.util.Map;
import java.util.Optional;

public final class GetCubbyhole {
    private GetCubbyhole() {
    }

    public static class Response
    extends ApiJsonParser
    implements Secret {
        private final String path;
        private final Map<String, String> values;

        private Response(String path, JsonObject json) {
            this.path = path;
            this.values = Response.toMap((JsonObject)json, (String)"data");
        }

        static Response create(String path, JsonObject json) {
            return new Response(path, json);
        }

        public String path() {
            return this.path;
        }

        public Optional<String> value(String key) {
            return Optional.ofNullable(this.values.get(key));
        }

        public Map<String, String> values() {
            return this.values;
        }
    }

    public static class Request
    extends VaultRequest<Request> {
        private String path;

        private Request() {
        }

        public static Request builder() {
            return new Request();
        }

        public Request path(String path) {
            this.path = path;
            return this;
        }

        String path() {
            if (this.path == null) {
                throw new VaultApiException("GetCubbyhole.Request path must be configured");
            }
            return this.path;
        }
    }
}

