/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.integrations.vault.secrets.cubbyhole;

import io.helidon.common.Builder;
import io.helidon.common.config.Config;
import io.helidon.integrations.vault.Vault;
import io.helidon.integrations.vault.secrets.cubbyhole.CubbyholeSecrets;
import io.helidon.integrations.vault.secrets.cubbyhole.GetCubbyhole;
import io.helidon.security.spi.ProviderConfig;
import io.helidon.security.spi.SecretsProvider;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;

public class CubbyholeSecurityProvider
implements SecretsProvider<CubbyholeSecretConfig> {
    private final CubbyholeSecrets secrets;

    CubbyholeSecurityProvider(Vault vault) {
        this.secrets = (CubbyholeSecrets)vault.secrets(CubbyholeSecrets.ENGINE);
    }

    public Supplier<Optional<String>> secret(Config config) {
        return this.secret(CubbyholeSecretConfig.create(config));
    }

    public Supplier<Optional<String>> secret(CubbyholeSecretConfig providerConfig) {
        String key = providerConfig.key;
        return () -> this.secrets.get(providerConfig.request()).entity().flatMap(response -> response.value(key));
    }

    public static class CubbyholeSecretConfig
    implements ProviderConfig {
        private final String path;
        private final String key;

        private CubbyholeSecretConfig(Builder builder) {
            this.path = builder.path;
            this.key = builder.key;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static CubbyholeSecretConfig create(Config config) {
            return CubbyholeSecretConfig.builder().config(config).build();
        }

        private GetCubbyhole.Request request() {
            return GetCubbyhole.Request.builder().path(this.path);
        }

        public static class Builder
        implements io.helidon.common.Builder<Builder, CubbyholeSecretConfig> {
            private String path;
            private String key;

            private Builder() {
            }

            public CubbyholeSecretConfig build() {
                Objects.requireNonNull(this.path, "Secret path must be defined. Config property \"path\"");
                Objects.requireNonNull(this.key, "Secret value key must be defined. Config property \"key\"");
                return new CubbyholeSecretConfig(this);
            }

            public Builder config(Config config) {
                config.get("path").asString().ifPresent(this::path);
                config.get("key").asString().ifPresent(this::key);
                return this;
            }

            public Builder path(String path) {
                this.path = path;
                return this;
            }

            public Builder key(String key) {
                this.key = key;
                return this;
            }
        }
    }
}

