/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.integrations.vault.secrets.cubbyhole;

import io.helidon.integrations.common.rest.ApiRequest;
import io.helidon.integrations.common.rest.ApiResponse;
import io.helidon.integrations.common.rest.RestApi;
import io.helidon.integrations.vault.ListSecrets;
import io.helidon.integrations.vault.Secret;
import io.helidon.integrations.vault.Vault;
import io.helidon.integrations.vault.VaultApiException;
import io.helidon.integrations.vault.VaultOptionalResponse;
import io.helidon.integrations.vault.VaultRestException;
import io.helidon.integrations.vault.secrets.cubbyhole.CreateCubbyhole;
import io.helidon.integrations.vault.secrets.cubbyhole.CubbyholeSecrets;
import io.helidon.integrations.vault.secrets.cubbyhole.DeleteCubbyhole;
import io.helidon.integrations.vault.secrets.cubbyhole.GetCubbyhole;
import io.helidon.integrations.vault.secrets.cubbyhole.UpdateCubbyhole;
import java.util.Optional;

class CubbyholeSecretsImpl
implements CubbyholeSecrets {
    private final RestApi restApi;
    private final String mount;

    CubbyholeSecretsImpl(RestApi restApi, String mount) {
        this.restApi = restApi;
        this.mount = mount;
    }

    @Override
    public VaultOptionalResponse<GetCubbyhole.Response> get(GetCubbyhole.Request request) {
        String path = request.path();
        String apiPath = this.mount + "/" + path;
        return (VaultOptionalResponse)this.restApi.get(apiPath, (ApiRequest)request, VaultOptionalResponse.vaultResponseBuilder().entityProcessor(json -> GetCubbyhole.Response.create(path, json)));
    }

    public VaultOptionalResponse<ListSecrets.Response> list(ListSecrets.Request request) {
        String apiPath = this.mount + "/" + request.path().orElse("");
        return (VaultOptionalResponse)this.restApi.invokeOptional(Vault.LIST, apiPath, (ApiRequest)request, VaultOptionalResponse.vaultResponseBuilder().entityProcessor(ListSecrets.Response::create));
    }

    @Override
    public CreateCubbyhole.Response create(CreateCubbyhole.Request request) throws VaultRestException {
        String path = request.path();
        Optional<Secret> secret = this.get(path);
        if (secret.isPresent()) {
            throw new VaultApiException("Cannot create a secret that already exists on path: \"%s\", please use update", new Object[]{path});
        }
        String apiPath = this.mount + "/" + path;
        return (CreateCubbyhole.Response)this.restApi.post(apiPath, (ApiRequest)request, (ApiResponse.Builder)CreateCubbyhole.Response.builder());
    }

    @Override
    public UpdateCubbyhole.Response update(UpdateCubbyhole.Request request) {
        String path = request.path();
        Optional<Secret> secret = this.get(path);
        if (secret.isEmpty()) {
            throw new VaultApiException("Cannot update a secret that does not exist on path: \"%s\", please use create", new Object[]{path});
        }
        String apiPath = this.mount + "/" + path;
        return (UpdateCubbyhole.Response)this.restApi.put(apiPath, (ApiRequest)request, (ApiResponse.Builder)UpdateCubbyhole.Response.builder());
    }

    @Override
    public DeleteCubbyhole.Response delete(DeleteCubbyhole.Request request) {
        String apiPath = this.mount + "/" + request.path();
        return (DeleteCubbyhole.Response)this.restApi.delete(apiPath, (ApiRequest)request, (ApiResponse.Builder)DeleteCubbyhole.Response.builder());
    }
}

