/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.integrations.openapi.ui;

import io.helidon.common.http.Http;
import io.helidon.common.http.MediaType;
import io.helidon.openapi.OpenApiUiBase;
import io.helidon.webserver.Handler;
import io.helidon.webserver.Routing;
import io.helidon.webserver.ServerRequest;
import io.helidon.webserver.ServerResponse;
import io.helidon.webserver.Service;
import io.helidon.webserver.staticcontent.StaticContentSupport;
import io.smallrye.openapi.ui.IndexHtmlCreator;
import io.smallrye.openapi.ui.Option;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

class OpenApiUiFull
extends OpenApiUiBase {
    private static final String LOGO_RESOURCE = "logo.svg";
    private static final String HELIDON_IO_LINK = "https://helidon.io";
    private static final Logger LOGGER = Logger.getLogger(OpenApiUiFull.class.getName());
    private static final MediaType[] SUPPORTED_TEXT_MEDIA_TYPES_AT_UI_ENDPOINT = new MediaType[]{MediaType.TEXT_HTML, MediaType.TEXT_PLAIN, MediaType.TEXT_YAML};
    private static final MediaType[] SUPPORTED_TEXT_MEDIA_TYPES_AT_OPENAPI_ENDPOINT = new MediaType[]{MediaType.TEXT_HTML, MediaType.TEXT_PLAIN};
    private final byte[] indexHtml;

    static Builder builder() {
        return new Builder();
    }

    private OpenApiUiFull(Builder builder) {
        super((OpenApiUiBase.Builder)builder, builder.documentPreparer(), builder.openApiSupportWebContext());
        Map<Option, String> options = builder.uiOptions();
        Map.of(Option.title, "Helidon OpenAPI UI", Option.logoHref, LOGO_RESOURCE, Option.oauth2RedirectUrl, "-", Option.backHref, HELIDON_IO_LINK, Option.selfHref, HELIDON_IO_LINK, Option.url, builder.openApiSupportWebContext()).forEach((key, value) -> {
            if (!options.containsKey(key)) {
                options.put((Option)key, (String)value);
            }
        });
        try {
            this.indexHtml = IndexHtmlCreator.createIndexHtml(options);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to initialize the index.html content for the OpenAPI UI", e);
        }
    }

    public MediaType[] supportedMediaTypes() {
        return SUPPORTED_TEXT_MEDIA_TYPES_AT_OPENAPI_ENDPOINT;
    }

    public boolean prepareTextResponseFromMainEndpoint(ServerRequest request, ServerResponse response) {
        return request.headers().bestAccepted(SUPPORTED_TEXT_MEDIA_TYPES_AT_OPENAPI_ENDPOINT).map(mediaType -> {
            if (!this.isEnabled()) {
                request.next();
                return true;
            }
            return this.prepareTextResponse(request, response, (MediaType)mediaType);
        }).orElse(false);
    }

    public void update(Routing.Rules rules) {
        if (!this.isEnabled()) {
            return;
        }
        StaticContentSupport smallryeUiStaticSupport = StaticContentSupport.builder((String)"META-INF/resources/openapi-ui").build();
        StaticContentSupport helidonOpenApiUiStaticSupport = StaticContentSupport.builder((String)"helidon-openapi-ui").build();
        rules.get(this.webContext() + "[/]", new Handler[]{this::prepareTextResponseFromUiEndpoint}).get(this.webContext() + "/index.html", new Handler[]{this::displayIndex}).register(this.webContext(), new Service[]{helidonOpenApiUiStaticSupport}).register(this.webContext(), new Service[]{smallryeUiStaticSupport});
    }

    private void displayIndex(ServerRequest request, ServerResponse response) {
        if (!this.acceptsHtml(request)) {
            request.next();
            return;
        }
        response.addHeader("Content-Type", new String[]{MediaType.TEXT_HTML.toString()}).send((Object)this.indexHtml);
    }

    private void prepareTextResponseFromUiEndpoint(ServerRequest request, ServerResponse response) {
        request.headers().bestAccepted(SUPPORTED_TEXT_MEDIA_TYPES_AT_UI_ENDPOINT).ifPresentOrElse(mediaType -> this.prepareTextResponse(request, response, (MediaType)mediaType), () -> ((ServerRequest)request).next());
    }

    private boolean prepareTextResponse(ServerRequest request, ServerResponse response, MediaType mediaType) {
        if (MediaType.TEXT_HTML.test(mediaType)) {
            this.redirectToIndex(request, response);
        } else {
            this.sendStaticText(request, response, mediaType);
        }
        return true;
    }

    private void redirectToIndex(ServerRequest request, ServerResponse response) {
        response.status((Http.ResponseStatus)Http.Status.TEMPORARY_REDIRECT_307);
        response.addHeader("Location", new String[]{this.webContext() + "/index.html"});
        response.send();
    }

    private boolean acceptsHtml(ServerRequest request) {
        return request.headers().bestAccepted(SUPPORTED_TEXT_MEDIA_TYPES_AT_UI_ENDPOINT).map(candidate -> candidate.test(MediaType.TEXT_HTML)).orElse(false);
    }

    public static class Builder
    extends OpenApiUiBase.Builder<Builder, OpenApiUiFull> {
        private Builder() {
        }

        public OpenApiUiFull build() {
            return new OpenApiUiFull(this);
        }

        Map<Option, String> uiOptions() {
            if (this.options().containsKey(Option.url.name())) {
                LOGGER.log(Level.WARNING, "Unexpected setting for the OpenAPI URL; overriding the options value of 'url' ({1}) with the actual endpoint of the Helidon OpenAPI service ({0})\n", new Object[]{this.openApiSupportWebContext() + "/ui", this.options().get(Option.url.name())});
            }
            HashMap<Option, String> result = new HashMap<Option, String>();
            ArrayList<String> unrecognizedKeys = new ArrayList<String>();
            for (Map.Entry entry : this.options().entrySet()) {
                boolean matched = false;
                for (Option opt : Option.values()) {
                    if (!opt.name().equals(entry.getKey())) continue;
                    result.put(opt, (String)entry.getValue());
                    matched = true;
                    break;
                }
                if (matched) continue;
                unrecognizedKeys.add((String)entry.getKey());
            }
            if (!unrecognizedKeys.isEmpty()) {
                LOGGER.log(Level.WARNING, "Helidon OpenAPI UI builder found (and will ignore) unrecognized option names: \"{0}\"", unrecognizedKeys);
            }
            return result;
        }
    }
}

