/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.integrations.langchain4j.codegen;

import io.helidon.codegen.CodegenContext;
import io.helidon.codegen.CodegenException;
import io.helidon.codegen.CodegenUtil;
import io.helidon.codegen.RoundContext;
import io.helidon.codegen.classmodel.ClassModel;
import io.helidon.codegen.classmodel.Constructor;
import io.helidon.codegen.classmodel.Field;
import io.helidon.codegen.classmodel.Method;
import io.helidon.codegen.classmodel.Parameter;
import io.helidon.codegen.spi.CodegenExtension;
import io.helidon.common.types.AccessModifier;
import io.helidon.common.types.Annotation;
import io.helidon.common.types.Annotations;
import io.helidon.common.types.ElementKind;
import io.helidon.common.types.TypeInfo;
import io.helidon.common.types.TypeName;
import io.helidon.common.types.TypeNames;
import io.helidon.integrations.langchain4j.codegen.LangchainTypes;
import io.helidon.service.codegen.ServiceCodegenTypes;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;

class AiServiceCodegen
implements CodegenExtension {
    private static final TypeName GENERATOR = TypeName.create(AiServiceCodegen.class);
    private final CodegenContext ctx;

    AiServiceCodegen(CodegenContext ctx) {
        this.ctx = ctx;
    }

    public void process(RoundContext roundCtx) {
        Collection types = roundCtx.annotatedTypes(LangchainTypes.AI_SERVICE);
        for (TypeInfo type : types) {
            this.process(roundCtx, type);
        }
    }

    private void process(RoundContext roundCtx, TypeInfo type) {
        if (type.kind() != ElementKind.INTERFACE) {
            throw new CodegenException("Type annotated with " + LangchainTypes.AI_SERVICE.fqName() + " must be an interface.", type.originatingElementValue());
        }
        this.generateInterfaceSupplier(roundCtx, type);
    }

    private void aiServicesToolParameters(Constructor.Builder ctr, TypeInfo aiInterface) {
        if (aiInterface.hasAnnotation(LangchainTypes.AI_TOOLS)) {
            Annotation tools2 = aiInterface.annotation(LangchainTypes.AI_TOOLS);
            List toolTypes = tools2.typeValues().orElseGet(List::of);
            ArrayList<CallSite> toolParameters = new ArrayList<CallSite>();
            int index = 1;
            for (TypeName toolType : toolTypes) {
                String toolParameter = "tool_" + index;
                ++index;
                ctr.addParameter(tool -> ((Parameter.Builder)tool.name(toolParameter)).type(toolType).addAnnotation(LangchainTypes.TOOL_QUALIFIER_ANNOTATION));
                toolParameters.add((CallSite)((Object)toolParameter));
            }
            ctr.addContent("builder.tools(");
            ctr.addContent(String.join((CharSequence)", ", toolParameters));
            ctr.addContentLine(");");
        } else {
            ctr.addParameter(tools -> ((Parameter.Builder)tools.name("tools")).type(this.listType(TypeNames.OBJECT)).addAnnotation(LangchainTypes.TOOL_QUALIFIER_ANNOTATION));
            ctr.addContentLine("builder.tools(tools);");
        }
    }

    private void aiServicesParameter(Constructor.Builder ctr, boolean autoDiscovery, TypeInfo aiInterface, TypeName aiModelAnnotation, TypeName lcModelType, String aiServicesMethodName) {
        String modelName = aiInterface.findAnnotation(aiModelAnnotation).flatMap(rec$ -> ((Annotation)rec$).stringValue()).orElse(null);
        if (modelName == null) {
            if (!autoDiscovery) {
                return;
            }
            ctr.addParameter(parameter -> ((Parameter.Builder)parameter.name(aiServicesMethodName)).type(this.optionalType(lcModelType)));
            ((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)ctr.addContent(aiServicesMethodName)).addContent(".ifPresent(builder::")).addContent(aiServicesMethodName)).addContentLine(");");
            return;
        }
        ctr.addParameter(parameter -> ((Parameter.Builder)parameter.name(aiServicesMethodName)).type(lcModelType).addAnnotation(this.namedAnnotation(modelName)));
        ((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)ctr.addContent("builder.")).addContent(aiServicesMethodName)).addContent("(")).addContent(aiServicesMethodName)).addContentLine(");");
    }

    private void aiMcpClientParameter(Constructor.Builder builder, TypeInfo aiInterface, CodegenContext ctx) {
        Optional mcpClientTypeInfo = ctx.typeInfo(LangchainTypes.LC_MCP_CLIENT);
        if (mcpClientTypeInfo.isEmpty()) {
            throw new CodegenException("McpClients annotation is being used, but the required LC4J MCP dependency is missing. Please add: dev.langchain4j:langchain4j-mcp");
        }
        List mcpClients = aiInterface.findAnnotation(LangchainTypes.AI_MCP_CLIENTS).flatMap(rec$ -> ((Annotation)rec$).stringValues()).orElseGet(List::of);
        ArrayList<Object> mcpClientParameters = new ArrayList<Object>();
        if (mcpClients.isEmpty()) {
            builder.addParameter(tools -> ((Parameter.Builder)tools.name("mcpClients")).type(this.listType(LangchainTypes.LC_MCP_CLIENT)));
            mcpClientParameters.add("mcpClients");
        } else {
            int index = 1;
            for (String clientName : mcpClients) {
                String toolParameter = "mcpClient_" + index++;
                builder.addParameter(param -> ((Parameter.Builder)param.name(toolParameter)).type(LangchainTypes.LC_MCP_CLIENT).addAnnotation(this.namedAnnotation(clientName)));
                mcpClientParameters.add(toolParameter);
            }
        }
        ((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)builder.addContent("var mcpToolProvider = ")).addContent(LangchainTypes.LC_MCP_TOOL_PROVIDER)).addContentLine(".builder()")).increaseContentPadding()).addContent(".mcpClients(")).addContent(String.join((CharSequence)", ", mcpClientParameters))).addContentLine(")")).addContentLine(".build();")).decreaseContentPadding();
        builder.addContentLine("builder.toolProvider(mcpToolProvider);");
    }

    private Annotation namedAnnotation(String modelName) {
        return Annotation.create((TypeName)ServiceCodegenTypes.SERVICE_ANNOTATION_NAMED, (String)modelName);
    }

    private void generateInterfaceSupplier(RoundContext roundCtx, TypeInfo aiInterface) {
        TypeName aiInterfaceType = aiInterface.typeName();
        TypeName generatedType = this.generatedTypeName(aiInterfaceType, "AiService");
        ClassModel.Builder classModel = (ClassModel.Builder)((ClassModel.Builder)((ClassModel.Builder)ClassModel.builder().type(generatedType).copyright(CodegenUtil.copyright((TypeName)GENERATOR, (TypeName)aiInterfaceType, (TypeName)generatedType)).addAnnotation(CodegenUtil.generatedAnnotation((TypeName)GENERATOR, (TypeName)aiInterfaceType, (TypeName)generatedType, (String)"1", (String)""))).accessModifier(AccessModifier.PACKAGE_PRIVATE).addInterface(this.supplierType(aiInterfaceType))).addAnnotation(Annotation.create((TypeName)ServiceCodegenTypes.SERVICE_ANNOTATION_SINGLETON));
        TypeName aiServicesType = this.aiServicesType(aiInterfaceType);
        classModel.addField(aiServices -> ((Field.Builder)aiServices.name("aiServices")).type(aiServicesType).isFinal(true).accessModifier(AccessModifier.PRIVATE));
        boolean autoDiscovery = aiInterface.annotation(LangchainTypes.AI_SERVICE).booleanValue("autoDiscovery").orElse(true);
        classModel.addConstructor(ctr -> ((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)ctr.accessModifier(AccessModifier.PACKAGE_PRIVATE)).addAnnotation(Annotation.create((TypeName)ServiceCodegenTypes.SERVICE_ANNOTATION_INJECT))).addContent(aiServicesType)).addContent(" builder = ")).addContent(LangchainTypes.LC_AI_SERVICES)).addContent(".builder(")).addContent(aiInterfaceType)).addContentLine(".class);")).addContentLine("")).update(it -> {
            this.aiServicesChatMemoryConstructor((Constructor.Builder)it, autoDiscovery, aiInterface);
            this.aiServicesParameter((Constructor.Builder)it, autoDiscovery, aiInterface, LangchainTypes.AI_CHAT_MODEL, LangchainTypes.LC_CHAT_MODEL, "chatModel");
            this.aiServicesParameter((Constructor.Builder)it, autoDiscovery, aiInterface, LangchainTypes.AI_STREAMING_CHAT_MODEL, LangchainTypes.LC_STREAMING_CHAT_MODEL, "streamingChatModel");
            this.aiServicesParameter((Constructor.Builder)it, autoDiscovery, aiInterface, LangchainTypes.AI_MODERATION_MODEL, LangchainTypes.LC_MODERATION_MODEL, "moderationModel");
            this.aiServicesParameter((Constructor.Builder)it, autoDiscovery, aiInterface, LangchainTypes.AI_RETRIEVER_AUGMENTOR, LangchainTypes.LC_RETRIEVAL_AUGMENTOR, "retrievalAugmentor");
            this.aiServicesParameter((Constructor.Builder)it, autoDiscovery, aiInterface, LangchainTypes.AI_CONTENT_RETRIEVER, LangchainTypes.LC_CONTENT_RETRIEVER, "contentRetriever");
            this.aiMcpClientAndToolProvider((Constructor.Builder)it, aiInterface, autoDiscovery, this.ctx);
            this.aiServicesToolParameters((Constructor.Builder)it, aiInterface);
        })).addContentLine("")).addContentLine("this.aiServices = builder;"));
        classModel.addMethod(get -> ((Method.Builder)((Method.Builder)((Method.Builder)get.accessModifier(AccessModifier.PUBLIC)).addAnnotation(Annotations.OVERRIDE)).returnType(aiInterfaceType).name("get")).addContentLine("return aiServices.build();"));
        roundCtx.addGeneratedType(generatedType, classModel, aiInterfaceType, new Object[]{aiInterface.originatingElementValue()});
    }

    private void aiMcpClientAndToolProvider(Constructor.Builder it, TypeInfo aiInterface, boolean autoDiscovery, CodegenContext ctx) {
        if (aiInterface.hasAnnotation(LangchainTypes.AI_TOOL_PROVIDER) && aiInterface.hasAnnotation(LangchainTypes.AI_MCP_CLIENTS)) {
            throw new CodegenException("McpClients and ToolProvider annotations cannot be used at the same time.", aiInterface.originatingElementValue());
        }
        if (aiInterface.hasAnnotation(LangchainTypes.AI_MCP_CLIENTS)) {
            this.aiMcpClientParameter(it, aiInterface, ctx);
        } else {
            this.aiServicesParameter(it, autoDiscovery, aiInterface, LangchainTypes.AI_TOOL_PROVIDER, LangchainTypes.LC_TOOL_PROVIDER, "toolProvider");
        }
    }

    private void aiServicesChatMemoryConstructor(Constructor.Builder ctr, boolean autoDiscovery, TypeInfo aiInterface) {
        Optional chatMemoryWindow = aiInterface.findAnnotation(LangchainTypes.AI_CHAT_MEMORY_WINDOW);
        if (chatMemoryWindow.isPresent()) {
            Annotation annotation = (Annotation)chatMemoryWindow.get();
            this.chatMemoryWindow(ctr, annotation);
            return;
        }
        this.aiServicesParameter(ctr, autoDiscovery, aiInterface, LangchainTypes.AI_CHAT_MEMORY, LangchainTypes.LC_CHAT_MEMORY, "chatMemory");
        this.aiServicesParameter(ctr, autoDiscovery, aiInterface, LangchainTypes.AI_CHAT_MEMORY_PROVIDER, LangchainTypes.LC_CHAT_MEMORY_PROVIDER, "chatMemoryProvider");
    }

    private void chatMemoryWindow(Constructor.Builder ctr, Annotation annotation) {
        Optional<String> storeName = annotation.stringValue("store").filter(it -> !it.equals("@default"));
        storeName.ifPresent(storeQualifier -> ctr.addParameter(parameter -> ((Parameter.Builder)parameter.name("chatMemoryStore")).type(LangchainTypes.LC_CHAT_MEMORY_STORE).addAnnotation(this.namedAnnotation((String)storeQualifier))));
        ((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)ctr.addContent("var chatMemory = ")).addContent(LangchainTypes.LC_CHAT_MEMORY_WINDOW)).addContentLine(".builder()")).increaseContentPadding()).increaseContentPadding()).addContent(".maxMessages(")).addContent(String.valueOf(annotation.intValue().orElseThrow()))).addContentLine(")")).addContent(".id(\"")).addContent((String)annotation.stringValue("id").orElseThrow())).addContentLine("\")")).update(it -> {
            if (storeName.isPresent()) {
                it.addContentLine(".chatMemoryStore(chatMemoryStore)");
            }
        })).addContentLine(".build();")).decreaseContentPadding()).decreaseContentPadding()).addContentLine("");
        ctr.addContentLine("builder.chatMemory(chatMemory);");
    }

    private TypeName aiServicesType(TypeName interfaceType) {
        return ((TypeName.Builder)TypeName.builder((TypeName)LangchainTypes.LC_AI_SERVICES).addTypeArgument(interfaceType)).build();
    }

    private TypeName generatedTypeName(TypeName aiInterfaceType, String suffix) {
        return ((TypeName.Builder)((TypeName.Builder)TypeName.builder().packageName(aiInterfaceType.packageName())).className(aiInterfaceType.classNameWithEnclosingNames().replace('.', '_') + "__" + suffix)).build();
    }

    private TypeName supplierType(TypeName suppliedType) {
        return ((TypeName.Builder)TypeName.builder((TypeName)TypeNames.SUPPLIER).addTypeArgument(suppliedType)).build();
    }

    private TypeName optionalType(TypeName optionalType) {
        return ((TypeName.Builder)TypeName.builder((TypeName)TypeNames.OPTIONAL).addTypeArgument(optionalType)).build();
    }

    private TypeName listType(TypeName listType) {
        return ((TypeName.Builder)TypeName.builder((TypeName)TypeNames.LIST).addTypeArgument(listType)).build();
    }
}

