/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.integrations.common.rest;

import io.helidon.config.Config;
import io.helidon.faulttolerance.FaultTolerance;
import io.helidon.faulttolerance.FtHandler;
import io.helidon.http.Method;
import io.helidon.http.media.jsonp.JsonpSupport;
import io.helidon.integrations.common.rest.ApiEntityResponse;
import io.helidon.integrations.common.rest.ApiOptionalResponse;
import io.helidon.integrations.common.rest.ApiRequest;
import io.helidon.integrations.common.rest.ApiResponse;
import io.helidon.webclient.api.WebClient;
import io.helidon.webclient.api.WebClientConfig;
import jakarta.json.Json;
import jakarta.json.JsonBuilderFactory;
import jakarta.json.JsonObject;
import jakarta.json.JsonReaderFactory;
import jakarta.json.JsonWriterFactory;
import java.io.InputStream;
import java.util.Map;
import java.util.function.Consumer;

public interface RestApi {
    default public <R, T extends ApiOptionalResponse<R>> T get(String path, ApiRequest<?> request, ApiOptionalResponse.BuilderBase<?, T, JsonObject, R> responseBuilder) {
        return this.invokeOptional(Method.GET, path, request, responseBuilder);
    }

    default public <R, T extends ApiOptionalResponse<R>> T getEntityStream(String path, ApiRequest<?> request, ApiOptionalResponse.BuilderBase<?, T, InputStream, R> responseBuilder) {
        return this.invokeEntityResponse(Method.GET, path, request, responseBuilder);
    }

    default public <R, T extends ApiOptionalResponse<R>> T getBytes(String path, ApiRequest<?> request, ApiOptionalResponse.BuilderBase<?, T, byte[], R> responseBuilder) {
        return this.invokeBytesResponse(Method.GET, path, request, responseBuilder);
    }

    default public <T extends ApiResponse> T post(String path, ApiRequest<?> request, ApiResponse.Builder<?, T> responseBuilder) {
        return this.invoke(Method.POST, path, request, responseBuilder);
    }

    default public <T extends ApiResponse> T put(String path, ApiRequest<?> request, ApiResponse.Builder<?, T> responseBuilder) {
        return this.invoke(Method.PUT, path, request, responseBuilder);
    }

    default public <T extends ApiResponse> T delete(String path, ApiRequest<?> request, ApiResponse.Builder<?, T> responseBuilder) {
        return this.invoke(Method.DELETE, path, request, responseBuilder);
    }

    public <T extends ApiResponse> T invoke(Method var1, String var2, ApiRequest<?> var3, ApiResponse.Builder<?, T> var4);

    public <T extends ApiEntityResponse> T invokeWithResponse(Method var1, String var2, ApiRequest<?> var3, ApiEntityResponse.Builder<?, T, JsonObject> var4);

    public <T extends ApiResponse> T invokeBytesRequest(Method var1, String var2, ApiRequest<?> var3, InputStream var4, ApiResponse.Builder<?, T> var5);

    public <R, T extends ApiOptionalResponse<R>> T invokeEntityResponse(Method var1, String var2, ApiRequest<?> var3, ApiOptionalResponse.BuilderBase<?, T, InputStream, R> var4);

    public <R, T extends ApiOptionalResponse<R>> T invokeBytesResponse(Method var1, String var2, ApiRequest<?> var3, ApiOptionalResponse.BuilderBase<?, T, byte[], R> var4);

    public <R, T extends ApiOptionalResponse<R>> T invokeOptional(Method var1, String var2, ApiRequest<?> var3, ApiOptionalResponse.BuilderBase<?, T, JsonObject, R> var4);

    public static abstract class Builder<B extends Builder<B, T>, T extends RestApi>
    implements io.helidon.common.Builder<B, T> {
        private final WebClientConfig.Builder webClientBuilder = (WebClientConfig.Builder)((WebClientConfig.Builder)WebClient.builder().followRedirects(true)).keepAlive(true);
        private FtHandler ftHandler = FaultTolerance.builder().build();
        private JsonBuilderFactory jsonBuilderFactory;
        private JsonReaderFactory jsonReaderFactory;
        private JsonWriterFactory jsonWriterFactory;
        private WebClient webClient;

        public final T build() {
            this.preBuild();
            T result = this.doBuild();
            this.postBuild();
            return result;
        }

        public final T get() {
            return (T)this.build();
        }

        public B config(Config config) {
            this.webClientBuilder.config(config.get("webclient"));
            Map jsonConfig = (Map)config.get("jsonp").asMap().orElseGet(Map::of);
            if (this.jsonBuilderFactory == null) {
                this.jsonBuilderFactory = Json.createBuilderFactory((Map)jsonConfig);
            }
            if (this.jsonReaderFactory == null) {
                this.jsonReaderFactory = Json.createReaderFactory((Map)jsonConfig);
            }
            if (this.jsonWriterFactory == null) {
                this.jsonWriterFactory = Json.createWriterFactory((Map)jsonConfig);
            }
            return this.me();
        }

        public B faultTolerance(FtHandler ftHandler) {
            this.ftHandler = ftHandler;
            return this.me();
        }

        public B webClientBuilder(Consumer<WebClientConfig.Builder> updater) {
            updater.accept(this.webClientBuilder);
            return this.me();
        }

        protected B me() {
            return (B)this;
        }

        protected void preBuild() {
            this.webClient = ((WebClientConfig.Builder)this.webClientBuilder.addMediaSupport(JsonpSupport.create())).build();
            if (this.jsonBuilderFactory == null) {
                this.jsonBuilderFactory = Json.createBuilderFactory(Map.of());
            }
            if (this.jsonReaderFactory == null) {
                this.jsonReaderFactory = Json.createReaderFactory(Map.of());
            }
            if (this.jsonWriterFactory == null) {
                this.jsonWriterFactory = Json.createWriterFactory(Map.of());
            }
        }

        protected void postBuild() {
        }

        protected abstract T doBuild();

        protected WebClient webClient() {
            return this.webClient;
        }

        protected FtHandler ftHandler() {
            return this.ftHandler;
        }

        protected JsonBuilderFactory jsonBuilderFactory() {
            return this.jsonBuilderFactory;
        }

        protected JsonReaderFactory jsonReaderFactory() {
            return this.jsonReaderFactory;
        }

        protected JsonWriterFactory jsonWriterFactory() {
            return this.jsonWriterFactory;
        }
    }
}

