/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.integrations.common.rest;

import io.helidon.common.context.Contexts;
import io.helidon.common.media.type.MediaType;
import io.helidon.common.media.type.MediaTypes;
import io.helidon.faulttolerance.FtHandler;
import io.helidon.http.Headers;
import io.helidon.http.Http;
import io.helidon.integrations.common.rest.ApiEntityResponse;
import io.helidon.integrations.common.rest.ApiOptionalResponse;
import io.helidon.integrations.common.rest.ApiRequest;
import io.helidon.integrations.common.rest.ApiResponse;
import io.helidon.integrations.common.rest.ApiRestException;
import io.helidon.integrations.common.rest.ResponseBuilder;
import io.helidon.integrations.common.rest.RestApi;
import io.helidon.integrations.common.rest.RestException;
import io.helidon.webclient.api.HttpClientRequest;
import io.helidon.webclient.api.HttpClientResponse;
import io.helidon.webclient.api.WebClient;
import io.opentracing.SpanContext;
import jakarta.json.JsonBuilderFactory;
import jakarta.json.JsonObject;
import jakarta.json.JsonReaderFactory;
import jakarta.json.JsonWriterFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import java.util.logging.Logger;

public abstract class RestApiBase
implements RestApi {
    private static final Logger LOGGER = Logger.getLogger(RestApiBase.class.getName());
    private final WebClient webClient;
    private final FtHandler ftHandler;
    private final JsonBuilderFactory jsonBuilderFactory;
    private final JsonReaderFactory jsonReaderFactory;
    private final JsonWriterFactory jsonWriterFactory;

    protected RestApiBase(RestApi.Builder<?, ?> builder) {
        this.webClient = builder.webClient();
        this.ftHandler = builder.ftHandler();
        this.jsonBuilderFactory = builder.jsonBuilderFactory();
        this.jsonReaderFactory = builder.jsonReaderFactory();
        this.jsonWriterFactory = builder.jsonWriterFactory();
    }

    @Override
    public <T extends ApiResponse> T invoke(Http.Method method, String path, ApiRequest<?> request, ApiResponse.Builder<?, T> responseBuilder) {
        String requestId = this.requestId(request);
        LOGGER.finest(() -> requestId + ": Invoking " + String.valueOf(method) + " on path " + path + " no entity expected.");
        HttpClientResponse response = (HttpClientResponse)this.ftHandler.invoke(this.responseSupplier(method, path, request, requestId));
        return this.handleResponse(path, request, method, requestId, response, responseBuilder);
    }

    @Override
    public <T extends ApiEntityResponse> T invokeWithResponse(Http.Method method, String path, ApiRequest<?> request, ApiEntityResponse.Builder<?, T, JsonObject> responseBuilder) {
        String requestId = this.requestId(request);
        LOGGER.finest(() -> requestId + ": Invoking " + String.valueOf(method) + " on path " + path + " JSON entity expected.");
        Supplier<HttpClientResponse> responseSupplier = this.responseSupplier(method, path, request, requestId);
        HttpClientResponse response = (HttpClientResponse)this.ftHandler.invoke(responseSupplier);
        return this.handleJsonResponse(path, request, method, requestId, response, responseBuilder);
    }

    @Override
    public <T extends ApiResponse> T invokeBytesRequest(Http.Method method, String path, ApiRequest<?> apiRequest, InputStream is, ApiResponse.Builder<?, T> responseBuilder) {
        String requestId = this.requestId(apiRequest);
        LOGGER.finest(() -> requestId + ": Invoking " + String.valueOf(method) + " on path " + path + " with bytes request");
        HttpClientRequest request = (HttpClientRequest)((HttpClientRequest)this.webClient.method(method)).path(path);
        this.addHeaders(request, apiRequest.headers());
        this.addQueryParams(request, apiRequest.queryParams());
        Supplier<HttpClientResponse> responseSupplier = this.requestBytesPayload(path, apiRequest, method, requestId, request, is);
        HttpClientResponse response = (HttpClientResponse)this.ftHandler.invoke(responseSupplier);
        return this.handleResponse(path, apiRequest, method, requestId, response, responseBuilder);
    }

    @Override
    public <R, T extends ApiOptionalResponse<R>> T invokeEntityResponse(Http.Method method, String path, ApiRequest<?> request, ApiOptionalResponse.BuilderBase<?, T, InputStream, R> responseBuilder) {
        String requestId = this.requestId(request);
        LOGGER.finest(() -> requestId + ": Invoking " + String.valueOf(method) + " on path " + path + " with publisher response");
        request.responseMediaType(request.responseMediaType().orElse(MediaTypes.WILDCARD));
        HttpClientResponse response = (HttpClientResponse)this.ftHandler.invoke(this.responseSupplier(method, path, request, requestId));
        return this.handleEntityResponse(path, request, method, requestId, response, responseBuilder);
    }

    @Override
    public <R, T extends ApiOptionalResponse<R>> T invokeBytesResponse(Http.Method method, String path, ApiRequest<?> request, ApiOptionalResponse.BuilderBase<?, T, byte[], R> responseBuilder) {
        String requestId = this.requestId(request);
        LOGGER.finest(() -> requestId + ": Invoking " + String.valueOf(method) + " on path " + path + " with bytes response");
        request.responseMediaType(request.responseMediaType().orElse(MediaTypes.WILDCARD));
        Supplier<HttpClientResponse> responseSupplier = this.responseSupplier(method, path, request, requestId);
        HttpClientResponse response = (HttpClientResponse)this.ftHandler.invoke(responseSupplier);
        return this.handleBytesResponse(path, request, method, requestId, response, responseBuilder);
    }

    @Override
    public <R, T extends ApiOptionalResponse<R>> T invokeOptional(Http.Method method, String path, ApiRequest<?> request, ApiOptionalResponse.BuilderBase<?, T, JsonObject, R> responseBuilder) {
        String requestId = this.requestId(request);
        LOGGER.finest(() -> requestId + ": Invoking " + String.valueOf(method) + " on path " + path + " with optional response");
        HttpClientResponse response = (HttpClientResponse)this.ftHandler.invoke(this.responseSupplier(method, path, request, requestId));
        return this.handleOptionalJsonResponse(path, request, method, requestId, response, responseBuilder);
    }

    protected Supplier<HttpClientResponse> responseSupplier(Http.Method method, String path, ApiRequest<?> request, String requestId) {
        HttpClientRequest requestBuilder = (HttpClientRequest)((HttpClientRequest)this.webClient.method(method)).path(path);
        this.addHeaders(requestBuilder, request.headers());
        this.addQueryParams(requestBuilder, request.queryParams());
        Optional<JsonObject> payload = request.toJson(this.jsonBuilderFactory);
        Supplier<HttpClientResponse> responseSupplier = payload.isPresent() ? this.requestJsonPayload(path, request, method, requestId, requestBuilder, payload.get()) : this.requestPayload(path, request, method, requestId, requestBuilder);
        return responseSupplier;
    }

    protected void addQueryParams(HttpClientRequest request, Map<String, List<String>> queryParams) {
        queryParams.forEach((name, values) -> {
            if (values.size() == 1) {
                request.queryParam(name, new String[]{(String)values.iterator().next()});
            } else {
                request.queryParam(name, values.toArray(new String[0]));
            }
        });
    }

    protected void addHeaders(HttpClientRequest request, Map<String, List<String>> headers) {
        request.headers(clientHeaders -> headers.forEach((key, value) -> clientHeaders.set(Http.HeaderNames.create((String)key), (Collection)value)));
    }

    protected <R, T extends ApiOptionalResponse<R>> T handleBytesResponse(String path, ApiRequest<?> request, Http.Method method, String requestId, HttpClientResponse response, ApiOptionalResponse.BuilderBase<?, T, byte[], R> responseBuilder) {
        ResponseState statusKind = this.responseState(path, request, method, requestId, response);
        if (statusKind.success) {
            if (statusKind.entityExpected) {
                try {
                    return (T)((ApiOptionalResponse)((ApiOptionalResponse.BuilderBase)((ApiOptionalResponse.BuilderBase)((ApiOptionalResponse.BuilderBase)responseBuilder.headers((Headers)response.headers())).status(response.status())).requestId(requestId)).entity(response.inputStream().readAllBytes()).build());
                }
                catch (IOException ex) {
                    throw this.readErrorFailedEntity(path, request, method, requestId, response, ex);
                }
            }
            return (T)((ApiOptionalResponse)this.emptyResponse(path, request, method, requestId, response, responseBuilder));
        }
        throw this.responseError(path, request, method, requestId, response);
    }

    protected <R, T extends ApiOptionalResponse<R>> T handleEntityResponse(String path, ApiRequest<?> request, Http.Method method, String requestId, HttpClientResponse response, ApiOptionalResponse.BuilderBase<?, T, InputStream, R> responseBuilder) {
        ResponseState statusKind = this.responseState(path, request, method, requestId, response);
        if (statusKind.success) {
            if (statusKind.entityExpected) {
                return (T)((ApiOptionalResponse)((ApiOptionalResponse.BuilderBase)((ApiOptionalResponse.BuilderBase)((ApiOptionalResponse.BuilderBase)responseBuilder.headers((Headers)response.headers())).status(response.status())).requestId(requestId)).entity(response.inputStream()).build());
            }
            return (T)((ApiOptionalResponse)this.emptyResponse(path, request, method, requestId, response, responseBuilder));
        }
        throw this.responseError(path, request, method, requestId, response);
    }

    protected boolean isSuccess(String path, ApiRequest<?> request, Http.Method method, String requestId, Http.Status status) {
        if (status == Http.Status.NOT_FOUND_404) {
            return true;
        }
        if (status == Http.Status.NOT_MODIFIED_304) {
            return true;
        }
        Http.Status.Family family = Http.Status.Family.of((int)status.code());
        return switch (family) {
            case Http.Status.Family.REDIRECTION, Http.Status.Family.CLIENT_ERROR, Http.Status.Family.SERVER_ERROR -> false;
            default -> true;
        };
    }

    protected boolean isEntityExpected(String path, ApiRequest<?> request, Http.Method method, String requestId, Http.Status status) {
        Http.Status.Family family = Http.Status.Family.of((int)status.code());
        return switch (family) {
            case Http.Status.Family.REDIRECTION, Http.Status.Family.CLIENT_ERROR, Http.Status.Family.SERVER_ERROR -> false;
            default -> true;
        };
    }

    protected <R, T extends ApiOptionalResponse<R>> T handleOptionalJsonResponse(String path, ApiRequest<?> request, Http.Method method, String requestId, HttpClientResponse response, ApiOptionalResponse.BuilderBase<?, T, JsonObject, R> responseBuilder) {
        ResponseState statusKind = this.responseState(path, request, method, requestId, response);
        if (statusKind.success) {
            if (statusKind.entityExpected) {
                LOGGER.finest(() -> requestId + ": " + String.valueOf(method) + " on path " + path + " returned " + String.valueOf(response.status()));
                if (response.headers().contentLength().orElse(-1L) == 0L) {
                    return (T)((ApiOptionalResponse)this.emptyResponse(path, request, method, requestId, response, responseBuilder));
                }
                try {
                    JsonObject entity = (JsonObject)response.entity().as(JsonObject.class);
                    return (T)((ApiOptionalResponse)this.jsonOkResponse(path, request, method, requestId, response, entity, responseBuilder));
                }
                catch (Throwable ex) {
                    throw this.readErrorFailedEntity(path, request, method, requestId, response, ex);
                }
            }
            return (T)((ApiOptionalResponse)this.emptyResponse(path, request, method, requestId, response, responseBuilder));
        }
        LOGGER.finest(() -> requestId + ": " + String.valueOf(method) + " on path " + path + " failed " + String.valueOf(response.status()));
        throw this.responseError(path, request, method, requestId, response);
    }

    protected <T> T emptyResponse(String path, ApiRequest<?> request, Http.Method method, String requestId, HttpClientResponse response, ResponseBuilder<?, T, ?> responseBuilder) {
        return (T)responseBuilder.headers((Headers)response.headers()).status(response.status()).requestId(requestId).build();
    }

    protected <T> T jsonOkResponse(String path, ApiRequest<?> request, Http.Method method, String requestId, HttpClientResponse response, JsonObject json, ResponseBuilder<?, T, JsonObject> responseBuilder) {
        return (T)responseBuilder.headers((Headers)response.headers()).status(response.status()).requestId(requestId).entity((JsonObject)json).build();
    }

    protected <T extends ApiEntityResponse> T handleJsonResponse(String path, ApiRequest<?> request, Http.Method method, String requestId, HttpClientResponse response, ApiEntityResponse.Builder<?, T, JsonObject> responseBuilder) {
        Http.Status status = response.status();
        if (Http.Status.Family.of((int)status.code()) == Http.Status.Family.SUCCESSFUL) {
            LOGGER.finest(() -> requestId + ": " + String.valueOf(method) + " on path " + path + " returned " + String.valueOf(status));
            try {
                JsonObject entity = (JsonObject)response.entity().as(JsonObject.class);
                return (T)((ApiEntityResponse)this.jsonOkResponse(path, request, method, requestId, response, entity, responseBuilder));
            }
            catch (Throwable ex) {
                throw this.readErrorFailedEntity(path, request, method, requestId, response, ex);
            }
        }
        LOGGER.finest(() -> requestId + ": " + String.valueOf(method) + " on path " + path + " failed " + String.valueOf(status));
        throw this.responseError(path, request, method, requestId, response);
    }

    protected <T extends ApiResponse> T handleResponse(String path, ApiRequest<?> request, Http.Method method, String requestId, HttpClientResponse response, ApiResponse.Builder<?, T> responseBuilder) {
        boolean success;
        Http.Status status = response.status();
        boolean bl = success = Http.Status.Family.of((int)status.code()) == Http.Status.Family.SUCCESSFUL;
        if (success) {
            LOGGER.finest(() -> requestId + ": " + String.valueOf(method) + " on path " + path + " returned " + String.valueOf(status));
            return this.noEntityOkResponse(path, request, method, requestId, response, responseBuilder);
        }
        LOGGER.finest(() -> requestId + ": " + String.valueOf(method) + " on path " + path + " failed " + String.valueOf(status));
        throw this.responseError(path, request, method, requestId, response);
    }

    protected ApiRestException responseError(String path, ApiRequest<?> request, Http.Method method, String requestId, HttpClientResponse response) {
        if (response.headers().contentLength().orElse(-1L) == 0L) {
            return this.readError(path, request, method, requestId, response);
        }
        try {
            String entity = (String)response.entity().as(String.class);
            try {
                JsonObject json = this.jsonReaderFactory.createReader((Reader)new StringReader(entity)).readObject();
                return this.readError(path, request, method, requestId, response, json);
            }
            catch (Throwable ex) {
                return this.readError(path, request, method, requestId, response, entity);
            }
        }
        catch (Throwable ex) {
            return this.readErrorFailedEntity(path, request, method, requestId, response, ex);
        }
    }

    protected ApiRestException readErrorFailedEntity(String path, ApiRequest<?> request, Http.Method method, String requestId, HttpClientResponse response, Throwable throwable) {
        return ((RestException.Builder)((RestException.Builder)((RestException.Builder)((RestException.Builder)((RestException.Builder)RestException.builder().cause(throwable)).requestId(requestId)).status(response.status())).message("Failed to invoke %s on path %s %d, failed to read entity.", method, path, response.status().code())).headers((Headers)response.headers())).build();
    }

    protected ApiRestException readError(String path, ApiRequest<?> request, Http.Method method, String requestId, HttpClientResponse response, String entity) {
        LOGGER.finest(() -> requestId + ": request failed for path " + path + ", error response: " + entity);
        return ((RestException.Builder)((RestException.Builder)((RestException.Builder)((RestException.Builder)RestException.builder().requestId(requestId)).status(response.status())).message("Failed to invoke %s on path %s %d", method, path, response.status().code())).headers((Headers)response.headers())).build();
    }

    protected ApiRestException readError(String path, ApiRequest<?> request, Http.Method method, String requestId, HttpClientResponse response) {
        LOGGER.finest(() -> requestId + ": request failed for path " + path);
        return ((RestException.Builder)((RestException.Builder)((RestException.Builder)((RestException.Builder)RestException.builder().requestId(requestId)).status(response.status())).message("Failed to invoke %s on path %s %d", method, path, response.status().code())).headers((Headers)response.headers())).build();
    }

    protected ApiRestException readError(String path, ApiRequest<?> request, Http.Method method, String requestId, HttpClientResponse response, JsonObject errorObject) {
        LOGGER.finest(() -> requestId + ": request failed for path " + path + ", error object: " + String.valueOf(errorObject));
        return ((RestException.Builder)((RestException.Builder)((RestException.Builder)((RestException.Builder)RestException.builder().requestId(requestId)).status(response.status())).message("Failed to invoke %s on path %s %d", method, path, response.status().code())).headers((Headers)response.headers())).build();
    }

    protected <T extends ApiResponse> T noEntityOkResponse(String path, ApiRequest<?> request, Http.Method method, String requestId, HttpClientResponse response, ApiResponse.Builder<?, T> responseBuilder) {
        return (T)((ApiResponse)((ApiResponse.Builder)((ApiResponse.Builder)responseBuilder.headers((Headers)response.headers())).status(response.status())).requestId(requestId).build());
    }

    protected Supplier<HttpClientResponse> requestJsonPayload(String path, ApiRequest<?> request, Http.Method method, String requestId, HttpClientRequest requestBuilder, JsonObject jsonObject) {
        AtomicBoolean updated = new AtomicBoolean();
        return () -> {
            HttpClientRequest clientRequest = requestBuilder;
            if (updated.compareAndSet(false, true)) {
                MediaType mediaType = request.responseMediaType().orElse(MediaTypes.APPLICATION_JSON);
                ((HttpClientRequest)clientRequest.accept(new MediaType[]{mediaType})).contentType(mediaType);
                clientRequest = this.updateRequestBuilder(requestBuilder, path, request, method, requestId, jsonObject);
            }
            return clientRequest.submit((Object)jsonObject);
        };
    }

    protected Supplier<HttpClientResponse> requestBytesPayload(String path, ApiRequest<?> request, Http.Method method, String requestId, HttpClientRequest requestBuilder, InputStream is) {
        AtomicBoolean updated = new AtomicBoolean();
        return () -> {
            HttpClientRequest clientRequest = requestBuilder;
            if (updated.compareAndSet(false, true)) {
                Optional<MediaType> mediaType = request.responseMediaType();
                ((HttpClientRequest)clientRequest.accept(new MediaType[]{mediaType.orElse(MediaTypes.APPLICATION_JSON)})).contentType(mediaType.orElse(MediaTypes.APPLICATION_OCTET_STREAM));
                clientRequest = this.updateRequestBuilderBytesPayload(requestBuilder, path, request, method, requestId);
            }
            return clientRequest.submit((Object)is);
        };
    }

    protected Supplier<HttpClientResponse> requestPayload(String path, ApiRequest<?> request, Http.Method method, String requestId, HttpClientRequest requestBuilder) {
        AtomicBoolean updated = new AtomicBoolean();
        return () -> {
            HttpClientRequest clientRequest = requestBuilder;
            if (updated.compareAndSet(false, true)) {
                clientRequest = this.updateRequestBuilder(requestBuilder, path, request, method, requestId);
            }
            return clientRequest.request();
        };
    }

    protected HttpClientRequest updateRequestBuilder(HttpClientRequest requestBuilder, String path, ApiRequest<?> request, Http.Method method, String requestId) {
        return this.updateRequestBuilderCommon(requestBuilder, path, request, method, requestId);
    }

    protected HttpClientRequest updateRequestBuilderBytesPayload(HttpClientRequest requestBuilder, String path, ApiRequest<?> request, Http.Method method, String requestId) {
        return this.updateRequestBuilderCommon(requestBuilder, path, request, method, requestId);
    }

    protected HttpClientRequest updateRequestBuilder(HttpClientRequest requestBuilder, String path, ApiRequest<?> request, Http.Method method, String requestId, JsonObject jsonObject) {
        return this.updateRequestBuilderCommon(requestBuilder, path, request, method, requestId);
    }

    protected HttpClientRequest updateRequestBuilderCommon(HttpClientRequest requestBuilder, String path, ApiRequest<?> request, Http.Method method, String requestId) {
        return requestBuilder;
    }

    protected String requestId(ApiRequest<?> request) {
        return request.requestId().or(() -> Contexts.context().flatMap(it -> it.get(SpanContext.class)).map(SpanContext::toTraceId)).orElseGet(UUID.randomUUID()::toString);
    }

    protected WebClient webClient() {
        return this.webClient;
    }

    protected FtHandler ftHandler() {
        return this.ftHandler;
    }

    protected JsonBuilderFactory jsonBuilderFactory() {
        return this.jsonBuilderFactory;
    }

    protected JsonReaderFactory jsonReaderFactory() {
        return this.jsonReaderFactory;
    }

    protected JsonWriterFactory jsonWriterFactory() {
        return this.jsonWriterFactory;
    }

    private ResponseState responseState(String path, ApiRequest<?> request, Http.Method method, String requestId, HttpClientResponse response) {
        Http.Status status = response.status();
        boolean success = Http.Status.Family.of((int)status.code()) == Http.Status.Family.SUCCESSFUL || this.isSuccess(path, request, method, requestId, status);
        boolean isEntityExpected = Http.Status.Family.of((int)status.code()) == Http.Status.Family.SUCCESSFUL || this.isEntityExpected(path, request, method, requestId, status);
        return new ResponseState(success, isEntityExpected);
    }

    private record ResponseState(boolean success, boolean entityExpected) {
    }
}

