/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.integrations.common.rest;

import io.helidon.http.Headers;
import io.helidon.http.Http;
import io.helidon.integrations.common.rest.ApiException;
import java.util.Optional;

public abstract class ApiRestException
extends ApiException {
    private final String requestId;
    private final Http.Status status;
    private final Headers headers;
    private final String apiSpecificError;

    protected ApiRestException(BaseBuilder<?> builder) {
        super(builder.requestId + ": " + builder.message, builder.cause);
        this.requestId = builder.requestId;
        this.status = builder.status;
        this.headers = builder.headers;
        this.apiSpecificError = builder.apiSpecificError;
    }

    public Http.Status status() {
        return this.status;
    }

    public String requestId() {
        return this.requestId;
    }

    public Optional<String> apiSpecificError() {
        return Optional.ofNullable(this.apiSpecificError);
    }

    public Headers headers() {
        return this.headers;
    }

    public static abstract class BaseBuilder<B extends BaseBuilder<B>> {
        private String message;
        private String requestId;
        private Http.Status status;
        private Headers headers;
        private String apiSpecificError;
        private Throwable cause;

        public B message(String message) {
            this.message = message;
            return this.me();
        }

        public B message(String format, Object ... args) {
            this.message = String.format(format, args);
            return this.me();
        }

        public B requestId(String requestId) {
            this.requestId = requestId;
            return this.me();
        }

        public B status(Http.Status status) {
            this.status = status;
            return this.me();
        }

        public B headers(Headers headers) {
            this.headers = headers;
            return this.me();
        }

        public B apiSpecificError(String apiSpecificError) {
            this.apiSpecificError = apiSpecificError;
            return this.me();
        }

        public B cause(Throwable t) {
            this.cause = t;
            return this.me();
        }

        protected B me() {
            return (B)this;
        }
    }
}

