/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.integrations.common.rest;

import io.helidon.integrations.common.rest.ApiResponse;
import io.helidon.integrations.common.rest.ResponseBuilder;
import java.util.Optional;
import java.util.function.Function;

public class ApiOptionalResponse<R>
extends ApiResponse {
    private final Optional<R> entity;

    protected ApiOptionalResponse(BuilderBase<?, ?, ?, ?> builder, Optional<R> entity) {
        super(builder);
        this.entity = entity;
    }

    public static <X, R> Builder<X, R> apiResponseBuilder() {
        return new Builder();
    }

    public Optional<R> entity() {
        return this.entity;
    }

    public <U> ApiOptionalResponse<U> map(Function<R, U> mapper) {
        Builder builder = ApiOptionalResponse.apiResponseBuilder();
        this.entity.map(mapper).ifPresent(builder::entity);
        return ((Builder)((Builder)((Builder)((Builder)builder.entityProcessor(Function.identity())).headers(this.headers())).requestId(this.requestId())).status(this.status())).build();
    }

    public static final class Builder<X, R>
    extends BuilderBase<Builder<X, R>, ApiOptionalResponse<R>, X, R> {
        private Builder() {
        }

        public ApiOptionalResponse<R> build() {
            return new ApiOptionalResponse(this, this.entity().map(this.entityProcessor()));
        }
    }

    public static abstract class BuilderBase<B extends BuilderBase<B, T, X, R>, T extends ApiOptionalResponse<R>, X, R>
    extends ApiResponse.Builder<B, T>
    implements ResponseBuilder<B, T, X> {
        private X entity;
        private Function<X, R> entityProcessor;

        protected BuilderBase() {
        }

        @Override
        public B entity(X entity) {
            this.entity = entity;
            return (B)((BuilderBase)this.me());
        }

        public B entityProcessor(Function<X, R> processor) {
            this.entityProcessor = processor;
            return (B)((BuilderBase)this.me());
        }

        protected Optional<X> entity() {
            return Optional.ofNullable(this.entity);
        }

        protected Function<X, R> entityProcessor() {
            return this.entityProcessor;
        }
    }
}

