/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.integrations.common.rest;

import io.helidon.common.Base64Value;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonBuilderFactory;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonValue;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;

public abstract class ApiJsonBuilder<T extends ApiJsonBuilder<T>> {
    private final Map<String, Consumer<JsonObjectBuilder>> values = new HashMap<String, Consumer<JsonObjectBuilder>>();
    private final Map<String, ApiJsonBuilder<?>> objects = new HashMap();
    private final Map<String, List<Consumer<JsonArrayBuilder>>> arrays = new HashMap<String, List<Consumer<JsonArrayBuilder>>>();
    private final Map<String, List<ApiJsonBuilder<?>>> objectArrays = new HashMap();
    private final Map<String, Map<String, Consumer<JsonObjectBuilder>>> objectsAsMaps = new HashMap<String, Map<String, Consumer<JsonObjectBuilder>>>();

    protected ApiJsonBuilder() {
    }

    public Optional<JsonObject> toJson(JsonBuilderFactory factory) {
        JsonObjectBuilder payload = factory.createObjectBuilder();
        this.preBuild(factory, payload);
        this.values.forEach((key, value) -> value.accept(payload));
        this.objects.forEach((key, value) -> value.toJson(factory).ifPresent(it -> payload.add(key, (JsonValue)it)));
        this.arrays.forEach((key, value) -> this.addArray(payload, factory, (String)key, (List<Consumer<JsonArrayBuilder>>)value));
        this.objectArrays.forEach((key, value) -> this.addObjectArray(payload, factory, (String)key, (List<ApiJsonBuilder<?>>)value));
        this.objectsAsMaps.forEach((key, value) -> {
            JsonObjectBuilder childObject = factory.createObjectBuilder();
            value.forEach((childKey, childValue) -> childValue.accept(childObject));
            payload.add(key, childObject);
        });
        this.postBuild(factory, payload);
        return Optional.of(payload.build());
    }

    protected T me() {
        return (T)this;
    }

    protected void preBuild(JsonBuilderFactory factory, JsonObjectBuilder payload) {
    }

    protected void postBuild(JsonBuilderFactory factory, JsonObjectBuilder payload) {
    }

    protected T addToArray(String name, String element) {
        this.arrays.computeIfAbsent(name, it -> new LinkedList()).add(it -> it.add(element));
        return this.me();
    }

    protected T addToArray(String name, int element) {
        this.arrays.computeIfAbsent(name, it -> new LinkedList()).add(it -> it.add(element));
        return this.me();
    }

    protected T addToArray(String name, long element) {
        this.arrays.computeIfAbsent(name, it -> new LinkedList()).add(it -> it.add(element));
        return this.me();
    }

    protected T addToArray(String name, double element) {
        this.arrays.computeIfAbsent(name, it -> new LinkedList()).add(it -> it.add(element));
        return this.me();
    }

    protected T addToArray(String name, boolean element) {
        this.arrays.computeIfAbsent(name, it -> new LinkedList()).add(it -> it.add(element));
        return this.me();
    }

    protected T add(String name, String value) {
        return this.add(name, (JsonObjectBuilder builder) -> builder.add(name, value));
    }

    protected T add(String name, int value) {
        return this.add(name, (JsonObjectBuilder builder) -> builder.add(name, value));
    }

    protected T add(String name, double value) {
        return this.add(name, (JsonObjectBuilder builder) -> builder.add(name, value));
    }

    protected T add(String name, long value) {
        return this.add(name, (JsonObjectBuilder builder) -> builder.add(name, value));
    }

    protected T add(String name, boolean value) {
        return this.add(name, (JsonObjectBuilder builder) -> builder.add(name, value));
    }

    protected T add(String name, ApiJsonBuilder<?> object) {
        this.objects.put(name, object);
        return this.me();
    }

    protected T addBase64(String name, Base64Value base64Value) {
        return this.add(name, base64Value.toBase64());
    }

    protected T emptyArray(String name) {
        this.arrays.put(name, new LinkedList());
        return this.me();
    }

    protected T addToArray(String name, ApiJsonBuilder<?> element) {
        this.objectArrays.computeIfAbsent(name, it -> new LinkedList()).add(element);
        return this.me();
    }

    protected T addToObject(String name, String key, String value) {
        this.objectsAsMaps.computeIfAbsent(name, it -> new HashMap()).put(key, builder -> builder.add(key, value));
        return this.me();
    }

    protected T addToObject(String name, String key, int value) {
        this.objectsAsMaps.computeIfAbsent(name, it -> new HashMap()).put(key, builder -> builder.add(key, value));
        return this.me();
    }

    protected T addToObject(String name, String key, long value) {
        this.objectsAsMaps.computeIfAbsent(name, it -> new HashMap()).put(key, builder -> builder.add(key, value));
        return this.me();
    }

    protected T addToObject(String name, String key, double value) {
        this.objectsAsMaps.computeIfAbsent(name, it -> new HashMap()).put(key, builder -> builder.add(key, value));
        return this.me();
    }

    protected T addToObject(String name, String key, boolean value) {
        this.objectsAsMaps.computeIfAbsent(name, it -> new HashMap()).put(key, builder -> builder.add(key, value));
        return this.me();
    }

    private void addArray(JsonObjectBuilder payloadBuilder, JsonBuilderFactory json, String name, List<Consumer<JsonArrayBuilder>> values) {
        JsonArrayBuilder arrayBuilder = json.createArrayBuilder();
        for (Consumer<JsonArrayBuilder> value : values) {
            value.accept(arrayBuilder);
        }
        payloadBuilder.add(name, arrayBuilder);
    }

    private void addObjectArray(JsonObjectBuilder payloadBuilder, JsonBuilderFactory json, String name, List<ApiJsonBuilder<?>> values) {
        if (values == null) {
            return;
        }
        JsonArrayBuilder arrayBuilder = json.createArrayBuilder();
        for (ApiJsonBuilder<?> element : values) {
            element.toJson(json).ifPresent(arg_0 -> ((JsonArrayBuilder)arrayBuilder).add(arg_0));
        }
        payloadBuilder.add(name, arrayBuilder);
    }

    private T add(String name, Consumer<JsonObjectBuilder> consumer) {
        this.values.put(name, consumer);
        return this.me();
    }
}

