/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.integrations.common.rest;

import io.helidon.common.context.Contexts;
import io.helidon.common.http.DataChunk;
import io.helidon.common.http.Headers;
import io.helidon.common.http.Http;
import io.helidon.common.http.MediaType;
import io.helidon.common.reactive.Collector;
import io.helidon.common.reactive.Multi;
import io.helidon.common.reactive.Single;
import io.helidon.faulttolerance.FtHandler;
import io.helidon.integrations.common.rest.ApiEntityResponse;
import io.helidon.integrations.common.rest.ApiOptionalResponse;
import io.helidon.integrations.common.rest.ApiRequest;
import io.helidon.integrations.common.rest.ApiResponse;
import io.helidon.integrations.common.rest.ResponseBuilder;
import io.helidon.integrations.common.rest.RestApi;
import io.helidon.integrations.common.rest.RestException;
import io.helidon.webclient.WebClient;
import io.helidon.webclient.WebClientRequestBuilder;
import io.helidon.webclient.WebClientRequestHeaders;
import io.helidon.webclient.WebClientResponse;
import io.opentracing.SpanContext;
import java.io.ByteArrayOutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import java.util.logging.Logger;
import javax.json.JsonBuilderFactory;
import javax.json.JsonObject;
import javax.json.JsonReaderFactory;
import javax.json.JsonWriterFactory;

public abstract class RestApiBase
implements RestApi {
    private static final Logger LOGGER = Logger.getLogger(RestApiBase.class.getName());
    private final WebClient webClient;
    private final FtHandler ftHandler;
    private final JsonBuilderFactory jsonBuilderFactory;
    private final JsonReaderFactory jsonReaderFactory;
    private final JsonWriterFactory jsonWriterFactory;

    protected RestApiBase(RestApi.Builder<?, ?> builder) {
        this.webClient = builder.webClient();
        this.ftHandler = builder.ftHandler();
        this.jsonBuilderFactory = builder.jsonBuilderFactory();
        this.jsonReaderFactory = builder.jsonReaderFactory();
        this.jsonWriterFactory = builder.jsonWriterFactory();
    }

    @Override
    public <T extends ApiResponse> Single<T> invoke(Http.RequestMethod method, String path, ApiRequest<?> request, ApiResponse.Builder<?, T> responseBuilder) {
        String requestId = this.requestId(request);
        LOGGER.finest(() -> requestId + ": Invoking " + method + " on path " + path + " no entity expected.");
        return this.ftHandler.invoke(this.responseSupplier(method, path, request, requestId)).flatMapSingle(response -> this.handleResponse(path, request, method, requestId, (WebClientResponse)response, responseBuilder));
    }

    @Override
    public <T extends ApiEntityResponse> Single<T> invokeWithResponse(Http.RequestMethod method, String path, ApiRequest<?> request, ApiEntityResponse.Builder<?, T, JsonObject> responseBuilder) {
        String requestId = this.requestId(request);
        LOGGER.finest(() -> requestId + ": Invoking " + method + " on path " + path + " JSON entity expected.");
        Supplier<Single<WebClientResponse>> responseSupplier = this.responseSupplier(method, path, request, requestId);
        return this.ftHandler.invoke(responseSupplier).flatMapSingle(response -> this.handleJsonResponse(path, request, method, requestId, (WebClientResponse)response, responseBuilder));
    }

    @Override
    public <T extends ApiResponse> Single<T> invokeBytesRequest(Http.RequestMethod method, String path, ApiRequest<?> request, Flow.Publisher<DataChunk> byteRequest, ApiResponse.Builder<?, T> responseBuilder) {
        String requestId = this.requestId(request);
        LOGGER.finest(() -> requestId + ": Invoking " + method + " on path " + path + " with bytes request");
        WebClientRequestBuilder requestBuilder = this.webClient.method(method).path(path);
        this.addHeaders(requestBuilder, path, request, method, requestId);
        this.addQueryParams(requestBuilder, path, request, method, requestId);
        Supplier<Single<WebClientResponse>> responseSupplier = this.requestBytesPayload(path, request, method, requestId, requestBuilder, byteRequest);
        return this.ftHandler.invoke(responseSupplier).flatMapSingle(response -> this.handleResponse(path, request, method, requestId, (WebClientResponse)response, responseBuilder));
    }

    @Override
    public <R, T extends ApiOptionalResponse<R>> Single<T> invokePublisherResponse(Http.RequestMethod method, String path, ApiRequest<?> request, ApiOptionalResponse.BuilderBase<?, T, Multi<DataChunk>, R> responseBuilder) {
        String requestId = this.requestId(request);
        LOGGER.finest(() -> requestId + ": Invoking " + method + " on path " + path + " with publisher response");
        request.responseMediaType(request.responseMediaType().orElse(MediaType.WILDCARD));
        Supplier<Single<WebClientResponse>> responseSupplier = this.responseSupplier(method, path, request, requestId);
        return this.ftHandler.invoke(responseSupplier).flatMapSingle(response -> this.handlePublisherResponse(path, request, method, requestId, (WebClientResponse)response, responseBuilder));
    }

    @Override
    public <R, T extends ApiOptionalResponse<R>> Single<T> invokeBytesResponse(Http.RequestMethod method, String path, ApiRequest<?> request, ApiOptionalResponse.BuilderBase<?, T, byte[], R> responseBuilder) {
        String requestId = this.requestId(request);
        LOGGER.finest(() -> requestId + ": Invoking " + method + " on path " + path + " with bytes response");
        request.responseMediaType(request.responseMediaType().orElse(MediaType.WILDCARD));
        Supplier<Single<WebClientResponse>> responseSupplier = this.responseSupplier(method, path, request, requestId);
        return this.ftHandler.invoke(responseSupplier).flatMapSingle(response -> this.handleBytesResponse(path, request, method, requestId, (WebClientResponse)response, responseBuilder));
    }

    @Override
    public <R, T extends ApiOptionalResponse<R>> Single<T> invokeOptional(Http.RequestMethod method, String path, ApiRequest<?> request, ApiOptionalResponse.BuilderBase<?, T, JsonObject, R> responseBuilder) {
        String requestId = this.requestId(request);
        LOGGER.finest(() -> requestId + ": Invoking " + method + " on path " + path + " with optional response");
        return this.ftHandler.invoke(this.responseSupplier(method, path, request, requestId)).flatMapSingle(response -> this.handleOptionalJsonResponse(path, request, method, requestId, (WebClientResponse)response, responseBuilder));
    }

    protected Supplier<Single<WebClientResponse>> responseSupplier(Http.RequestMethod method, String path, ApiRequest<?> request, String requestId) {
        WebClientRequestBuilder requestBuilder = this.webClient.method(method).path(path);
        this.addHeaders(requestBuilder, path, request, method, requestId);
        this.addQueryParams(requestBuilder, path, request, method, requestId);
        Optional<JsonObject> payload = request.toJson(this.jsonBuilderFactory);
        Supplier<Single<WebClientResponse>> responseSupplier = payload.isPresent() ? this.requestJsonPayload(path, request, method, requestId, requestBuilder, payload.get()) : this.requestPayload(path, request, method, requestId, requestBuilder);
        return responseSupplier;
    }

    protected void addQueryParams(WebClientRequestBuilder requestBuilder, String path, ApiRequest<?> request, Http.RequestMethod method, String requestId) {
        request.queryParams().forEach((name, values) -> {
            if (values.size() == 1) {
                requestBuilder.queryParam(name, new String[]{(String)values.iterator().next()});
            } else {
                requestBuilder.queryParam(name, values.toArray(new String[0]));
            }
        });
    }

    protected void addHeaders(WebClientRequestBuilder requestBuilder, String path, ApiRequest<?> request, Http.RequestMethod method, String requestId) {
        WebClientRequestHeaders headers = requestBuilder.headers();
        request.headers().forEach((arg_0, arg_1) -> ((WebClientRequestHeaders)headers).add(arg_0, arg_1));
    }

    protected <R, T extends ApiOptionalResponse<R>> Single<T> handleBytesResponse(String path, ApiRequest<?> request, Http.RequestMethod method, String requestId, WebClientResponse response, ApiOptionalResponse.BuilderBase<?, T, byte[], R> responseBuilder) {
        boolean isEntityExpected;
        Http.ResponseStatus status = response.status();
        boolean success = Http.ResponseStatus.Family.of((int)status.code()) == Http.ResponseStatus.Family.SUCCESSFUL || this.isSuccess(path, request, method, requestId, status);
        boolean bl = isEntityExpected = Http.ResponseStatus.Family.of((int)status.code()) == Http.ResponseStatus.Family.SUCCESSFUL || this.isEntityExpected(path, request, method, requestId, status);
        if (success) {
            if (isEntityExpected) {
                return response.content().map(DataChunk::bytes).collect((Collector)new Collector<byte[], byte[]>(){
                    private final ByteArrayOutputStream baos = new ByteArrayOutputStream();

                    public void collect(byte[] item) {
                        this.baos.writeBytes(item);
                    }

                    public byte[] value() {
                        return this.baos.toByteArray();
                    }
                }).map(it -> (ApiOptionalResponse)((ApiOptionalResponse.BuilderBase)((ApiOptionalResponse.BuilderBase)((ApiOptionalResponse.BuilderBase)responseBuilder.headers((Headers)response.headers())).status(status)).requestId(requestId)).entity(it).build());
            }
            return this.emptyResponse(path, request, method, requestId, response, responseBuilder);
        }
        return this.errorResponse(path, request, method, requestId, response);
    }

    protected <R, T extends ApiOptionalResponse<R>> Single<T> handlePublisherResponse(String path, ApiRequest<?> request, Http.RequestMethod method, String requestId, WebClientResponse response, ApiOptionalResponse.BuilderBase<?, T, Multi<DataChunk>, R> responseBuilder) {
        boolean isEntityExpected;
        Http.ResponseStatus status = response.status();
        boolean success = Http.ResponseStatus.Family.of((int)status.code()) == Http.ResponseStatus.Family.SUCCESSFUL || this.isSuccess(path, request, method, requestId, status);
        boolean bl = isEntityExpected = Http.ResponseStatus.Family.of((int)status.code()) == Http.ResponseStatus.Family.SUCCESSFUL || this.isEntityExpected(path, request, method, requestId, status);
        if (success) {
            if (isEntityExpected) {
                return Single.just((Object)((ApiOptionalResponse)((ApiOptionalResponse.BuilderBase)((ApiOptionalResponse.BuilderBase)((ApiOptionalResponse.BuilderBase)responseBuilder.headers((Headers)response.headers())).status(status)).requestId(requestId)).entity(response.content()).build()));
            }
            return this.emptyResponse(path, request, method, requestId, response, responseBuilder);
        }
        return this.errorResponse(path, request, method, requestId, response);
    }

    protected boolean isSuccess(String path, ApiRequest<?> request, Http.RequestMethod method, String requestId, Http.ResponseStatus status) {
        if (status == Http.Status.NOT_FOUND_404) {
            return true;
        }
        if (status == Http.Status.NOT_MODIFIED_304) {
            return true;
        }
        Http.ResponseStatus.Family family = Http.ResponseStatus.Family.of((int)status.code());
        switch (family) {
            case REDIRECTION: 
            case CLIENT_ERROR: 
            case SERVER_ERROR: {
                return false;
            }
        }
        return true;
    }

    protected boolean isEntityExpected(String path, ApiRequest<?> request, Http.RequestMethod method, String requestId, Http.ResponseStatus status) {
        Http.ResponseStatus.Family family = Http.ResponseStatus.Family.of((int)status.code());
        switch (family) {
            case REDIRECTION: 
            case CLIENT_ERROR: 
            case SERVER_ERROR: {
                return false;
            }
        }
        return true;
    }

    protected <R, T extends ApiOptionalResponse<R>> Single<T> handleOptionalJsonResponse(String path, ApiRequest<?> request, Http.RequestMethod method, String requestId, WebClientResponse response, ApiOptionalResponse.BuilderBase<?, T, JsonObject, R> responseBuilder) {
        boolean isEntityExpected;
        Http.ResponseStatus status = response.status();
        boolean success = Http.ResponseStatus.Family.of((int)status.code()) == Http.ResponseStatus.Family.SUCCESSFUL || this.isSuccess(path, request, method, requestId, status);
        boolean bl = isEntityExpected = Http.ResponseStatus.Family.of((int)status.code()) == Http.ResponseStatus.Family.SUCCESSFUL || this.isEntityExpected(path, request, method, requestId, status);
        if (success) {
            if (isEntityExpected) {
                LOGGER.finest(() -> requestId + ": " + method + " on path " + path + " returned " + status);
                if (response.headers().contentLength().orElse(-1L) == 0L) {
                    return this.emptyResponse(path, request, method, requestId, response, responseBuilder);
                }
                return response.content().as(JsonObject.class).map(json -> (ApiOptionalResponse)this.jsonOkResponse(path, request, method, requestId, response, (JsonObject)json, responseBuilder)).onErrorResumeWithSingle(it -> Single.error((Throwable)this.readErrorFailedEntity(path, request, method, requestId, response, (Throwable)it)));
            }
            return this.emptyResponse(path, request, method, requestId, response, responseBuilder);
        }
        LOGGER.finest(() -> requestId + ": " + method + " on path " + path + " failed " + status);
        return this.errorResponse(path, request, method, requestId, response);
    }

    protected <T> Single<T> emptyResponse(String path, ApiRequest<?> request, Http.RequestMethod method, String requestId, WebClientResponse response, ResponseBuilder<?, T, ?> responseBuilder) {
        return Single.just((Object)responseBuilder.headers((Headers)response.headers()).status(response.status()).requestId(requestId).build());
    }

    protected <T> T jsonOkResponse(String path, ApiRequest<?> request, Http.RequestMethod method, String requestId, WebClientResponse response, JsonObject json, ResponseBuilder<?, T, JsonObject> responseBuilder) {
        return (T)responseBuilder.headers((Headers)response.headers()).status(response.status()).requestId(requestId).entity((JsonObject)json).build();
    }

    protected <T extends ApiEntityResponse> Single<T> handleJsonResponse(String path, ApiRequest<?> request, Http.RequestMethod method, String requestId, WebClientResponse response, ApiEntityResponse.Builder<?, T, JsonObject> responseBuilder) {
        Http.ResponseStatus status = response.status();
        if (Http.ResponseStatus.Family.of((int)status.code()) == Http.ResponseStatus.Family.SUCCESSFUL) {
            LOGGER.finest(() -> requestId + ": " + method + " on path " + path + " returned " + status);
            return response.content().as(JsonObject.class).map(json -> (ApiEntityResponse)this.jsonOkResponse(path, request, method, requestId, response, (JsonObject)json, responseBuilder)).onErrorResumeWithSingle(it -> Single.error((Throwable)this.readErrorFailedEntity(path, request, method, requestId, response, (Throwable)it)));
        }
        LOGGER.finest(() -> requestId + ": " + method + " on path " + path + " failed " + status);
        return this.errorResponse(path, request, method, requestId, response);
    }

    protected <T extends ApiResponse> Single<T> handleResponse(String path, ApiRequest<?> request, Http.RequestMethod method, String requestId, WebClientResponse response, ApiResponse.Builder<?, T> responseBuilder) {
        boolean success;
        Http.ResponseStatus status = response.status();
        boolean bl = success = Http.ResponseStatus.Family.of((int)status.code()) == Http.ResponseStatus.Family.SUCCESSFUL;
        if (success) {
            LOGGER.finest(() -> requestId + ": " + method + " on path " + path + " returned " + status);
            return this.noEntityOkResponse(path, request, method, requestId, response, responseBuilder);
        }
        LOGGER.finest(() -> requestId + ": " + method + " on path " + path + " failed " + status);
        return this.errorResponse(path, request, method, requestId, response);
    }

    protected <T extends ApiResponse> Single<T> errorResponse(String path, ApiRequest<?> request, Http.RequestMethod method, String requestId, WebClientResponse response) {
        if (response.headers().contentLength().orElse(-1L) == 0L) {
            return Single.error((Throwable)this.readError(path, request, method, requestId, response));
        }
        AtomicBoolean processedError = new AtomicBoolean();
        return response.content().as(String.class).flatMapSingle(string -> {
            try {
                JsonObject json = this.jsonReaderFactory.createReader((Reader)new StringReader((String)string)).readObject();
                Single error = Single.error((Throwable)this.readError(path, request, method, requestId, response, json));
                processedError.set(true);
                return error;
            }
            catch (Exception e) {
                Single error = Single.error((Throwable)this.readError(path, request, method, requestId, response, (String)string));
                processedError.set(true);
                return error;
            }
        }).onErrorResumeWithSingle(it -> {
            if (processedError.get()) {
                return Single.error((Throwable)it);
            }
            return Single.error((Throwable)this.readErrorFailedEntity(path, request, method, requestId, response, (Throwable)it));
        });
    }

    protected Throwable readErrorFailedEntity(String path, ApiRequest<?> request, Http.RequestMethod method, String requestId, WebClientResponse response, Throwable throwable) {
        return ((RestException.Builder)((RestException.Builder)((RestException.Builder)((RestException.Builder)((RestException.Builder)RestException.builder().cause(throwable)).requestId(requestId)).status(response.status())).message("Failed to invoke " + method + " on path " + path + " " + response.status().code() + ", failed to read entity.")).headers((Headers)response.headers())).build();
    }

    protected Throwable readError(String path, ApiRequest<?> request, Http.RequestMethod method, String requestId, WebClientResponse response, String entity) {
        LOGGER.finest(() -> requestId + ": request failed for path " + path + ", error response: " + entity);
        return ((RestException.Builder)((RestException.Builder)((RestException.Builder)((RestException.Builder)RestException.builder().requestId(requestId)).status(response.status())).message("Failed to invoke " + method + " on path " + path + " " + response.status().code())).headers((Headers)response.headers())).build();
    }

    protected Throwable readError(String path, ApiRequest<?> request, Http.RequestMethod method, String requestId, WebClientResponse response) {
        LOGGER.finest(() -> requestId + ": request failed for path " + path);
        String messagePrefix = "Failed to invoke " + method + " on path " + path + " " + response.status().code();
        return ((RestException.Builder)((RestException.Builder)((RestException.Builder)((RestException.Builder)RestException.builder().requestId(requestId)).status(response.status())).message(messagePrefix)).headers((Headers)response.headers())).build();
    }

    protected Throwable readError(String path, ApiRequest<?> request, Http.RequestMethod method, String requestId, WebClientResponse response, JsonObject errorObject) {
        LOGGER.finest(() -> requestId + ": request failed for path " + path + ", error object: " + errorObject);
        String messagePrefix = "Failed to invoke " + method + " on path " + path + " " + response.status().code();
        return ((RestException.Builder)((RestException.Builder)((RestException.Builder)((RestException.Builder)RestException.builder().requestId(requestId)).status(response.status())).message(messagePrefix)).headers((Headers)response.headers())).build();
    }

    protected <T extends ApiResponse> Single<T> noEntityOkResponse(String path, ApiRequest<?> request, Http.RequestMethod method, String requestId, WebClientResponse response, ApiResponse.Builder<?, T> responseBuilder) {
        return Single.just((Object)((ApiResponse)((ApiResponse.Builder)((ApiResponse.Builder)responseBuilder.headers((Headers)response.headers())).status(response.status())).requestId(requestId).build()));
    }

    protected Supplier<Single<WebClientResponse>> requestJsonPayload(String path, ApiRequest<?> request, Http.RequestMethod method, String requestId, WebClientRequestBuilder requestBuilder, JsonObject jsonObject) {
        requestBuilder.accept(new MediaType[]{request.responseMediaType().orElse(MediaType.APPLICATION_JSON)});
        requestBuilder.contentType(request.requestMediaType().orElse(MediaType.APPLICATION_JSON));
        AtomicBoolean updated = new AtomicBoolean();
        return () -> {
            if (updated.compareAndSet(false, true)) {
                Single<WebClientRequestBuilder> res = this.updateRequestBuilder(requestBuilder, path, request, method, requestId, jsonObject);
                return res.flatMapSingle(it -> it.submit((Object)jsonObject));
            }
            return requestBuilder.submit((Object)jsonObject);
        };
    }

    protected Supplier<Single<WebClientResponse>> requestBytesPayload(String path, ApiRequest<?> request, Http.RequestMethod method, String requestId, WebClientRequestBuilder requestBuilder, Flow.Publisher<DataChunk> publisher) {
        requestBuilder.accept(new MediaType[]{request.responseMediaType().orElse(MediaType.APPLICATION_JSON)});
        requestBuilder.contentType(request.requestMediaType().orElse(MediaType.APPLICATION_OCTET_STREAM));
        AtomicBoolean updated = new AtomicBoolean();
        return () -> {
            if (updated.compareAndSet(false, true)) {
                return this.updateRequestBuilderBytesPayload(requestBuilder, path, request, method, requestId).flatMapSingle(it -> it.submit(publisher));
            }
            return requestBuilder.submit(publisher);
        };
    }

    protected Supplier<Single<WebClientResponse>> requestPayload(String path, ApiRequest<?> request, Http.RequestMethod method, String requestId, WebClientRequestBuilder requestBuilder) {
        AtomicBoolean updated = new AtomicBoolean();
        return () -> {
            if (updated.compareAndSet(false, true)) {
                Single<WebClientRequestBuilder> res = this.updateRequestBuilder(requestBuilder, path, request, method, requestId);
                return res.flatMapSingle(WebClientRequestBuilder::request);
            }
            return requestBuilder.request();
        };
    }

    protected Single<WebClientRequestBuilder> updateRequestBuilder(WebClientRequestBuilder requestBuilder, String path, ApiRequest<?> request, Http.RequestMethod method, String requestId) {
        return this.updateRequestBuilderCommon(requestBuilder, path, request, method, requestId);
    }

    protected Single<WebClientRequestBuilder> updateRequestBuilderBytesPayload(WebClientRequestBuilder requestBuilder, String path, ApiRequest<?> request, Http.RequestMethod method, String requestId) {
        return this.updateRequestBuilderCommon(requestBuilder, path, request, method, requestId);
    }

    protected Single<WebClientRequestBuilder> updateRequestBuilder(WebClientRequestBuilder requestBuilder, String path, ApiRequest<?> request, Http.RequestMethod method, String requestId, JsonObject jsonObject) {
        return this.updateRequestBuilderCommon(requestBuilder, path, request, method, requestId);
    }

    protected Single<WebClientRequestBuilder> updateRequestBuilderCommon(WebClientRequestBuilder requestBuilder, String path, ApiRequest<?> request, Http.RequestMethod method, String requestId) {
        return Single.just((Object)requestBuilder);
    }

    protected String requestId(ApiRequest<?> restRequest) {
        return restRequest.requestId().or(() -> Contexts.context().flatMap(it -> it.get(SpanContext.class)).map(SpanContext::toTraceId)).orElseGet(UUID.randomUUID()::toString);
    }

    protected WebClient webClient() {
        return this.webClient;
    }

    protected FtHandler ftHandler() {
        return this.ftHandler;
    }

    protected JsonBuilderFactory jsonBuilderFactory() {
        return this.jsonBuilderFactory;
    }

    protected JsonReaderFactory jsonReaderFactory() {
        return this.jsonReaderFactory;
    }

    protected JsonWriterFactory jsonWriterFactory() {
        return this.jsonWriterFactory;
    }
}

