/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.integrations.common.rest;

import io.helidon.common.http.MediaType;
import io.helidon.integrations.common.rest.ApiRequest;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public abstract class ApiRestRequest<T extends ApiRequest<T>>
implements ApiRequest<T> {
    private final Map<String, List<String>> queryParams = new HashMap<String, List<String>>();
    private final Map<String, List<String>> headers = new HashMap<String, List<String>>();
    private MediaType requestMediaType;
    private MediaType responseMediaType;
    private String requestId;

    protected ApiRestRequest() {
    }

    @Override
    public T addHeader(String name, String ... value) {
        this.headers.put(name, Arrays.asList(value));
        return this.me();
    }

    @Override
    public T addQueryParam(String name, String ... value) {
        this.queryParams.put(name, Arrays.asList(value));
        return this.me();
    }

    @Override
    public T requestMediaType(MediaType mediaType) {
        this.requestMediaType = mediaType;
        return this.me();
    }

    @Override
    public T responseMediaType(MediaType mediaType) {
        this.responseMediaType = mediaType;
        return this.me();
    }

    @Override
    public T requestId(String requestId) {
        this.requestId = requestId;
        return this.me();
    }

    @Override
    public Map<String, List<String>> headers() {
        return Map.copyOf(this.headers);
    }

    @Override
    public Map<String, List<String>> queryParams() {
        return Map.copyOf(this.queryParams);
    }

    @Override
    public Optional<MediaType> requestMediaType() {
        return Optional.ofNullable(this.requestMediaType);
    }

    @Override
    public Optional<MediaType> responseMediaType() {
        return Optional.ofNullable(this.responseMediaType);
    }

    @Override
    public Optional<String> requestId() {
        return Optional.ofNullable(this.requestId);
    }

    protected T me() {
        return (T)this;
    }
}

