/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.integrations.cdi.referencecountedcontext;

import io.helidon.integrations.cdi.delegates.DelegatingInjectionTarget;
import io.helidon.integrations.cdi.delegates.DelegatingProducer;
import io.helidon.integrations.cdi.referencecountedcontext.ReferenceCounted;
import io.helidon.integrations.cdi.referencecountedcontext.ReferenceCountedContext;
import jakarta.enterprise.context.spi.Context;
import jakarta.enterprise.context.spi.Contextual;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.spi.AfterBeanDiscovery;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.enterprise.inject.spi.InjectionPoint;
import jakarta.enterprise.inject.spi.InjectionTarget;
import jakarta.enterprise.inject.spi.ProcessBean;
import jakarta.enterprise.inject.spi.ProcessInjectionTarget;
import jakarta.enterprise.inject.spi.ProcessProducer;
import jakarta.enterprise.inject.spi.Producer;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class ReferenceCountedExtension
implements Extension {
    private final Set<Bean<?>> referenceCountedBeans = new HashSet();

    private <T> void ensureManagedBeanOriginatedDisposalsDecrementReferenceCounts(@Observes ProcessInjectionTarget<T> event, BeanManager beanManager) {
        InjectionTarget delegate = event.getInjectionTarget();
        event.setInjectionTarget((InjectionTarget)new DelegatingInjectionTarget(delegate, this.createReferenceCountingProducer((Producer<T>)delegate, beanManager)));
    }

    private <T> void trackReferenceCountedTypes(@Observes ProcessBean<T> event) {
        Bean bean = event.getBean();
        if (ReferenceCounted.class.isAssignableFrom(bean.getScope())) {
            this.referenceCountedBeans.add(bean);
        }
    }

    private <T, X> void ensureProducerOriginatedDisposalDecrementReferenceCounts(@Observes ProcessProducer<T, X> event, BeanManager beanManager) {
        event.setProducer(this.createReferenceCountingProducer(event.getProducer(), beanManager));
    }

    private void installReferenceCountedContext(@Observes AfterBeanDiscovery event) {
        event.addContext((Context)new ReferenceCountedContext());
    }

    private <T> Producer<T> createReferenceCountingProducer(Producer<T> delegate, final BeanManager beanManager) {
        DelegatingProducer returnValue = new DelegatingProducer<T>(delegate){
            private volatile Set<InjectionPoint> referenceCountedInjectionPoints;

            public void dispose(T instance) {
                Set<Object> referenceCountedInjectionPoints = this.referenceCountedInjectionPoints;
                if (referenceCountedInjectionPoints == null) {
                    Set injectionPoints = this.getInjectionPoints();
                    if (injectionPoints.isEmpty()) {
                        referenceCountedInjectionPoints = Collections.emptySet();
                    } else {
                        referenceCountedInjectionPoints = new HashSet<InjectionPoint>();
                        for (InjectionPoint injectionPoint : injectionPoints) {
                            Set qualifiers = injectionPoint.getQualifiers();
                            Set beans = qualifiers == null || qualifiers.isEmpty() ? beanManager.getBeans(injectionPoint.getType(), new Annotation[0]) : beanManager.getBeans(injectionPoint.getType(), qualifiers.toArray(new Annotation[qualifiers.size()]));
                            assert (beans != null);
                            Bean bean = beanManager.resolve(beans);
                            assert (bean != null);
                            if (!ReferenceCountedExtension.this.referenceCountedBeans.contains(bean)) continue;
                            assert (ReferenceCounted.class.equals((Object)bean.getScope())) : "Unexpected scope: " + bean.getScope() + "; bean: " + bean;
                            referenceCountedInjectionPoints.add(injectionPoint);
                        }
                    }
                    this.referenceCountedInjectionPoints = referenceCountedInjectionPoints;
                }
                for (InjectionPoint injectionPoint : referenceCountedInjectionPoints) {
                    Set qualifiers = injectionPoint.getQualifiers();
                    Set beans = qualifiers == null || qualifiers.isEmpty() ? beanManager.getBeans(injectionPoint.getType(), new Annotation[0]) : beanManager.getBeans(injectionPoint.getType(), qualifiers.toArray(new Annotation[qualifiers.size()]));
                    assert (beans != null);
                    Bean bean = beanManager.resolve(beans);
                    assert (bean != null);
                    assert (ReferenceCounted.class.equals((Object)bean.getScope())) : "Unexpected scope: " + bean.getScope() + "; bean: " + bean;
                    ReferenceCountedContext context = ReferenceCountedContext.getInstanceFrom(beanManager);
                    assert (context != null);
                    context.decrementReferenceCount((Contextual<?>)bean);
                }
                super.dispose(instance);
            }
        };
        return returnValue;
    }
}

