/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.http.encoding;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Generated;
import io.helidon.common.config.Config;
import io.helidon.common.config.ConfigBuilderSupport;
import io.helidon.http.encoding.ContentEncoding;
import io.helidon.http.encoding.ContentEncodingContext;
import io.helidon.http.encoding.ContentEncodingContextConfigBlueprint;
import io.helidon.http.encoding.spi.ContentEncodingProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;

@Generated(value="io.helidon.builder.codegen.BuilderCodegen", trigger="io.helidon.http.encoding.ContentEncodingContextConfigBlueprint")
public interface ContentEncodingContextConfig
extends ContentEncodingContextConfigBlueprint,
Prototype.Api {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ContentEncodingContextConfig instance) {
        return (Builder)ContentEncodingContextConfig.builder().from(instance);
    }

    public static ContentEncodingContextConfig create(Config config) {
        return ((Builder)ContentEncodingContextConfig.builder().config(config)).buildPrototype();
    }

    public static ContentEncodingContextConfig create() {
        return ContentEncodingContextConfig.builder().buildPrototype();
    }

    public static class Builder
    extends BuilderBase<Builder, ContentEncodingContextConfig>
    implements io.helidon.common.Builder<Builder, ContentEncodingContext> {
        private Builder() {
        }

        public ContentEncodingContextConfig buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.ContentEncodingContextConfigImpl(this);
        }

        public ContentEncodingContext build() {
            return ContentEncodingContext.create(this.buildPrototype());
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends ContentEncodingContextConfig>
    implements ConfigBuilderSupport.ConfiguredBuilder<BUILDER, PROTOTYPE> {
        private final List<ContentEncoding> contentEncodings = new ArrayList<ContentEncoding>();
        private boolean contentEncodingsDiscoverServices = true;
        private boolean isContentEncodingsMutated;
        private Config config;

        protected BuilderBase() {
        }

        public BUILDER from(ContentEncodingContextConfig prototype) {
            if (!this.isContentEncodingsMutated) {
                this.contentEncodings.clear();
            }
            this.addContentEncodings(prototype.contentEncodings());
            this.contentEncodingsDiscoverServices = false;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER from(BuilderBase<?, ?> builder) {
            if (this.isContentEncodingsMutated) {
                if (builder.isContentEncodingsMutated) {
                    this.addContentEncodings(builder.contentEncodings);
                }
            } else {
                this.contentEncodings.clear();
                this.addContentEncodings(builder.contentEncodings);
            }
            this.contentEncodingsDiscoverServices = builder.contentEncodingsDiscoverServices;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER config(Config config) {
            Objects.requireNonNull(config);
            this.config = config;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER contentEncodingsDiscoverServices(boolean discoverServices) {
            this.contentEncodingsDiscoverServices = discoverServices;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER contentEncodings(List<? extends ContentEncoding> contentEncodings) {
            Objects.requireNonNull(contentEncodings);
            this.isContentEncodingsMutated = true;
            this.contentEncodings.clear();
            this.contentEncodings.addAll(contentEncodings);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addContentEncodings(List<? extends ContentEncoding> contentEncodings) {
            Objects.requireNonNull(contentEncodings);
            this.isContentEncodingsMutated = true;
            this.contentEncodings.addAll(contentEncodings);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addContentEncoding(ContentEncoding contentEncoding) {
            Objects.requireNonNull(contentEncoding);
            this.contentEncodings.add(contentEncoding);
            this.isContentEncodingsMutated = true;
            return (BUILDER)((BuilderBase)this.self());
        }

        public List<ContentEncoding> contentEncodings() {
            return this.contentEncodings;
        }

        public Optional<Config> config() {
            return Optional.ofNullable(this.config);
        }

        public String toString() {
            return "ContentEncodingContextConfigBuilder{contentEncodings=" + String.valueOf(this.contentEncodings) + "}";
        }

        protected void preBuildPrototype() {
            Config config = this.config == null ? Config.empty() : this.config;
            this.addContentEncodings(ConfigBuilderSupport.discoverServices((Config)config, (String)"content-encodings", ContentEncodingProvider.class, ContentEncoding.class, (boolean)this.contentEncodingsDiscoverServices, this.contentEncodings));
        }

        protected void validatePrototype() {
        }

        protected static class ContentEncodingContextConfigImpl
        implements ContentEncodingContextConfig,
        Supplier<ContentEncodingContext> {
            private final List<ContentEncoding> contentEncodings;

            protected ContentEncodingContextConfigImpl(BuilderBase<?, ?> builder) {
                this.contentEncodings = List.copyOf(builder.contentEncodings());
            }

            public ContentEncodingContext build() {
                return ContentEncodingContext.create(this);
            }

            @Override
            public ContentEncodingContext get() {
                return this.build();
            }

            @Override
            public List<ContentEncoding> contentEncodings() {
                return this.contentEncodings;
            }

            public String toString() {
                return "ContentEncodingContextConfig{contentEncodings=" + String.valueOf(this.contentEncodings) + "}";
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ContentEncodingContextConfig)) {
                    return false;
                }
                ContentEncodingContextConfig other = (ContentEncodingContextConfig)o;
                return Objects.equals(this.contentEncodings, other.contentEncodings());
            }

            public int hashCode() {
                return Objects.hash(this.contentEncodings);
            }
        }
    }
}

