/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.declarative.codegen.validation;

import io.helidon.codegen.CodegenException;
import io.helidon.codegen.CodegenUtil;
import io.helidon.codegen.ElementInfoPredicates;
import io.helidon.codegen.classmodel.ClassModel;
import io.helidon.codegen.classmodel.Constructor;
import io.helidon.codegen.classmodel.Method;
import io.helidon.codegen.classmodel.Parameter;
import io.helidon.common.types.AccessModifier;
import io.helidon.common.types.Annotation;
import io.helidon.common.types.Annotations;
import io.helidon.common.types.ElementKind;
import io.helidon.common.types.TypeInfo;
import io.helidon.common.types.TypeName;
import io.helidon.common.types.TypeNames;
import io.helidon.common.types.TypedElementInfo;
import io.helidon.declarative.codegen.DeclarativeTypes;
import io.helidon.declarative.codegen.validation.ValidationHelper;
import io.helidon.declarative.codegen.validation.ValidationTypes;
import io.helidon.service.codegen.FieldHandler;
import io.helidon.service.codegen.RegistryRoundContext;
import io.helidon.service.codegen.ServiceCodegenTypes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.function.Predicate;

class ValidatedTypeGenerator {
    private static final TypeName GENERATOR = TypeName.create(ValidatedTypeGenerator.class);
    private final RegistryRoundContext roundContext;
    private final Collection<TypeName> constraintAnnotations;

    ValidatedTypeGenerator(RegistryRoundContext roundContext, Collection<TypeName> constraintAnnotations) {
        this.roundContext = roundContext;
        this.constraintAnnotations = constraintAnnotations;
    }

    void process(TypeInfo typeInfo) {
        TypeName triggerType = typeInfo.typeName();
        TypeName generatedType = ((TypeName.Builder)((TypeName.Builder)TypeName.builder().packageName(triggerType.packageName())).className(triggerType.classNameWithEnclosingNames().replace('.', '_') + "__Validated")).build();
        ClassModel.Builder classModel = (ClassModel.Builder)((ClassModel.Builder)((ClassModel.Builder)((ClassModel.Builder)ClassModel.builder().type(generatedType).copyright(CodegenUtil.copyright((TypeName)GENERATOR, (TypeName)triggerType, (TypeName)generatedType)).addAnnotation(CodegenUtil.generatedAnnotation((TypeName)GENERATOR, (TypeName)triggerType, (TypeName)generatedType, (String)"0", (String)""))).addAnnotation(DeclarativeTypes.SINGLETON_ANNOTATION)).accessModifier(AccessModifier.PACKAGE_PRIVATE).addAnnotation(((Annotation.Builder)((Annotation.Builder)Annotation.builder().typeName(ServiceCodegenTypes.SERVICE_ANNOTATION_NAMED_BY_TYPE)).putValue("value", (Object)triggerType)).build())).addInterface(((TypeName.Builder)((TypeName.Builder)TypeName.builder().from(ValidationTypes.TYPE_VALIDATOR)).addTypeArgument(triggerType)).build());
        Constructor.Builder constructor = (Constructor.Builder)Constructor.builder().accessModifier(AccessModifier.PACKAGE_PRIVATE);
        FieldHandler fieldHandler = FieldHandler.create((ClassModel.Builder)classModel, (Constructor.Builder)constructor);
        Method.Builder checkMethod = (Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)Method.builder().addAnnotation(Annotations.OVERRIDE)).accessModifier(AccessModifier.PUBLIC)).name("check")).addParameter(context -> ((Parameter.Builder)context.name("validation__ctx")).type(ValidationTypes.VALIDATION_CONTEXT))).addParameter(instance -> ((Parameter.Builder)instance.name("validation__instance")).type(triggerType))).addContentLine();
        ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)checkMethod.addContent("try (var validation__typeScope = validation__ctx.scope(")).addContent(ValidationTypes.CONSTRAINT_VIOLATION_LOCATION)).addContent(".TYPE, ")).addContent(triggerType)).addContentLine(".class.getName())) {")).addContentLine();
        if (typeInfo.kind() == ElementKind.RECORD) {
            this.processValidatedRecord(generatedType, this.constraintAnnotations, typeInfo, classModel, fieldHandler, checkMethod);
        } else if (typeInfo.kind() == ElementKind.CLASS) {
            this.processValidatedClass(generatedType, this.constraintAnnotations, typeInfo, classModel, fieldHandler, checkMethod);
        } else if (typeInfo.kind() == ElementKind.INTERFACE) {
            this.processValidatedInterface(generatedType, this.constraintAnnotations, typeInfo, classModel, fieldHandler, checkMethod);
        } else {
            throw new CodegenException(ValidationTypes.VALIDATION_VALIDATED.fqName() + " annotation on illegal type. Only record, class, or interface are currently supported.", (Object)typeInfo);
        }
        checkMethod.addContentLine("}");
        classModel.addConstructor(constructor);
        classModel.addMethod(checkMethod);
        this.roundContext.addGeneratedType(generatedType, classModel, GENERATOR, new Object[0]);
    }

    private void processValidatedRecord(TypeName generatedType, Collection<TypeName> constraintAnnotations, TypeInfo type, ClassModel.Builder classModel, FieldHandler fieldHandler, Method.Builder checkMethod) {
        ArrayList<Property> recordComponents = new ArrayList<Property>();
        type.elementInfo().stream().filter(it -> it.kind() == ElementKind.RECORD_COMPONENT).filter(it -> ValidationHelper.needsWork(constraintAnnotations, it)).forEach(element -> {
            String propertyName = element.elementName();
            Property property = new Property(propertyName, "check" + CodegenUtil.capitalize((String)propertyName), element.typeName());
            recordComponents.add(property);
            ((Method.Builder)((Method.Builder)((Method.Builder)checkMethod.addContent(property.checkMethodName())).addContent("(validation__ctx, validation__instance.")).addContent(propertyName)).addContentLine("());");
            this.addCheckMethod(generatedType, classModel, constraintAnnotations, fieldHandler, "RECORD_COMPONENT", (TypedElementInfo)element, propertyName);
        });
        checkMethod.addContentLine();
        this.addCheckWithPropertyNameMethods(classModel, type.typeName(), recordComponents);
    }

    private void processValidatedClass(TypeName generatedType, Collection<TypeName> constraintAnnotations, TypeInfo type, ClassModel.Builder classModel, FieldHandler fieldHandler, Method.Builder checkMethod) {
        ArrayList<Property> properties = new ArrayList<Property>();
        type.elementInfo().stream().filter(ElementInfoPredicates::isMethod).filter(Predicate.not(ElementInfoPredicates::isPrivate)).filter(Predicate.not(ElementInfoPredicates::isStatic)).filter(ElementInfoPredicates::hasNoArgs).filter(Predicate.not(ElementInfoPredicates::isVoid)).filter(it -> ValidationHelper.needsWork(constraintAnnotations, it)).forEach(element -> {
            String propertyName = element.elementName();
            if (ValidatedTypeGenerator.isPropertyGetter(propertyName)) {
                propertyName = ValidatedTypeGenerator.nameFromPropertyGetter(propertyName);
            }
            Property property = new Property(propertyName, "check" + CodegenUtil.capitalize((String)propertyName), element.typeName(), element.elementName());
            properties.add(property);
            ((Method.Builder)((Method.Builder)((Method.Builder)checkMethod.addContent(property.checkMethodName())).addContent("(validation__ctx, validation__instance.")).addContent(element.elementName())).addContentLine("());");
            this.addCheckMethod(generatedType, classModel, constraintAnnotations, fieldHandler, "PROPERTY", (TypedElementInfo)element, propertyName);
        });
        type.elementInfo().stream().filter(ElementInfoPredicates::isField).filter(Predicate.not(ElementInfoPredicates::isPrivate)).filter(Predicate.not(ElementInfoPredicates::isStatic)).filter(it -> ValidationHelper.needsWork(constraintAnnotations, it)).forEach(element -> {
            String propertyName = element.elementName();
            Property property = new Property(propertyName, "check" + CodegenUtil.capitalize((String)propertyName), element.typeName(), false);
            properties.add(property);
            ((Method.Builder)((Method.Builder)((Method.Builder)checkMethod.addContent(property.checkMethodName())).addContent("(validation__ctx, validation__instance.")).addContent(propertyName)).addContentLine(");");
            this.addCheckMethod(generatedType, classModel, constraintAnnotations, fieldHandler, "FIELD", (TypedElementInfo)element, propertyName);
        });
        checkMethod.addContentLine();
        this.addCheckWithPropertyNameMethods(classModel, type.typeName(), properties);
    }

    private void processValidatedInterface(TypeName generatedType, Collection<TypeName> constraintAnnotations, TypeInfo type, ClassModel.Builder classModel, FieldHandler fieldHandler, Method.Builder checkMethod) {
        ArrayList<Property> properties = new ArrayList<Property>();
        type.elementInfo().stream().filter(ElementInfoPredicates::isMethod).filter(Predicate.not(ElementInfoPredicates::isPrivate)).filter(ElementInfoPredicates::hasNoArgs).filter(Predicate.not(ElementInfoPredicates::isVoid)).filter(it -> ValidationHelper.needsWork(constraintAnnotations, it)).forEach(element -> {
            String propertyName = element.elementName();
            if (ValidatedTypeGenerator.isPropertyGetter(propertyName)) {
                propertyName = ValidatedTypeGenerator.nameFromPropertyGetter(propertyName);
            }
            Property property = new Property(propertyName, "check" + CodegenUtil.capitalize((String)propertyName), element.typeName(), element.elementName());
            properties.add(property);
            ((Method.Builder)((Method.Builder)((Method.Builder)checkMethod.addContent(property.checkMethodName())).addContent("(validation__ctx, validation__instance.")).addContent(element.elementName())).addContentLine("());");
            this.addCheckMethod(generatedType, classModel, constraintAnnotations, fieldHandler, "PROPERTY", (TypedElementInfo)element, propertyName);
        });
        checkMethod.addContentLine();
        this.addCheckWithPropertyNameMethods(classModel, type.typeName(), properties);
    }

    private static boolean isPropertyGetter(String propertyName) {
        return propertyName.startsWith("get") && propertyName.length() > 3 && Character.isUpperCase(propertyName.charAt(3));
    }

    private static String nameFromPropertyGetter(String propertyName) {
        propertyName = propertyName.substring(3);
        char firstChar = propertyName.charAt(0);
        if (propertyName.length() == 1) {
            return String.valueOf(Character.toLowerCase(firstChar));
        }
        if (!Character.isUpperCase(propertyName.charAt(1))) {
            return Character.toLowerCase(firstChar) + propertyName.substring(1);
        }
        return propertyName;
    }

    private void addCheckWithPropertyNameMethods(ClassModel.Builder classModel, TypeName triggerType, List<Property> properties) {
        Method.Builder checkProperty = (Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)Method.builder().name("check")).accessModifier(AccessModifier.PUBLIC)).addAnnotation(Annotations.OVERRIDE)).addParameter(context -> ((Parameter.Builder)context.name("ctx")).type(ValidationTypes.VALIDATION_CONTEXT))).addParameter(instance -> ((Parameter.Builder)instance.name("instance")).type(triggerType))).addParameter(propertyName -> ((Parameter.Builder)propertyName.name("propertyName")).type(TypeNames.STRING))).addContentLine("switch (propertyName) {");
        for (Property property : properties) {
            ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)checkProperty.addContent("case ")).addContentLiteral(property.name())).addContent(" -> ")).addContent(property.checkMethodName())).addContent("(ctx, (")).addContent(property.type().boxed())).addContent(") instance.")).addContent(property.getterName())).addContent(property.method() ? "()" : "")).addContentLine(");");
        }
        ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)checkProperty.addContent("default -> throw new ")).addContent(ValidationTypes.VALIDATION_EXCEPTION)).addContent("(")).addContentLiteral("Invalid property name: ")).addContentLine(" + propertyName);")).addContentLine("};");
        classModel.addMethod(checkProperty);
        Method.Builder checkPropertyValue = (Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)Method.builder().name("checkProperty")).accessModifier(AccessModifier.PUBLIC)).addAnnotation(Annotations.OVERRIDE)).addParameter(context -> ((Parameter.Builder)context.name("ctx")).type(ValidationTypes.VALIDATION_CONTEXT))).addParameter(propertyName -> ((Parameter.Builder)propertyName.name("propertyName")).type(TypeNames.STRING))).addParameter(value -> ((Parameter.Builder)value.name("value")).type(TypeNames.OBJECT))).addContentLine("switch (propertyName) {");
        for (Property property : properties) {
            ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)checkPropertyValue.addContent("case ")).addContentLiteral(property.name())).addContent(" -> ")).addContent(property.checkMethodName())).addContent("(ctx, (")).addContent(property.type().boxed())).addContentLine(") value);");
        }
        ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)checkPropertyValue.addContent("default -> throw new ")).addContent(ValidationTypes.VALIDATION_EXCEPTION)).addContent("(")).addContentLiteral("Invalid property name: ")).addContentLine(" + propertyName);")).addContentLine("};");
        classModel.addMethod(checkPropertyValue);
    }

    private void addCheckMethod(TypeName generatedType, ClassModel.Builder classModel, Collection<TypeName> constraintAnnotations, FieldHandler fieldHandler, String location, TypedElementInfo element, String propertyName) {
        classModel.addMethod(propertyCheck -> ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)propertyCheck.name("check" + CodegenUtil.capitalize((String)propertyName))).accessModifier(AccessModifier.PRIVATE)).addParameter(context -> ((Parameter.Builder)context.name("validation__ctx")).type(ValidationTypes.VALIDATION_CONTEXT))).addParameter(value -> ((Parameter.Builder)value.name("value")).type(element.typeName()))).update(it -> this.processValidatedElement(generatedType, constraintAnnotations, fieldHandler, (Method.Builder)it, location, element)));
    }

    private void processValidatedElement(TypeName generatedType, Collection<TypeName> constraintAnnotations, FieldHandler fieldHandler, Method.Builder checkMethod, String location, TypedElementInfo element) {
        ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)checkMethod.addContent("try (var scope__" + location.toLowerCase(Locale.ROOT) + CodegenUtil.capitalize((String)element.elementName()) + " = validation__ctx.scope(")).addContent(ValidationTypes.CONSTRAINT_VIOLATION_LOCATION)).addContent(".")).addContent(location)).addContent(", ")).addContentLiteral(element.elementName())).addContentLine(")) {");
        TypeName typeName = element.typeName();
        ValidationHelper.addValidationOfTypeArguments(generatedType, constraintAnnotations, checkMethod, fieldHandler, element, "value");
        if (element.hasAnnotation(ValidationTypes.VALIDATION_VALID)) {
            String validatorField = ValidationHelper.addTypeValidator(fieldHandler, typeName);
            ValidationHelper.addValidationOfValid(checkMethod, validatorField, "value");
        }
        for (TypeName constraintAnnotation : constraintAnnotations) {
            element.findAnnotation(constraintAnnotation).ifPresent(annotation -> ValidationHelper.addValidationOfConstraint(generatedType, fieldHandler, checkMethod, annotation, location, element, "value"));
        }
        checkMethod.addContentLine("}");
    }

    private record Property(String name, String checkMethodName, TypeName type, boolean method, String getterName) {
        Property(String name, String checkMethodName, TypeName type) {
            this(name, checkMethodName, type, true, name);
        }

        Property(String name, String checkMethodName, TypeName type, boolean method) {
            this(name, checkMethodName, type, method, name);
        }

        Property(String name, String checkMethodName, TypeName type, String getterName) {
            this(name, checkMethodName, type, true, getterName);
        }
    }
}

