/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.declarative.codegen.tracing;

import io.helidon.codegen.CodegenException;
import io.helidon.codegen.ElementInfoPredicates;
import io.helidon.common.types.Annotation;
import io.helidon.common.types.ElementSignature;
import io.helidon.common.types.TypeInfo;
import io.helidon.common.types.TypeName;
import io.helidon.common.types.TypedElementInfo;
import io.helidon.declarative.codegen.tracing.TracedHandler;
import io.helidon.declarative.codegen.tracing.TracingTypes;
import io.helidon.service.codegen.RegistryCodegenContext;
import io.helidon.service.codegen.RegistryRoundContext;
import io.helidon.service.codegen.spi.RegistryCodegenExtension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;

class TracingExtension
implements RegistryCodegenExtension {
    public static final String DEFAULT_NAME_TEMPLATE = "%1$s.%2$s";
    public static final String DEFAULT_SPAN_KIND = "INTERNAL";
    static final TypeName GENERATOR = TypeName.create(TracingExtension.class);
    private final RegistryCodegenContext ctx;

    TracingExtension(RegistryCodegenContext ctx) {
        this.ctx = ctx;
    }

    public void process(RegistryRoundContext roundContext) {
        Collection roundTypes = roundContext.types();
        HashMap<TypeName, TypeInfo> usedTypes = new HashMap<TypeName, TypeInfo>();
        for (TypeInfo roundType : roundTypes) {
            usedTypes.put(roundType.typeName(), roundType);
        }
        Collection annotatedTypes = roundContext.annotatedTypes(TracingTypes.ANNOTATION_TRACED);
        Collection annotatedElements = roundContext.annotatedElements(TracingTypes.ANNOTATION_TRACED);
        HashMap<TypeName, TracedElements> tracedElements = new HashMap<TypeName, TracedElements>();
        for (TypeInfo type : annotatedTypes) {
            TracedElements tracedElementValue = tracedElements.computeIfAbsent(type.typeName(), k -> new TracedElements(type, new HashMap<ElementSignature, TypedElementInfo>()));
            Map<ElementSignature, TypedElementInfo> map = tracedElementValue.elements();
            type.elementInfo().stream().filter(ElementInfoPredicates::isMethod).filter(Predicate.not(ElementInfoPredicates::isStatic)).filter(Predicate.not(ElementInfoPredicates::isPrivate)).forEach(element -> map.put(element.signature(), (TypedElementInfo)element));
        }
        for (TypedElementInfo element2 : annotatedElements) {
            TypeInfo type = this.typeForElement(roundContext, usedTypes, element2);
            tracedElements.computeIfAbsent(type.typeName(), k -> new TracedElements(type, new HashMap<ElementSignature, TypedElementInfo>())).elements().put(element2.signature(), element2);
        }
        TracedHandler handler = new TracedHandler(roundContext);
        for (Map.Entry tracedEntry : tracedElements.entrySet()) {
            TypeName serviceType = (TypeName)tracedEntry.getKey();
            TracedElements tracedElementValue = (TracedElements)tracedEntry.getValue();
            TypeInfo serviceTypeInfo = tracedElementValue.type();
            Map<ElementSignature, TypedElementInfo> elements = tracedElementValue.elements();
            int index = 0;
            for (TypedElementInfo element3 : elements.values()) {
                this.processElement(handler, serviceTypeInfo, serviceType, element3, index);
                ++index;
            }
        }
    }

    private void processElement(TracedHandler handler, TypeInfo serviceTypeInfo, TypeName serviceType, TypedElementInfo element, int index) {
        String value;
        String key;
        List tagsAnnotations;
        Annotation traced;
        String nameTemplate = DEFAULT_NAME_TEMPLATE;
        LinkedHashMap<String, String> tags = new LinkedHashMap<String, String>();
        String spanKind = DEFAULT_SPAN_KIND;
        Optional maybeTraced = serviceTypeInfo.findAnnotation(TracingTypes.ANNOTATION_TRACED);
        if (maybeTraced.isPresent()) {
            traced = (Annotation)maybeTraced.get();
            nameTemplate = traced.value().filter(Predicate.not(DEFAULT_NAME_TEMPLATE::equals)).filter(Predicate.not(String::isBlank)).orElse(nameTemplate);
            spanKind = traced.stringValue("kind").filter(Predicate.not(DEFAULT_SPAN_KIND::equals)).orElse(spanKind);
            tagsAnnotations = traced.annotationValues("tags").orElseGet(List::of);
            for (Annotation tagsAnnotation : tagsAnnotations) {
                key = (String)tagsAnnotation.stringValue("key").orElseThrow(() -> new CodegenException("Missing key in tags annotation", element.originatingElementValue()));
                value = (String)tagsAnnotation.stringValue("value").orElseThrow(() -> new CodegenException("Missing value in tags annotation", element.originatingElementValue()));
                tags.put(key, value);
            }
        }
        if ((maybeTraced = element.findAnnotation(TracingTypes.ANNOTATION_TRACED)).isPresent()) {
            traced = (Annotation)maybeTraced.get();
            nameTemplate = traced.value().filter(Predicate.not(DEFAULT_NAME_TEMPLATE::equals)).filter(Predicate.not(String::isBlank)).orElse(nameTemplate);
            spanKind = traced.stringValue("kind").filter(Predicate.not(DEFAULT_SPAN_KIND::equals)).orElse(spanKind);
            tagsAnnotations = traced.annotationValues("tags").orElseGet(List::of);
            for (Annotation tagsAnnotation : tagsAnnotations) {
                key = (String)tagsAnnotation.stringValue("key").orElseThrow(() -> new CodegenException("Missing key in tags annotation", element.originatingElementValue()));
                value = (String)tagsAnnotation.stringValue("value").orElseThrow(() -> new CodegenException("Missing value in tags annotation", element.originatingElementValue()));
                tags.put(key, value);
            }
        }
        String className = serviceType.fqName();
        String methodName = element.elementName();
        String spanName = String.format(nameTemplate, className, methodName);
        ArrayList<TagParam> tagParams = new ArrayList<TagParam>();
        int i = 0;
        for (TypedElementInfo param : element.parameterArguments()) {
            if (param.hasAnnotation(TracingTypes.ANNOTATION_TAG_PARAM)) {
                String tagName = param.elementName();
                Annotation tagParam = param.annotation(TracingTypes.ANNOTATION_TAG_PARAM);
                tagName = tagParam.value().filter(Predicate.not(String::isBlank)).orElse(tagName);
                tagParams.add(new TagParam(i, element.typeName(), tagName));
            }
            ++i;
        }
        handler.handle(serviceType, element, index, spanName, spanKind, tags, tagParams);
    }

    private TypeInfo typeForElement(RegistryRoundContext roundContext, Map<TypeName, TypeInfo> usedTypes, TypedElementInfo element) {
        TypeName enclosing = (TypeName)element.enclosingType().orElseThrow(() -> new CodegenException("Annotated element does not have an enclosing type", element.originatingElementValue()));
        TypeInfo typeInfo = usedTypes.get(enclosing);
        if (typeInfo != null) {
            return typeInfo;
        }
        typeInfo = (TypeInfo)roundContext.typeInfo(enclosing).orElseThrow(() -> new CodegenException("Cannot find enclosing type " + enclosing.fqName(), element.originatingElementValue()));
        usedTypes.put(enclosing, typeInfo);
        return typeInfo;
    }

    private record TracedElements(TypeInfo type, Map<ElementSignature, TypedElementInfo> elements) {
    }

    record TagParam(int index, TypeName type, String name) {
    }
}

