/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.declarative.codegen.metrics;

import io.helidon.codegen.CodegenUtil;
import io.helidon.codegen.classmodel.ClassModel;
import io.helidon.codegen.classmodel.Constructor;
import io.helidon.codegen.classmodel.Field;
import io.helidon.codegen.classmodel.Method;
import io.helidon.codegen.classmodel.Parameter;
import io.helidon.codegen.classmodel.TypeArgument;
import io.helidon.common.types.AccessModifier;
import io.helidon.common.types.Annotation;
import io.helidon.common.types.Annotations;
import io.helidon.common.types.ElementSignature;
import io.helidon.common.types.TypeInfo;
import io.helidon.common.types.TypeName;
import io.helidon.common.types.TypeNames;
import io.helidon.common.types.TypedElementInfo;
import io.helidon.declarative.codegen.DeclarativeTypes;
import io.helidon.declarative.codegen.metrics.MetricsExtension;
import io.helidon.declarative.codegen.metrics.MetricsTypes;
import io.helidon.service.codegen.RegistryRoundContext;
import io.helidon.service.codegen.ServiceCodegenTypes;
import java.util.List;
import java.util.concurrent.Callable;

class TimedHandler {
    private final RegistryRoundContext ctx;

    TimedHandler(RegistryRoundContext ctx) {
        this.ctx = ctx;
    }

    void handle(TypeInfo typeInfo, TypedElementInfo element, int counter) {
        TypeName type = typeInfo.typeName();
        String className = type.className() + "__TimedInterceptor" + (String)(counter != 0 ? "_" + counter : "");
        TypeName generatedType = ((TypeName.Builder)((TypeName.Builder)TypeName.builder().packageName(type.packageName())).className(className)).build();
        Annotation named = ((Annotation.Builder)((Annotation.Builder)Annotation.builder().typeName(ServiceCodegenTypes.SERVICE_ANNOTATION_NAMED)).value(type.fqName() + "." + element.signature().text())).build();
        ClassModel.Builder classModel = (ClassModel.Builder)((ClassModel.Builder)((ClassModel.Builder)((ClassModel.Builder)ClassModel.builder().type(generatedType).copyright(CodegenUtil.copyright((TypeName)MetricsExtension.GENERATOR, (TypeName)MetricsExtension.GENERATOR, (TypeName)generatedType)).addAnnotation(CodegenUtil.generatedAnnotation((TypeName)MetricsExtension.GENERATOR, (TypeName)MetricsExtension.GENERATOR, (TypeName)generatedType, (String)"0", (String)""))).addAnnotation(DeclarativeTypes.SINGLETON_ANNOTATION)).addAnnotation(named)).accessModifier(AccessModifier.PACKAGE_PRIVATE).addInterface(ServiceCodegenTypes.INTERCEPTION_ELEMENT_INTERCEPTOR);
        classModel.addField(timerField -> ((Field.Builder)timerField.type(MetricsTypes.TIMER).name("timer")).isFinal(true).accessModifier(AccessModifier.PRIVATE));
        Annotation annotation = element.annotation(MetricsTypes.ANNOTATION_TIMED);
        String name = MetricsExtension.name(annotation, type, element);
        List<MetricsExtension.Tag> tags = MetricsExtension.tags(this.ctx, type, element, annotation);
        String scope = MetricsExtension.scope(annotation);
        String description = MetricsExtension.description(annotation, MetricsTypes.ANNOTATION_TIMED, type, element);
        String unit = annotation.stringValue("unit").orElse("none");
        Constructor.Builder ctr = (Constructor.Builder)((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)Constructor.builder().addAnnotation(Annotation.create((TypeName)ServiceCodegenTypes.SERVICE_ANNOTATION_INJECT))).addParameter(registry -> registry.type(MetricsTypes.METER_REGISTRY).name("meterRegistry"))).addContent("this.timer = meterRegistry.getOrCreate(")).addContent(MetricsTypes.TIMER)).addContent(".builder(")).addContentLiteral(name)).addContentLine(")")).increaseContentPadding()).increaseContentPadding()).addContent(".description(")).addContentLiteral(description)).addContentLine(")")).addContent(".scope(")).addContentLiteral(scope)).addContentLine(")")).addContent(".baseUnit(")).addContentLiteral(unit)).addContentLine(")");
        MetricsExtension.addTagsToBuilder(ctr, tags);
        ((Constructor.Builder)((Constructor.Builder)ctr.decreaseContentPadding()).decreaseContentPadding()).addContentLine(");");
        classModel.addConstructor(ctr);
        TypeName typeV = TypeName.createFromGenericDeclaration((String)"V");
        TypeName chainType = ((TypeName.Builder)TypeName.builder((TypeName)ServiceCodegenTypes.INTERCEPTION_CHAIN).addTypeArgument(typeV)).build();
        classModel.addMethod(proceed -> ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)proceed.addGenericArgument(TypeArgument.create((TypeName)typeV)).addAnnotation(Annotations.OVERRIDE)).accessModifier(AccessModifier.PUBLIC)).returnType(typeV).name("proceed")).addParameter(ctx -> ((Parameter.Builder)ctx.name("ctx")).type(ServiceCodegenTypes.INTERCEPTION_CONTEXT))).addParameter(chain -> ((Parameter.Builder)chain.name("chain")).type(chainType))).addParameter(args -> ((Parameter.Builder)args.name("args")).type(((TypeName.Builder)TypeName.builder((TypeName)TypeNames.OBJECT).vararg(true)).build()))).addThrows(thr -> thr.type(Exception.class))).addContent("return timer.record((")).addContent(Callable.class)).addContentLine("<V>) () -> chain.proceed(args));"));
        this.addToString(classModel, type, element.signature());
        this.ctx.addGeneratedType(generatedType, classModel, MetricsExtension.GENERATOR, new Object[0]);
    }

    private void addToString(ClassModel.Builder classModel, TypeName serviceType, ElementSignature signature) {
        classModel.addMethod(toString -> ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)toString.accessModifier(AccessModifier.PUBLIC)).returnType(TypeNames.STRING).name("toString")).addAnnotation(Annotations.OVERRIDE)).addContent("return \"Timed interceptor for ")).addContent(serviceType.fqName())).addContent(".")).addContent(signature.text())).addContentLine("\";"));
    }
}

