/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.declarative.codegen.faulttolerance;

import io.helidon.codegen.CodegenException;
import io.helidon.codegen.CodegenUtil;
import io.helidon.codegen.classmodel.ClassModel;
import io.helidon.codegen.classmodel.Field;
import io.helidon.common.types.AccessModifier;
import io.helidon.common.types.Annotation;
import io.helidon.common.types.TypeInfo;
import io.helidon.common.types.TypeName;
import io.helidon.common.types.TypedElementInfo;
import io.helidon.declarative.codegen.DeclarativeTypes;
import io.helidon.declarative.codegen.faulttolerance.FtTypes;
import io.helidon.service.codegen.RegistryCodegenContext;
import io.helidon.service.codegen.RegistryRoundContext;
import io.helidon.service.codegen.ServiceCodegenTypes;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

abstract class FtHandler {
    private final RegistryCodegenContext ctx;
    private final TypeName annotation;
    private final TypeName generator;

    FtHandler(RegistryCodegenContext ctx, TypeName annotation) {
        this.ctx = ctx;
        this.annotation = annotation;
        this.generator = TypeName.create(this.getClass());
    }

    void process(RegistryRoundContext roundCtx, Map<TypeName, TypeInfo> types) {
        Collection elements = roundCtx.annotatedElements(this.annotation);
        int index = 0;
        for (TypedElementInfo element : elements) {
            TypeInfo enclosingType = this.enclosingType(types, element);
            TypeName generatedType = this.generatedTypeName(enclosingType.typeName(), element, index);
            this.process(roundCtx, enclosingType, element, element.annotation(this.annotation), generatedType, this.classBuilder(enclosingType.typeName(), element, generatedType));
            ++index;
        }
    }

    TypeInfo enclosingType(Map<TypeName, TypeInfo> types, TypedElementInfo element) {
        if (element.enclosingType().isEmpty()) {
            throw new CodegenException(this.annotation.className() + " annotation is only allowed on a method, yet this element does not have an enclosing type: " + element.elementName(), element.originatingElementValue());
        }
        TypeName enclosingType = (TypeName)element.enclosingType().get();
        TypeInfo typeInfo = types.get(enclosingType);
        if (typeInfo == null) {
            throw new CodegenException(this.annotation.className() + " annotation is expected on a type processed as part of this processing round, yet the type info is not available for type: " + enclosingType.fqName(), element.originatingElementValue());
        }
        return typeInfo;
    }

    abstract void process(RegistryRoundContext var1, TypeInfo var2, TypedElementInfo var3, Annotation var4, TypeName var5, ClassModel.Builder var6);

    Annotation namedAnnotation(TypeName enclosingTypeName, TypedElementInfo element) {
        return this.namedAnnotation(enclosingTypeName.fqName() + "." + element.signature().text());
    }

    Annotation namedAnnotation(String name) {
        return Annotation.create((TypeName)ServiceCodegenTypes.SERVICE_ANNOTATION_NAMED, (String)name);
    }

    void addType(RegistryRoundContext roundCtx, TypeName generatedType, ClassModel.Builder classModel, TypeName enclosingTypeName, TypedElementInfo element) {
        roundCtx.addGeneratedType(generatedType, classModel, enclosingTypeName, new Object[]{element.originatingElementValue()});
    }

    void addErrorChecker(ClassModel.Builder classModel, Annotation annotation, boolean addErrorCheckConstant) {
        List applyOn = annotation.typeValues("applyOn").orElseGet(List::of);
        List skipOn = annotation.typeValues("skipOn").orElseGet(List::of);
        classModel.addField(applyOnField -> ((Field.Builder)applyOnField.accessModifier(AccessModifier.PRIVATE).isFinal(true).isStatic(true).type(DeclarativeTypes.SET_OF_THROWABLES).name("APPLY_ON")).update(it -> this.throwableSet((Field.Builder)it, applyOn)));
        classModel.addField(skipOnField -> ((Field.Builder)skipOnField.accessModifier(AccessModifier.PRIVATE).isFinal(true).isStatic(true).type(DeclarativeTypes.SET_OF_THROWABLES).name("SKIP_ON")).update(it -> this.throwableSet((Field.Builder)it, skipOn)));
        if (addErrorCheckConstant) {
            classModel.addField(errorChecker -> ((Field.Builder)errorChecker.accessModifier(AccessModifier.PRIVATE).isFinal(true).isStatic(true).type(FtTypes.ERROR_CHECKER).name("ERROR_CHECKER")).addContent(FtTypes.ERROR_CHECKER).addContent(".create(SKIP_ON, APPLY_ON)"));
        }
    }

    private void throwableSet(Field.Builder field, List<TypeName> listOfThrowables) {
        ((Field.Builder)field.addContent(Set.class)).addContent(".of(");
        if (listOfThrowables.isEmpty()) {
            field.addContent(")");
            return;
        }
        field.addContentLine();
        ((Field.Builder)field.increaseContentPadding().increaseContentPadding().update(it -> {
            Iterator iterator = listOfThrowables.iterator();
            while (iterator.hasNext()) {
                it.addContent((TypeName)iterator.next()).addContent(".class");
                if (iterator.hasNext()) {
                    it.addContent(",");
                }
                it.addContentLine();
            }
        })).decreaseContentPadding().decreaseContentPadding().addContent(")");
    }

    private ClassModel.Builder classBuilder(TypeName enclosingType, TypedElementInfo element, TypeName generatedType) {
        return (ClassModel.Builder)((ClassModel.Builder)((ClassModel.Builder)((ClassModel.Builder)ClassModel.builder().accessModifier(AccessModifier.PACKAGE_PRIVATE).addAnnotation(DeclarativeTypes.SINGLETON_ANNOTATION)).addAnnotation(this.namedAnnotation(enclosingType, element))).addAnnotation(CodegenUtil.generatedAnnotation((TypeName)this.generator, (TypeName)enclosingType, (TypeName)generatedType, (String)"1", (String)""))).copyright(CodegenUtil.copyright((TypeName)this.generator, (TypeName)enclosingType, (TypeName)generatedType)).type(generatedType).sortStaticFields(false);
    }

    private TypeName generatedTypeName(TypeName typeName, TypedElementInfo element, int index) {
        return ((TypeName.Builder)((TypeName.Builder)TypeName.builder().packageName(typeName.packageName())).className(typeName.classNameWithEnclosingNames().replace('.', '_') + "_" + element.elementName() + (String)(index == 0 ? "" : "_" + index) + "__" + this.annotation.className())).build();
    }
}

